/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.callbacks;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.processes.core.callbacks.CallbackMonitor;
import org.eclipse.tcf.te.tcf.processes.core.callbacks.RefreshDoneGetChildren;
import org.eclipse.tcf.te.tcf.processes.core.model.ProcessTreeNode;

public class RefreshDoneGetContext
implements ISysMonitor.DoneGetContext,
IProcesses.DoneGetContext {
    String contextId;
    ProcessTreeNode parentNode;
    List<ProcessTreeNode> newNodes;
    ProcessTreeNode childNode;
    IProcesses.ProcessContext pContext;
    ISysMonitor.SysMonitorContext sContext;
    volatile boolean sysMonitorDone;
    volatile boolean processesDone;
    CallbackMonitor monitor;
    IChannel channel;

    public RefreshDoneGetContext(IChannel channel, List<ProcessTreeNode> newNodes, String contextId, CallbackMonitor monitor, ProcessTreeNode parentNode) {
        this.channel = channel;
        this.contextId = contextId;
        this.parentNode = parentNode;
        this.monitor = monitor;
        this.newNodes = newNodes;
        this.sysMonitorDone = false;
        this.processesDone = false;
    }

    public void doneGetContext(IToken token, Exception error, ISysMonitor.SysMonitorContext context) {
        if (error == null && context != null) {
            this.sContext = context;
        }
        this.sysMonitorDone = true;
        this.packNode();
    }

    private int searchChild(ProcessTreeNode childNode) {
        return this.searchInList(childNode, this.parentNode.getChildren());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int searchInList(ProcessTreeNode childNode, List<ProcessTreeNode> list) {
        List<ProcessTreeNode> list2 = list;
        synchronized (list2) {
            int i = 0;
            while (i < list.size()) {
                ProcessTreeNode node = list.get(i);
                if (childNode.id.equals(node.id)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
        if (error == null && context != null) {
            this.pContext = context;
        }
        this.processesDone = true;
        this.packNode();
    }

    private void packNode() {
        if (this.sysMonitorDone && this.processesDone) {
            if (this.sContext != null) {
                this.childNode = new ProcessTreeNode(this.parentNode, this.sContext);
                this.childNode.setProcessContext(this.pContext);
            } else if (this.pContext != null) {
                this.childNode = new ProcessTreeNode(this.parentNode, this.pContext);
                this.childNode.setSysMonitorContext(this.sContext);
            }
            if (this.childNode != null) {
                int index = this.searchChild(this.childNode);
                if (index != -1) {
                    ProcessTreeNode node = this.parentNode.getChildren().get(index);
                    if (this.sContext != null) {
                        node.updateSysMonitorContext(this.sContext);
                    }
                    if (this.pContext != null) {
                        node.setProcessContext(this.pContext);
                    }
                    this.childNode = node;
                    this.newNodes.add(this.childNode);
                    this.monitor.unlock(this.contextId, Status.OK_STATUS);
                } else {
                    ISysMonitor service = (ISysMonitor)this.channel.getRemoteService(ISysMonitor.class);
                    Assert.isNotNull((Object)service);
                    ConcurrentLinkedQueue<ProcessTreeNode> queue = new ConcurrentLinkedQueue<ProcessTreeNode>();
                    service.getChildren(this.childNode.id, (ISysMonitor.DoneGetChildren)new RefreshDoneGetChildren((ICallback)new Callback(){

                        protected void internalDone(Object caller, IStatus status) {
                            RefreshDoneGetContext.this.parentNode.addChild(RefreshDoneGetContext.this.childNode);
                            RefreshDoneGetContext.this.newNodes.add(RefreshDoneGetContext.this.childNode);
                            RefreshDoneGetContext.this.monitor.unlock(RefreshDoneGetContext.this.contextId, status);
                        }
                    }, queue, this.channel, service, this.childNode));
                }
            } else {
                this.monitor.unlock(this.contextId, Status.OK_STATUS);
            }
        }
    }
}

