/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.breakpoints;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tcf.internal.cdt.ui.Activator;
import org.eclipse.tcf.internal.cdt.ui.ImageCache;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.Messages;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFBreakpointScopeExtension;
import org.eclipse.ui.model.IWorkbenchAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreakpointScopeCategory
extends PlatformObject
implements IWorkbenchAdapter {
    private static Object[] EMPTY_CHILDREN_ARRAY = new Object[0];
    private String fFilter;
    private String fContextIds;

    public BreakpointScopeCategory(String filter, String contextIds) {
        this.fFilter = filter;
        this.fContextIds = contextIds;
    }

    public String getFilter() {
        return this.fFilter;
    }

    public String getContextIds() {
        return this.fContextIds;
    }

    void setFilter(String filter, String contextIds) {
        final List<ICBreakpoint> bps = this.findCategoryBreakpoints();
        this.fFilter = filter;
        this.fContextIds = contextIds;
        if (bps.isEmpty()) {
            return;
        }
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    for (ICBreakpoint bp : bps) {
                        BreakpointScopeCategory.this.getScopeExtension(bp).setPropertiesFilter(BreakpointScopeCategory.this.fFilter);
                        BreakpointScopeCategory.this.getScopeExtension(bp).setRawContextIds(BreakpointScopeCategory.this.fContextIds);
                    }
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    public String getLabel(Object o) {
        if (this.getFilter() != null) {
            return MessageFormat.format(Messages.BreakpointScopeCategory_filter_label, this.getFilter());
        }
        if (this.getContextIds() != null) {
            return MessageFormat.format(Messages.BreakpointScopeCategory_contexts_label, this.getContextIds());
        }
        return Messages.BreakpointScopeCategory_global_label;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return ImageCache.getImageDescriptor("icons/obj16/bp_scope.gif");
    }

    public Object[] getChildren(Object o) {
        return EMPTY_CHILDREN_ARRAY;
    }

    public Object getParent(Object o) {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BreakpointScopeCategory) {
            BreakpointScopeCategory other = (BreakpointScopeCategory)((Object)obj);
            return (this.getFilter() == null && other.getFilter() == null || this.getFilter() != null && this.getFilter().equals(other.getFilter())) && (this.getContextIds() == null && other.getContextIds() == null || this.getContextIds() != null && this.getContextIds().equals(other.getContextIds()));
        }
        return false;
    }

    public int hashCode() {
        return (this.getFilter() != null ? this.getFilter().hashCode() : 0) + (this.getContextIds() != null ? this.getContextIds().hashCode() : 0);
    }

    private List<ICBreakpoint> findCategoryBreakpoints() {
        IBreakpoint[] breakpoints;
        LinkedList<ICBreakpoint> categoryBreakpoints = new LinkedList<ICBreakpoint>();
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp = iBreakpointArray[n2];
            IMarker bpMarker = bp.getMarker();
            if (bp instanceof ICBreakpoint && bpMarker != null) {
                String filter = bpMarker.getAttribute("org.eclipse.tcf.debug.ContextQuery", null);
                String contextIds = bpMarker.getAttribute("org.eclipse.tcf.debug.ContextIds", null);
                if ((this.getFilter() == null && filter == null || this.getFilter() != null && this.getFilter().equals(filter)) && (this.getContextIds() == null && contextIds == null || this.getContextIds() != null && this.getContextIds().equals(contextIds))) {
                    categoryBreakpoints.add((ICBreakpoint)bp);
                }
            }
            ++n2;
        }
        return categoryBreakpoints;
    }

    private TCFBreakpointScopeExtension getScopeExtension(ICBreakpoint bp) throws CoreException {
        return (TCFBreakpointScopeExtension)bp.getExtension("org.eclipse.tcf.debug", TCFBreakpointScopeExtension.class);
    }
}

