/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.launch;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tcf.internal.cdt.launch.ContextSelection;
import org.eclipse.tcf.internal.cdt.ui.launch.PeerListControl;
import org.eclipse.tcf.internal.cdt.ui.launch.ProcessListControl;

public class ProcessSelectionDialog
extends Dialog {
    private ContextSelection fSelection;
    private ProcessListControl fContextList;

    protected ProcessSelectionDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    public void setSelection(ContextSelection selection) {
        this.fSelection = selection;
    }

    public ContextSelection getSelection() {
        return this.fSelection;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Select Peer and Context");
        super.configureShell(newShell);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.updateButtonState();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        new Label(composite, 0).setText("TCF Peers:");
        PeerListControl peerList = new PeerListControl(composite);
        new Label(composite, 0).setText("Contexts:");
        this.fContextList = new ProcessListControl(composite);
        peerList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss;
                Object element;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof PeerListControl.PeerInfo) {
                    ProcessSelectionDialog.this.handlePeerSelected((PeerListControl.PeerInfo)element);
                }
            }
        });
        this.fContextList.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessListControl.ProcessInfo contextInfo = ProcessSelectionDialog.this.fContextList.findProcessInfo((TreeItem)e.item);
                if (contextInfo != null) {
                    ProcessSelectionDialog.this.handleContextSelected(contextInfo);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
                if (ProcessSelectionDialog.this.getButton(0).isEnabled()) {
                    ProcessSelectionDialog.this.buttonPressed(0);
                }
            }
        });
        if (this.fSelection.fContextId != null) {
            this.fContextList.selectContext(this.fSelection.fContextId);
        }
        return composite;
    }

    private void updateButtonState() {
        this.getButton(0).setEnabled(this.fSelection.fContextId != null);
    }

    protected void handleContextSelected(ProcessListControl.ProcessInfo contextInfo) {
        this.fSelection.fContextId = contextInfo.id;
        this.updateButtonState();
    }

    protected void handlePeerSelected(PeerListControl.PeerInfo peerInfo) {
        this.fSelection.fPeerId = peerInfo.id;
        this.fContextList.setInput(peerInfo.peer);
    }
}

