/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.internal.utils;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.ui.interfaces.ILazyLoader;
import org.eclipse.tcf.te.ui.interfaces.ISearchMatcher;
import org.eclipse.tcf.te.ui.interfaces.ITreeSearcher;
import org.eclipse.tcf.te.ui.trees.Pending;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractSearcher
implements ITreeSearcher {
    static Method methodGetSortedChildren;
    protected TreeViewer fViewer;
    protected ILabelProvider fLabelProvider;
    protected ISearchMatcher fMatcher;

    static {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
            }

            public void run() throws Exception {
                methodGetSortedChildren = AbstractTreeViewer.class.getDeclaredMethod("getSortedChildren", Object.class);
                methodGetSortedChildren.setAccessible(true);
            }
        });
    }

    protected AbstractSearcher(TreeViewer viewer, ISearchMatcher matcher) {
        this.fViewer = viewer;
        this.fLabelProvider = (ILabelProvider)this.fViewer.getLabelProvider();
        this.fMatcher = matcher;
    }

    protected String getElementText(final Object element) {
        if (Display.getCurrent() != null) {
            if (element == this.fViewer.getInput()) {
                return "the root";
            }
            if (this.fLabelProvider != null) {
                return this.fLabelProvider.getText(element);
            }
            return element == null ? "" : element.toString();
        }
        final String[] result = new String[1];
        this.fViewer.getTree().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = AbstractSearcher.this.getElementText(element);
            }
        });
        return result[0];
    }

    protected Object[] getUpdatedChildren(Object parent, IProgressMonitor monitor) {
        if (parent instanceof Pending) {
            return new Object[0];
        }
        ILazyLoader lazyLoader = this.getLazyLoader(parent);
        if (lazyLoader != null && !lazyLoader.isDataLoaded()) {
            try {
                lazyLoader.loadData(monitor);
            }
            catch (Exception exception) {
                return new Object[0];
            }
        }
        Object[] children = this.getSortedChildren(parent);
        return children;
    }

    protected Object[] getSortedChildren(final Object parentElementOrTreePath) {
        if (Display.getCurrent() != null) {
            try {
                if (methodGetSortedChildren != null) {
                    return (Object[])methodGetSortedChildren.invoke((Object)this.fViewer, parentElementOrTreePath);
                }
            }
            catch (Exception exception) {}
            return new Object[0];
        }
        final Object[][] result = new Object[1][];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = AbstractSearcher.this.getSortedChildren(parentElementOrTreePath);
            }
        });
        return result[0];
    }

    private ILazyLoader getLazyLoader(Object element) {
        ILazyLoader loader = null;
        if (element instanceof ILazyLoader) {
            loader = (ILazyLoader)element;
        }
        if (loader == null && element instanceof IAdaptable) {
            loader = (ILazyLoader)((IAdaptable)element).getAdapter(ILazyLoader.class);
        }
        if (loader == null) {
            loader = (ILazyLoader)Platform.getAdapterManager().getAdapter(element, ILazyLoader.class);
        }
        return loader;
    }
}

