/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.columns;

import java.io.File;
import java.io.IOException;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.columns.ImageUpdateAdapter;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.columns.LabelProviderUpdateDaemon;

public class FileExtBasedImageUpdater
implements ImageUpdateAdapter {
    private LabelProviderUpdateDaemon updateDaemon;

    public FileExtBasedImageUpdater(LabelProviderUpdateDaemon daemon) {
        this.updateDaemon = daemon;
    }

    private String getFileExt(FSTreeNode node) {
        String name = node.name;
        String ext = "noext";
        int index = name.lastIndexOf(".");
        if (index != -1) {
            ext = name.substring(index + 1);
        }
        return ext;
    }

    private File getMirrorDir() {
        File tmpDir = this.updateDaemon.getTempDir();
        File mrrDir = new File(tmpDir, ".mrr");
        if (!mrrDir.exists() && !mrrDir.mkdirs()) {
            mrrDir = tmpDir;
        }
        return mrrDir;
    }

    @Override
    public String getImageKey(FSTreeNode node) {
        String ext = this.getFileExt(node);
        return "EXT_IMAGE@" + ext;
    }

    @Override
    public File getMirrorFile(FSTreeNode node) {
        String ext = this.getFileExt(node);
        File mrrDir = this.getMirrorDir();
        File file = new File(mrrDir, "mirror." + ext);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {}
        }
        return file;
    }

    @Override
    public File getImageFile(FSTreeNode node) {
        String ext = this.getFileExt(node);
        return this.updateDaemon.getTempImg(ext);
    }
}

