/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.streams;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.ui.terminals.streams.InputStreamMonitor;
import org.eclipse.tcf.te.ui.terminals.streams.OutputStreamMonitor;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.provider.TerminalConnectorImpl;

public abstract class AbstractStreamsConnector
extends TerminalConnectorImpl {
    private InputStreamMonitor stdInMonitor;
    private OutputStreamMonitor stdOutMonitor;
    private OutputStreamMonitor stdErrMonitor;

    protected void connectStreams(ITerminalControl terminalControl, OutputStream stdin, InputStream stdout, InputStream stderr, boolean localEcho, String lineSeparator) {
        Assert.isNotNull((Object)terminalControl);
        if (stdin != null) {
            this.stdInMonitor = this.createStdInMonitor(terminalControl, stdin, localEcho, lineSeparator);
            if (stdout == null && stderr == null && this instanceof IDisposable) {
                this.stdInMonitor.addDisposable((IDisposable)this);
            }
            this.stdInMonitor.startMonitoring();
        }
        if (stdout != null) {
            this.stdOutMonitor = this.createStdOutMonitor(terminalControl, stdout, lineSeparator);
            if (this instanceof IDisposable) {
                this.stdOutMonitor.addDisposable((IDisposable)this);
            }
            this.stdOutMonitor.startMonitoring();
        }
        if (stderr != null) {
            this.stdErrMonitor = this.createStdErrMonitor(terminalControl, stderr, lineSeparator);
            if (stdout == null && this instanceof IDisposable) {
                this.stdErrMonitor.addDisposable((IDisposable)this);
            }
            this.stdErrMonitor.startMonitoring();
        }
    }

    protected InputStreamMonitor createStdInMonitor(ITerminalControl terminalControl, OutputStream stdin, boolean localEcho, String lineSeparator) {
        return new InputStreamMonitor(terminalControl, stdin, localEcho, lineSeparator);
    }

    protected OutputStreamMonitor createStdOutMonitor(ITerminalControl terminalControl, InputStream stdout, String lineSeparator) {
        return new OutputStreamMonitor(terminalControl, stdout, lineSeparator);
    }

    protected OutputStreamMonitor createStdErrMonitor(ITerminalControl terminalControl, InputStream stderr, String lineSeparator) {
        return new OutputStreamMonitor(terminalControl, stderr, lineSeparator);
    }

    protected void doDisconnect() {
        if (this.stdInMonitor != null) {
            this.stdInMonitor.dispose();
            this.stdInMonitor = null;
        }
        if (this.stdOutMonitor != null) {
            this.stdOutMonitor.dispose();
            this.stdOutMonitor = null;
        }
        if (this.stdErrMonitor != null) {
            this.stdErrMonitor.dispose();
            this.stdErrMonitor = null;
        }
        super.doDisconnect();
    }

    public OutputStream getTerminalToRemoteStream() {
        return this.stdInMonitor;
    }
}

