/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.wire.serial;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.ui.controls.BaseEditBrowseTextControl;
import org.eclipse.tcf.te.ui.controls.help.IContextHelpIds;
import org.eclipse.tcf.te.ui.controls.net.RemoteHostAddressControl;
import org.eclipse.tcf.te.ui.controls.nls.Messages;
import org.eclipse.tcf.te.ui.controls.validator.NameOrIPValidator;
import org.eclipse.tcf.te.ui.controls.validator.PortNumberValidator;
import org.eclipse.tcf.te.ui.controls.validator.PortNumberVerifyListener;
import org.eclipse.tcf.te.ui.controls.validator.Validator;
import org.eclipse.tcf.te.ui.jface.dialogs.CustomTitleAreaDialog;

public class SerialPortAddressDialog
extends CustomTitleAreaDialog {
    BaseEditBrowseTextControl ttyControl;
    RemoteHostAddressControl addressControl;
    BaseEditBrowseTextControl portControl;
    Validator ttyValidator;
    Validator portValidator;
    List<String> ttyHistory;
    List<String> tcpHistory;
    String data = null;

    public SerialPortAddressDialog(Shell parentShell, String selected, List<String> ttyHistory, List<String> tcpHistory) {
        super(parentShell, IContextHelpIds.SERIAL_PORT_ADDRESS_DIALOG);
        this.ttyHistory = ttyHistory;
        this.tcpHistory = tcpHistory;
        this.data = selected;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setDialogTitle(Messages.SerialLinePanel_customSerialDevice_title);
        Composite container = (Composite)super.createDialogArea(parent);
        Composite ttyComp = new Composite(container, 0);
        GridLayout gl = new GridLayout();
        ttyComp.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        ttyComp.setLayoutData((Object)gd);
        this.ttyControl = new BaseEditBrowseTextControl(null);
        this.ttyControl.setLabelIsButton(true);
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean enable = SerialPortAddressDialog.this.ttyHistory != null && SerialPortAddressDialog.this.ttyHistory.contains(SerialPortAddressDialog.this.data);
                SerialPortAddressDialog.this.setTTYControlEnabled(enable);
                SerialPortAddressDialog.this.setTCPControlEnabled(!enable);
                SerialPortAddressDialog.this.onModify();
            }
        });
        this.ttyControl.setIsGroup(false);
        this.ttyControl.setEditFieldLabel(Messages.SerialLinePanel_hostTTYDevice_label);
        this.ttyControl.setHideBrowseButton(true);
        this.ttyControl.setupPanel(ttyComp);
        ((Button)this.ttyControl.getLabelControl()).addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ((Button)SerialPortAddressDialog.this.ttyControl.getLabelControl()).getSelection();
                SerialPortAddressDialog.this.setTTYControlEnabled(selected);
                SerialPortAddressDialog.this.setTCPControlEnabled(!selected);
                SerialPortAddressDialog.this.onModify();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ((Combo)this.ttyControl.getEditFieldControl()).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SerialPortAddressDialog.this.onModify();
            }
        });
        Composite tcpComp = new Composite(container, 0);
        gl = new GridLayout(4, true);
        tcpComp.setLayout((Layout)gl);
        gd = new GridData(768);
        tcpComp.setLayoutData((Object)gd);
        Composite tcpAddrComp = new Composite(tcpComp, 0);
        gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        tcpAddrComp.setLayout((Layout)gl);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        tcpAddrComp.setLayoutData((Object)gd);
        this.addressControl = new RemoteHostAddressControl(null){

            @Override
            public void modifyText(ModifyEvent e) {
                super.modifyText(e);
                SerialPortAddressDialog.this.onModify();
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                boolean selected = ((Button)SerialPortAddressDialog.this.addressControl.getLabelControl()).getSelection();
                SerialPortAddressDialog.this.setTTYControlEnabled(!selected);
                SerialPortAddressDialog.this.setTCPControlEnabled(selected);
                SerialPortAddressDialog.this.onModify();
            }

            @Override
            protected void setCheckResultMessage(int severity, String message) {
                SerialPortAddressDialog.this.setMessage(message, severity);
            }
        };
        this.addressControl.setLabelIsButton(true);
        this.addressControl.setIsGroup(false);
        this.addressControl.setEditFieldLabel(Messages.RemoteHostAddressControl_label);
        this.addressControl.setButtonLabel(Messages.RemoteHostAddressControl_button_label);
        this.addressControl.setupPanel(tcpAddrComp);
        Composite tcpPortComp = new Composite(tcpComp, 0);
        gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        tcpPortComp.setLayout((Layout)gl);
        gd = new GridData(768);
        tcpPortComp.setLayoutData((Object)gd);
        this.portControl = new BaseEditBrowseTextControl(null);
        this.portControl.setIsGroup(false);
        this.portControl.setEditFieldLabel(Messages.SerialPortAddressDialog_port);
        this.portControl.setHideBrowseButton(true);
        this.portControl.setupPanel(tcpPortComp);
        ((Combo)this.portControl.getEditFieldControl()).addVerifyListener((VerifyListener)new PortNumberVerifyListener(3));
        ((Combo)this.portControl.getEditFieldControl()).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SerialPortAddressDialog.this.onModify();
            }
        });
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean enable = SerialPortAddressDialog.this.tcpHistory != null && SerialPortAddressDialog.this.tcpHistory.contains(SerialPortAddressDialog.this.data);
                SerialPortAddressDialog.this.setTTYControlEnabled(!enable);
                SerialPortAddressDialog.this.setTCPControlEnabled(enable);
                SerialPortAddressDialog.this.onModify();
            }
        });
        this.ttyValidator = new Validator(1){
            private final Pattern fValidCharacters;
            {
                this.fValidCharacters = System.getProperty("os.name", "").toLowerCase().startsWith("windows") ? Pattern.compile("[\\w]+") : Pattern.compile("[\\w/]+");
            }

            @Override
            public boolean isValid(String newText) {
                this.setMessage(null);
                this.setMessageType(1);
                if (newText != null && newText.trim().length() > 0) {
                    Matcher matcher = this.fValidCharacters.matcher(newText);
                    if (!matcher.matches()) {
                        this.setMessage(Messages.SerialLinePanel_error_invalidCharactes, 3);
                    }
                } else if (newText != null) {
                    this.setMessage(Messages.SerialLinePanel_error_emptyHostTTYDevice, 1);
                }
                return this.getMessageType() != 3;
            }
        };
        this.ttyControl.setEditFieldValidator(this.ttyValidator);
        this.portValidator = new PortNumberValidator(7);
        this.portValidator.setMessageText("RegexValidator_Information_MissingValue", Messages.SerialPortAddressDialog_Information_MissingPort);
        this.portValidator.setMessageText("RegexValidator_Error_InvalidValue", Messages.SerialPortAddressDialog_Error_InvalidPort);
        this.portValidator.setMessageText("NumberValidator_Error_InvalidRange", Messages.SerialPortAddressDialog_Error_InvalidPortRange);
        this.portControl.setEditFieldValidator(this.portValidator);
        SerialPortAddressDialog.applyDialogFont((Control)container);
        this.setupData();
        return container;
    }

    private void setupData() {
        this.setTTYControlEnabled(true);
        this.setTCPControlEnabled(false);
        if (this.ttyHistory != null && !this.ttyHistory.isEmpty()) {
            for (String tty : this.ttyHistory) {
                this.ttyControl.addToEditFieldControlHistory(tty.trim());
                if (!tty.equals(this.data)) continue;
                this.ttyControl.setEditFieldControlText(tty.trim());
            }
        }
        if (this.tcpHistory != null && !this.tcpHistory.isEmpty()) {
            for (String tcp : this.tcpHistory) {
                String[] data = tcp.split(":");
                if (data.length > 1) {
                    this.addressControl.addToEditFieldControlHistory(data[1]);
                }
                if (data.length > 2) {
                    this.portControl.addToEditFieldControlHistory(data[2]);
                }
                if (!tcp.equals(this.data)) continue;
                this.setTTYControlEnabled(false);
                this.setTCPControlEnabled(true);
                if (data.length > 1) {
                    this.addressControl.setEditFieldControlText(data[1]);
                }
                if (data.length <= 2) continue;
                this.portControl.setEditFieldControlText(data[2]);
            }
        }
        this.onModify();
    }

    void setTTYControlEnabled(boolean enable) {
        this.ttyControl.setLabelControlSelection(enable);
        this.ttyControl.getEditFieldControl().setEnabled(enable);
    }

    void setTCPControlEnabled(boolean enable) {
        this.addressControl.setLabelControlSelection(enable);
        this.addressControl.getEditFieldControl().setEnabled(enable);
        this.addressControl.getButtonControl().setEnabled(enable);
        this.portControl.setEnabled(enable);
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.setButtonEnabled(0, false);
        return control;
    }

    protected void okPressed() {
        this.data = ((Button)this.ttyControl.getLabelControl()).getSelection() ? this.ttyControl.getEditFieldControlText() : "tcp:" + this.addressControl.getEditFieldControlText() + ":" + this.portControl.getEditFieldControlText();
        super.okPressed();
    }

    void onModify() {
        this.setMessage(null);
        boolean ttySelected = ((Button)this.ttyControl.getLabelControl()).getSelection();
        boolean isTTYValid = this.ttyControl.isValid();
        if (ttySelected && this.ttyControl.getMessageType() > this.getMessageType()) {
            this.setMessage(this.ttyControl.getMessage(), this.ttyControl.getMessageType());
        }
        boolean isTCPValid = this.addressControl.isValid();
        if (!ttySelected && this.addressControl.getMessageType() > this.getMessageType()) {
            this.setMessage(this.addressControl.getMessage(), this.addressControl.getMessageType());
        }
        isTCPValid &= this.portControl.isValid();
        if (!ttySelected && this.portControl.getMessageType() > this.getMessageType()) {
            this.setMessage(this.portControl.getMessage(), this.portControl.getMessageType());
        }
        if (this.getMessage() == null) {
            this.setDefaultMessage(Messages.SerialLinePanel_customSerialDevice_message, 1);
        }
        this.addressControl.getButtonControl().setEnabled(!ttySelected && this.addressControl.isValid() && this.addressControl.getEditFieldValidator() instanceof NameOrIPValidator && ((NameOrIPValidator)this.addressControl.getEditFieldValidator()).isName());
        this.setButtonEnabled(0, ttySelected ? isTTYValid : isTCPValid);
    }

    public String getData() {
        return this.data;
    }
}

