/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.controls;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.tcf.filesystem.core.model.AbstractTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.model.ITreeNodeModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.ui.trees.Pending;
import org.eclipse.tcf.te.ui.trees.TreeContentProvider;

public abstract class NavigatorContentProvider
extends TreeContentProvider {
    public Object getParent(Object element) {
        if (element instanceof AbstractTreeNode) {
            AbstractTreeNode node = (AbstractTreeNode)element;
            return node.getParent() != null ? node.getParent() : (this.isRootNodeVisible() ? node.peerNode : null);
        }
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        super.getChildren(parentElement);
        if (parentElement instanceof IPeerModel) {
            IPeerModel peerNode = (IPeerModel)parentElement;
            ITreeNodeModel model = this.doGetModel(peerNode);
            if (this.isRootNodeVisible()) {
                return new Object[]{model.getRoot()};
            }
            return this.getChildren(model.getRoot());
        }
        if (parentElement instanceof AbstractTreeNode) {
            AbstractTreeNode node = (AbstractTreeNode)parentElement;
            Object[] children = NO_ELEMENTS;
            ArrayList<Pending> current = new ArrayList<Pending>(node.getChildren());
            if (!node.childrenQueried) {
                current.add(this.getPending(node));
                if (!node.childrenQueryRunning) {
                    node.queryChildren();
                }
            }
            children = current.toArray();
            return children;
        }
        return NO_ELEMENTS;
    }

    protected abstract ITreeNodeModel doGetModel(IPeerModel var1);

    public boolean hasChildren(Object element) {
        Assert.isNotNull((Object)element);
        boolean hasChildren = false;
        if (element instanceof AbstractTreeNode) {
            AbstractTreeNode node = (AbstractTreeNode)element;
            hasChildren = node.isSystemRoot() ? true : !node.childrenQueried || super.hasChildren(element);
        } else if (element instanceof IPeerModel) {
            IPeerModel peerModel = (IPeerModel)element;
            ITreeNodeModel model = this.doGetModel(peerModel);
            AbstractTreeNode root = model.getRoot();
            hasChildren = root != null ? this.hasChildren(root) : true;
        }
        return hasChildren;
    }

    protected boolean isRootNodeVisible() {
        return true;
    }
}

