/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.core.async;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tcf.te.runtime.interfaces.IConditionTester;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;

public class AsyncCallbackHandler {
    private final List<ICallback> callbacks = new Vector<ICallback>();
    private final IConditionTester conditionTester;
    private Throwable error = null;
    private static final boolean TRACING_ENABLED = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.tcf.te.runtime/trace/callbacks"));
    private final Map<ICallback, Throwable> callbackAdders = new Hashtable<ICallback, Throwable>();

    public AsyncCallbackHandler() {
        this(null);
    }

    public AsyncCallbackHandler(IConditionTester tester) {
        this.conditionTester = new AsyncCallbackConditionTester(tester);
    }

    public void addCallback(ICallback callback) {
        if (callback != null && !this.callbacks.contains(callback)) {
            this.callbacks.add(callback);
            if (TRACING_ENABLED) {
                try {
                    throw new Exception("Pending callback added!");
                }
                catch (Exception e) {
                    this.callbackAdders.put(callback, e.fillInStackTrace());
                }
            }
        }
    }

    public void removeCallback(ICallback callback) {
        if (callback != null) {
            this.callbacks.remove(callback);
            if (TRACING_ENABLED) {
                this.callbackAdders.remove(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEmpty() {
        if (TRACING_ENABLED) {
            System.err.println(String.valueOf(this.getClass().getName()) + ": size = " + this.callbacks.size());
            if (this.callbacks.size() < 4) {
                List<ICallback> list = this.callbacks;
                synchronized (list) {
                    Iterator<ICallback> iterator = this.callbacks.iterator();
                    System.err.println("Remaining adders: ");
                    while (iterator.hasNext()) {
                        Exception adder = (Exception)this.callbackAdders.get(iterator.next());
                        adder.printStackTrace();
                        System.err.println("*****");
                    }
                }
            }
        }
        return this.callbacks.isEmpty();
    }

    public final void clear() {
        this.callbacks.clear();
    }

    public final void setError(Throwable error) {
        if (error != null) {
            if (this.error == null) {
                this.error = error;
            }
        } else {
            this.error = null;
        }
    }

    public final Throwable getError() {
        return this.error;
    }

    public IConditionTester getConditionTester() {
        return this.conditionTester;
    }

    final class AsyncCallbackConditionTester
    implements IConditionTester {
        private final IConditionTester externalTester;

        public AsyncCallbackConditionTester(IConditionTester tester) {
            this.externalTester = tester;
        }

        public void cleanup() {
            if (!AsyncCallbackHandler.this.isEmpty()) {
                AsyncCallbackHandler.this.clear();
            }
        }

        public boolean isConditionFulfilled() {
            return AsyncCallbackHandler.this.isEmpty() || this.externalTester != null && this.externalTester.isConditionFulfilled();
        }
    }
}

