/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.core.bindings;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.tcf.te.launch.core.bindings.internal.LaunchConfigTypeBinding;
import org.eclipse.tcf.te.launch.core.bindings.internal.OverwritableLaunchBinding;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchManagerDelegate;
import org.eclipse.tcf.te.launch.core.lm.internal.ExtensionPointManager;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ILaunchSelection;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ISelectionContext;
import org.eclipse.tcf.te.runtime.extensions.ExtensionPointComparator;
import org.eclipse.tcf.te.runtime.stepper.StepperManager;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStep;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepGroup;

public class LaunchConfigTypeBindingsManager {
    private final Map<String, LaunchConfigTypeBinding> bindings = new Hashtable<String, LaunchConfigTypeBinding>();

    public static LaunchConfigTypeBindingsManager getInstance() {
        return LazyInstanceHolder.instance;
    }

    LaunchConfigTypeBindingsManager() {
        this.loadBindingsExtensions();
    }

    public String[] getValidLaunchConfigTypes(ILaunchSelection selection) {
        HashSet<String> validLaunchTypes = new HashSet<String>();
        if (selection != null && selection.getSelectedContexts() != null && selection.getSelectedContexts().length > 0) {
            for (String launchConfigTypeId : this.bindings.keySet()) {
                if (!this.isValidLaunchConfigType(launchConfigTypeId, selection)) continue;
                validLaunchTypes.add(launchConfigTypeId);
            }
        }
        return validLaunchTypes.toArray(new String[validLaunchTypes.size()]);
    }

    public boolean isValidLaunchConfigType(String typeId, ILaunchSelection selection) {
        Assert.isNotNull((Object)typeId);
        Assert.isNotNull((Object)selection);
        LaunchConfigTypeBinding binding = this.bindings.get(typeId);
        ILaunchConfigurationType launchConfigType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(typeId);
        return launchConfigType != null && launchConfigType.isPublic() && (selection.getLaunchMode() == null || launchConfigType.supportsMode(selection.getLaunchMode())) && binding != null && binding.validate(selection) == EvaluationResult.TRUE;
    }

    public boolean isValidLaunchConfigType(String typeId, String mode, ISelectionContext context) {
        Assert.isNotNull((Object)typeId);
        Assert.isNotNull((Object)context);
        LaunchConfigTypeBinding binding = this.bindings.get(typeId);
        ILaunchConfigurationType launchConfigType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(typeId);
        return launchConfigType != null && launchConfigType.isPublic() && (mode == null || launchConfigType.supportsMode(mode)) && binding != null && binding.validate(mode, context) != EvaluationResult.FALSE;
    }

    public ILaunchManagerDelegate getLaunchManagerDelegate(String typeId, String mode) {
        String id;
        Assert.isNotNull((Object)typeId);
        Assert.isNotNull((Object)mode);
        LaunchConfigTypeBinding binding = this.bindings.get(typeId);
        if (binding != null && (id = binding.getLaunchManagerDelegate(mode)) != null) {
            return ExtensionPointManager.getInstance().getLaunchManagerDelegate(id);
        }
        return ExtensionPointManager.getInstance().getDefaultLaunchManagerDelegate();
    }

    public String getStepGroupId(String typeId, String mode) {
        Assert.isNotNull((Object)typeId);
        Assert.isNotNull((Object)mode);
        LaunchConfigTypeBinding binding = this.bindings.get(typeId);
        if (binding != null) {
            return binding.getStepGroupId(mode);
        }
        return null;
    }

    public IStepGroup getStepGroup(String id) {
        Assert.isNotNull((Object)id);
        return StepperManager.getInstance().getStepGroupExtManager().getStepGroup(id, true);
    }

    public IStep getStep(String id) {
        Assert.isNotNull((Object)id);
        return StepperManager.getInstance().getStepExtManager().getStep(id, true);
    }

    private void loadBindingsExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.tcf.te.launch.core.launchConfigTypeBindings");
        if (point != null) {
            IExtension[] bindings = point.getExtensions();
            Arrays.sort(bindings, new ExtensionPointComparator());
            IExtension[] iExtensionArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension binding = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = binding.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    this.loadBinding(element);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void loadBinding(IConfigurationElement element) {
        IConfigurationElement[] enablements;
        IConfigurationElement[] stepGroupBindings;
        IConfigurationElement[] stepperBindings;
        IConfigurationElement[] lmDelegateBindings;
        Assert.isNotNull((Object)element);
        if (!element.getName().equals("launchConfigTypeBinding")) {
            return;
        }
        String launchConfigTypeId = element.getAttribute("launchConfigTypeId");
        if (!this.bindings.containsKey(launchConfigTypeId)) {
            this.bindings.put(launchConfigTypeId, new LaunchConfigTypeBinding(launchConfigTypeId));
        }
        LaunchConfigTypeBinding binding = this.bindings.get(launchConfigTypeId);
        IConfigurationElement[] iConfigurationElementArray = lmDelegateBindings = element.getChildren("launchManagerDelegate");
        int n = lmDelegateBindings.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement lmDelegateBinding = iConfigurationElementArray[n2];
            String id = lmDelegateBinding.getAttribute("id");
            String overwrites = lmDelegateBinding.getAttribute("overwrites");
            String modes = lmDelegateBinding.getAttribute("modes");
            binding.addLaunchManagerDelegate(new OverwritableLaunchBinding(id, overwrites, modes));
            ++n2;
        }
        IConfigurationElement[] iConfigurationElementArray2 = stepperBindings = element.getChildren("stepper");
        int n3 = stepperBindings.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement stepperBinding = iConfigurationElementArray2[n];
            String id = stepperBinding.getAttribute("id");
            String overwrites = stepperBinding.getAttribute("overwrites");
            String modes = stepperBinding.getAttribute("modes");
            binding.addStepper(new OverwritableLaunchBinding(id, overwrites, modes));
            ++n;
        }
        IConfigurationElement[] iConfigurationElementArray3 = stepGroupBindings = element.getChildren("stepGroup");
        int n4 = stepGroupBindings.length;
        n3 = 0;
        while (n3 < n4) {
            IConfigurationElement stepGroupBinding = iConfigurationElementArray3[n3];
            String id = stepGroupBinding.getAttribute("id");
            String overwrites = stepGroupBinding.getAttribute("overwrites");
            String modes = stepGroupBinding.getAttribute("modes");
            binding.addStepGroup(new OverwritableLaunchBinding(id, overwrites, modes));
            ++n3;
        }
        IConfigurationElement[] iConfigurationElementArray4 = enablements = element.getChildren("enablement");
        int n5 = enablements.length;
        n4 = 0;
        while (n4 < n5) {
            Expression expression;
            block9: {
                IConfigurationElement enablement = iConfigurationElementArray4[n4];
                expression = null;
                try {
                    expression = ExpressionConverter.getDefault().perform(enablement);
                }
                catch (CoreException e) {
                    if (!Platform.inDebugMode()) break block9;
                    e.printStackTrace();
                }
            }
            if (expression != null) {
                binding.addEnablement(expression);
            }
            ++n4;
        }
    }

    private static class LazyInstanceHolder {
        public static LaunchConfigTypeBindingsManager instance = new LaunchConfigTypeBindingsManager();

        private LazyInstanceHolder() {
        }
    }
}

