/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.ui.PlatformUI;

public class FileSystemBrowserControl {
    private Tree fileTree;
    private Display fDisplay;
    private IPeer fPeer;
    private final FileInfo fRootInfo = new FileInfo();
    private IChannel fChannel;
    private IFileSystem fFileSystem;
    private String fFileToSelect;
    private LinkedList<String> fPathToSelect;
    private FileInfo fLastSelectedFileInfo;
    private final boolean fDirectoriesOnly;

    public FileSystemBrowserControl(Composite parent, boolean directoriesOnly) {
        this.fDirectoriesOnly = directoriesOnly;
        this.fDisplay = parent.getDisplay();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FileSystemBrowserControl.this.handleDispose();
            }
        });
        this.createFileListArea(parent);
    }

    public void setInput(IPeer peer) {
        if (peer == this.fPeer) {
            return;
        }
        if (this.fPeer != null) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                public void run() {
                    FileSystemBrowserControl.this.disconnectPeer();
                }
            });
        }
        this.fileTree.setItemCount(0);
        this.fRootInfo.children = null;
        this.fPeer = peer;
        if (this.fPeer != null) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                public void run() {
                    FileSystemBrowserControl.this.connectPeer();
                }
            });
        }
    }

    public Tree getTree() {
        return this.fileTree;
    }

    private void createFileListArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setFont(font);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fileTree = new Tree(composite, 268437508);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 300;
        gd.minimumWidth = 350;
        this.fileTree.setLayoutData((Object)gd);
        this.fileTree.setFont(font);
        this.fileTree.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                FileInfo info = FileSystemBrowserControl.this.findFileInfo(item);
                if (info == null) {
                    FileSystemBrowserControl.this.updateItems(item.getParentItem(), false);
                } else {
                    FileSystemBrowserControl.this.fillItem(item, info);
                }
            }
        });
    }

    private void handleDispose() {
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                FileSystemBrowserControl.this.disconnectPeer();
                FileSystemBrowserControl.this.fFileSystem = null;
                FileSystemBrowserControl.this.fDisplay = null;
            }
        });
    }

    protected void disconnectPeer() {
        if (this.fChannel != null && this.fChannel.getState() != 2) {
            this.fChannel.close();
        }
    }

    protected void connectPeer() {
        IChannel channel;
        this.fChannel = channel = this.fPeer.openChannel();
        this.fFileSystem = null;
        channel.addChannelListener(new IChannel.IChannelListener(){

            public void congestionLevel(int level) {
            }

            public void onChannelClosed(final Throwable error) {
                if (FileSystemBrowserControl.this.fChannel != channel) {
                    return;
                }
                FileSystemBrowserControl.this.fChannel = null;
                if (FileSystemBrowserControl.this.fDisplay != null) {
                    FileSystemBrowserControl.this.fDisplay.asyncExec(new Runnable(){

                        public void run() {
                            if (((FileSystemBrowserControl)(this).FileSystemBrowserControl.this).fRootInfo.children_pending) {
                                return;
                            }
                            ((FileSystemBrowserControl)(this).FileSystemBrowserControl.this).fRootInfo.children = null;
                            ((FileSystemBrowserControl)(this).FileSystemBrowserControl.this).fRootInfo.children_error = error;
                            FileSystemBrowserControl.this.updateItems(FileSystemBrowserControl.this.fRootInfo);
                        }
                    });
                }
            }

            public void onChannelOpened() {
                if (FileSystemBrowserControl.this.fChannel != channel) {
                    return;
                }
                FileSystemBrowserControl.this.fFileSystem = (IFileSystem)FileSystemBrowserControl.this.fChannel.getRemoteService(IFileSystem.class);
                if (FileSystemBrowserControl.this.fFileSystem != null && FileSystemBrowserControl.this.fFileToSelect != null && FileSystemBrowserControl.this.fFileToSelect.length() > 0) {
                    LinkedList<String> filePath = new LinkedList<String>();
                    filePath.addAll(Arrays.asList(FileSystemBrowserControl.this.fFileToSelect.split("[/\\\\]", -1)));
                    if (FileSystemBrowserControl.this.fFileToSelect.charAt(0) == '/') {
                        filePath.set(0, "/");
                    }
                    FileSystemBrowserControl.this.fPathToSelect = filePath;
                    FileSystemBrowserControl.this.fLastSelectedFileInfo = FileSystemBrowserControl.this.fRootInfo;
                }
                if (FileSystemBrowserControl.this.fDisplay != null) {
                    FileSystemBrowserControl.this.fDisplay.asyncExec(new Runnable(){

                        public void run() {
                            if (((FileSystemBrowserControl)(this).FileSystemBrowserControl.this).fRootInfo.children_pending) {
                                return;
                            }
                            ((FileSystemBrowserControl)(this).FileSystemBrowserControl.this).fRootInfo.children = null;
                            ((FileSystemBrowserControl)(this).FileSystemBrowserControl.this).fRootInfo.children_error = null;
                            FileSystemBrowserControl.this.updateItems(FileSystemBrowserControl.this.fRootInfo);
                        }
                    });
                }
            }
        });
    }

    private void updateItems(TreeItem parent_item, boolean reload) {
        final FileInfo parent_info = this.findFileInfo(parent_item);
        if (parent_info == null) {
            parent_item.setText("Invalid");
        } else {
            if (reload && parent_info.children_error != null) {
                this.loadChildren(parent_info);
            }
            this.fDisplay.asyncExec(new Runnable(){

                public void run() {
                    FileSystemBrowserControl.this.updateItems(parent_info);
                }
            });
        }
    }

    private void updateItems(FileInfo parent) {
        if (this.fDisplay == null) {
            return;
        }
        assert (Thread.currentThread() == this.fDisplay.getThread());
        TreeItem[] items = null;
        boolean expanded = true;
        if (parent.children == null || parent.children_error != null) {
            if (parent == this.fRootInfo) {
                this.fileTree.setItemCount(1);
                items = this.fileTree.getItems();
            } else {
                TreeItem item = this.findItem(parent);
                if (item == null) {
                    return;
                }
                expanded = item.getExpanded();
                item.setItemCount(1);
                items = item.getItems();
            }
            assert (items.length == 1);
            items[0].removeAll();
            if (parent.children_pending) {
                items[0].setForeground(this.fDisplay.getSystemColor(24));
                items[0].setText("Pending...");
            } else if (parent.children_error != null) {
                String msg = parent.children_error.getMessage();
                msg = msg == null ? parent.children_error.getClass().getName() : msg.replace('\n', ' ');
                items[0].setForeground(this.fDisplay.getSystemColor(3));
                items[0].setText(msg);
                items[0].setImage(null);
            } else if (expanded) {
                this.loadChildren(parent);
                items[0].setForeground(this.fDisplay.getSystemColor(24));
                items[0].setText("Pending...");
            } else {
                items[0].setText("");
            }
        } else {
            FileInfo[] arr = parent.children;
            if (parent == this.fRootInfo) {
                this.fileTree.setItemCount(arr.length);
                items = this.fileTree.getItems();
            } else {
                TreeItem item = this.findItem(parent);
                if (item == null) {
                    return;
                }
                expanded = item.getExpanded();
                item.setItemCount(expanded ? arr.length : 1);
                items = item.getItems();
            }
            if (expanded) {
                assert (items.length == arr.length);
                int i = 0;
                while (i < items.length) {
                    this.fillItem(items[i], arr[i]);
                    ++i;
                }
                this.expandSelect();
            } else {
                items[0].setText("");
            }
        }
    }

    private void expandSelect() {
        if (this.fPathToSelect == null) {
            return;
        }
        if (this.fPathToSelect.isEmpty()) {
            this.fPathToSelect = null;
            this.fFileToSelect = null;
            return;
        }
        do {
            TreeItem item;
            String name;
            if ((name = this.fPathToSelect.getFirst()).length() == 0) {
                this.fPathToSelect.removeFirst();
                continue;
            }
            FileInfo info = this.findFileInfo(this.fLastSelectedFileInfo, name);
            if (info == null || (item = this.findItem(info)) == null) break;
            this.fPathToSelect.removeFirst();
            if (this.fPathToSelect.isEmpty()) {
                this.fileTree.setSelection(item);
                this.fileTree.showItem(item);
            } else {
                item.setExpanded(true);
                this.fileTree.showItem(item);
            }
            this.fLastSelectedFileInfo = info;
        } while (!this.fPathToSelect.isEmpty());
    }

    private void loadChildren(final FileInfo parent) {
        assert (Thread.currentThread() == this.fDisplay.getThread());
        if (parent.children_pending) {
            return;
        }
        assert (parent.children == null);
        parent.children_pending = true;
        parent.children_error = null;
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                final IFileSystem fs = FileSystemBrowserControl.this.fFileSystem;
                if (fs == null || !FileSystemBrowserControl.this.canHaveChildren(parent)) {
                    FileSystemBrowserControl.this.doneLoadChildren(parent, null, new FileInfo[0]);
                    return;
                }
                if (parent.fullname == null) {
                    fs.roots(new IFileSystem.DoneRoots(){

                        public void doneRoots(IToken token, IFileSystem.FileSystemException error, IFileSystem.DirEntry[] entries) {
                            if (error != null) {
                                FileSystemBrowserControl.this.doneLoadChildren(parent, (Throwable)error, null);
                            } else {
                                ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>(entries.length);
                                IFileSystem.DirEntry[] dirEntryArray = entries;
                                int n = entries.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IFileSystem.DirEntry entry = dirEntryArray[n2];
                                    FileInfo info = new FileInfo();
                                    info.parent = parent;
                                    String name = entry.filename;
                                    int length = name.length();
                                    if (length > 1 && (name.endsWith("\\") || name.endsWith("/"))) {
                                        name = name.substring(0, length - 1);
                                    }
                                    info.name = name;
                                    info.fullname = entry.longname != null ? entry.longname : entry.filename;
                                    boolean bl = info.isDir = entry.attrs != null ? entry.attrs.isDirectory() : false;
                                    if (!FileSystemBrowserControl.this.fDirectoriesOnly || info.isDir) {
                                        fileInfos.add(info);
                                    }
                                    ++n2;
                                }
                                FileSystemBrowserControl.this.doneLoadChildren(parent, null, fileInfos.toArray(new FileInfo[fileInfos.size()]));
                            }
                        }
                    });
                    return;
                }
                fs.opendir(parent.fullname, new IFileSystem.DoneOpen(){
                    final List<FileInfo> fileInfos = new ArrayList<FileInfo>();

                    public void doneOpen(IToken token, IFileSystem.FileSystemException error, final IFileSystem.IFileHandle handle) {
                        if (error != null) {
                            FileSystemBrowserControl.this.doneLoadChildren(parent, (Throwable)error, null);
                            return;
                        }
                        fs.readdir(handle, new IFileSystem.DoneReadDir(){

                            public void doneReadDir(IToken token, IFileSystem.FileSystemException error, IFileSystem.DirEntry[] entries, boolean eof) {
                                if (entries != null) {
                                    IFileSystem.DirEntry[] dirEntryArray = entries;
                                    int n = entries.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IFileSystem.DirEntry entry = dirEntryArray[n2];
                                        FileInfo info = new FileInfo();
                                        info.parent = parent;
                                        info.name = entry.filename;
                                        info.fullname = entry.longname != null ? entry.longname : new Path(parent.fullname).append(info.name).toString();
                                        boolean bl = info.isDir = entry.attrs != null ? entry.attrs.isDirectory() : false;
                                        if (!FileSystemBrowserControl.this.fDirectoriesOnly || info.isDir) {
                                            fileInfos.add(info);
                                        }
                                        ++n2;
                                    }
                                }
                                if (error != null || eof) {
                                    fs.close(handle, new IFileSystem.DoneClose(){

                                        public void doneClose(IToken token, IFileSystem.FileSystemException error) {
                                        }
                                    });
                                    int size = fileInfos.size();
                                    if (size == 0 && error != null) {
                                        FileSystemBrowserControl.this.doneLoadChildren(parent, (Throwable)error, null);
                                    } else {
                                        FileSystemBrowserControl.this.doneLoadChildren(parent, null, fileInfos.toArray(new FileInfo[size]));
                                    }
                                } else {
                                    fs.readdir(handle, (IFileSystem.DoneReadDir)this);
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    private void doneLoadChildren(final FileInfo parent, final Throwable error, final FileInfo[] children) {
        assert (Protocol.isDispatchThread());
        assert (error == null || children == null);
        if (this.fDisplay == null) {
            return;
        }
        Arrays.sort(children, new Comparator<FileInfo>(){

            @Override
            public int compare(FileInfo o1, FileInfo o2) {
                if (o1.isDir == o2.isDir) {
                    return o1.name.compareTo(o2.name);
                }
                if (o1.isDir) {
                    return 1;
                }
                return -1;
            }
        });
        int i = 0;
        FileInfo[] fileInfoArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            FileInfo fileInfo = fileInfoArray[n2];
            fileInfo.index = i++;
            ++n2;
        }
        this.fDisplay.asyncExec(new Runnable(){

            public void run() {
                if (!$assertionsDisabled && !parent.children_pending) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && parent.children != null) {
                    throw new AssertionError();
                }
                parent.children_pending = false;
                parent.children = children;
                parent.children_error = error;
                FileSystemBrowserControl.this.updateItems(parent);
            }
        });
    }

    public FileInfo findFileInfo(TreeItem item) {
        int i;
        assert (Thread.currentThread() == this.fDisplay.getThread());
        if (item == null) {
            return this.fRootInfo;
        }
        TreeItem parent = item.getParentItem();
        FileInfo info = this.findFileInfo(parent);
        if (info == null) {
            return null;
        }
        if (info.children == null) {
            return null;
        }
        if (info.children_error != null) {
            return null;
        }
        int n = i = parent == null ? this.fileTree.indexOf(item) : parent.indexOf(item);
        if (i < 0 || i >= info.children.length) {
            return null;
        }
        assert (info.children[i].index == i);
        return info.children[i];
    }

    private FileInfo findFileInfo(FileInfo parent, String name) {
        assert (Thread.currentThread() == this.fDisplay.getThread());
        if (name == null) {
            return this.fRootInfo;
        }
        if (name.equals(parent.name)) {
            return parent;
        }
        FileInfo[] childInfos = parent.children;
        if (childInfos != null) {
            FileInfo[] fileInfoArray = childInfos;
            int n = childInfos.length;
            int n2 = 0;
            while (n2 < n) {
                FileInfo fileInfo = fileInfoArray[n2];
                FileInfo found = this.findFileInfo(fileInfo, name);
                if (found != null) {
                    return found;
                }
                ++n2;
            }
        }
        return null;
    }

    private TreeItem findItem(FileInfo info) {
        if (info == null) {
            return null;
        }
        assert (info.parent != null);
        if (info.parent == this.fRootInfo) {
            int n = this.fileTree.getItemCount();
            if (info.index >= n) {
                return null;
            }
            return this.fileTree.getItem(info.index);
        }
        TreeItem i = this.findItem(info.parent);
        if (i == null) {
            return null;
        }
        int n = i.getItemCount();
        if (info.index >= n) {
            return null;
        }
        return i.getItem(info.index);
    }

    private void fillItem(TreeItem item, FileInfo info) {
        assert (Thread.currentThread() == this.fDisplay.getThread());
        Object data = item.getData("TCFContextInfo");
        if (data != null && data != info) {
            item.removeAll();
        }
        item.setData("TCFContextInfo", (Object)info);
        String text = info.name != null ? info.name : info.fullname;
        item.setText(text);
        item.setForeground(this.fDisplay.getSystemColor(24));
        item.setImage(this.getImage(info));
        if (!this.canHaveChildren(info)) {
            item.setItemCount(0);
        } else if (info.children == null || info.children_error != null) {
            item.setItemCount(1);
        } else {
            item.setItemCount(info.children.length);
        }
    }

    private boolean canHaveChildren(FileInfo info) {
        return info.isDir || info == this.fRootInfo;
    }

    private Image getImage(FileInfo info) {
        if (info.isDir) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    }

    public void setInitialSelection(final String filename) {
        this.fPathToSelect = null;
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                FileSystemBrowserControl.this.fFileToSelect = filename;
            }
        });
    }

    public FileInfo getSelection() {
        TreeItem[] items;
        if (this.fileTree != null && (items = this.fileTree.getSelection()).length > 0) {
            FileInfo info = this.findFileInfo(items[0]);
            return info;
        }
        return null;
    }

    static class FileInfo {
        String name;
        String fullname;
        boolean isDir;
        FileInfo[] children;
        Throwable children_error;
        int index;
        boolean children_pending;
        FileInfo parent;

        FileInfo() {
        }
    }
}

