/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.internal.utils;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

class DelegateProgressMonitor
extends ProgressMonitorWrapper {
    ProgressMonitorPart fPmPart;

    public DelegateProgressMonitor(IProgressMonitor parent, ProgressMonitorPart mpart) {
        super(parent);
        this.fPmPart = mpart;
        this.safeRun(new Runnable(){

            @Override
            public void run() {
                if (DelegateProgressMonitor.this.fPmPart != null && !DelegateProgressMonitor.this.fPmPart.isDisposed()) {
                    DelegateProgressMonitor.this.fPmPart.attachToCancelComponent(null);
                    DelegateProgressMonitor.this.fPmPart.setCanceled(false);
                    DelegateProgressMonitor.this.fPmPart.setVisible(true);
                }
            }
        });
    }

    public void beginTask(final String name, final int totalWork) {
        super.beginTask(name, totalWork);
        this.safeRun(new Runnable(){

            @Override
            public void run() {
                if (DelegateProgressMonitor.this.fPmPart != null && !DelegateProgressMonitor.this.fPmPart.isDisposed()) {
                    DelegateProgressMonitor.this.fPmPart.beginTask(name, totalWork);
                }
            }
        });
    }

    public boolean isCanceled() {
        return this.fPmPart != null && this.fPmPart.isCanceled() || super.isCanceled();
    }

    public void subTask(final String name) {
        super.subTask(name);
        this.safeRun(new Runnable(){

            @Override
            public void run() {
                if (DelegateProgressMonitor.this.fPmPart != null && !DelegateProgressMonitor.this.fPmPart.isDisposed()) {
                    DelegateProgressMonitor.this.fPmPart.subTask(name);
                }
            }
        });
    }

    public void done() {
        super.done();
        this.safeRun(new Runnable(){

            @Override
            public void run() {
                if (DelegateProgressMonitor.this.fPmPart != null && !DelegateProgressMonitor.this.fPmPart.isDisposed()) {
                    DelegateProgressMonitor.this.fPmPart.done();
                    DelegateProgressMonitor.this.fPmPart.setVisible(false);
                }
            }
        });
    }

    public void setTaskName(final String name) {
        super.setTaskName(name);
        this.safeRun(new Runnable(){

            @Override
            public void run() {
                if (DelegateProgressMonitor.this.fPmPart != null && !DelegateProgressMonitor.this.fPmPart.isDisposed()) {
                    DelegateProgressMonitor.this.fPmPart.setTaskName(name);
                }
            }
        });
    }

    public void setCanceled(final boolean b) {
        super.setCanceled(b);
        this.safeRun(new Runnable(){

            @Override
            public void run() {
                if (DelegateProgressMonitor.this.fPmPart != null && !DelegateProgressMonitor.this.fPmPart.isDisposed()) {
                    DelegateProgressMonitor.this.fPmPart.setCanceled(b);
                }
            }
        });
    }

    public void worked(final int work) {
        super.worked(work);
        this.safeRun(new Runnable(){

            @Override
            public void run() {
                if (DelegateProgressMonitor.this.fPmPart != null && !DelegateProgressMonitor.this.fPmPart.isDisposed()) {
                    DelegateProgressMonitor.this.fPmPart.worked(work);
                }
            }
        });
    }

    void safeRun(Runnable runnable) {
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }
}

