/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.telnet.controls;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.terminals.panels.AbstractConfigurationPanel;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.telnet.TelnetConnector;
import org.eclipse.tm.internal.terminal.telnet.TelnetSettings;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TelnetWizardConfigurationPanel
extends AbstractConfigurationPanel
implements IDataExchangeNode {
    public TelnetSettings telnetSettings;
    private ISettingsPage telnetSettingsPage;

    public TelnetWizardConfigurationPanel(BaseDialogPageControl parentControl) {
        super(parentControl);
    }

    public void setupPanel(Composite parent, FormToolkit toolkit) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridData data = new GridData(4, 4, true, true);
        panel.setLayoutData((Object)data);
        if (this.isWithoutSelection()) {
            this.createHostsUI(panel);
        }
        TelnetConnector conn = new TelnetConnector();
        this.telnetSettings = (TelnetSettings)conn.getTelnetSettings();
        this.telnetSettingsPage = conn.makeSettingsPage();
        this.telnetSettingsPage.createControl(panel);
        this.telnetSettings.setHost(this.getSelectionHost());
        this.telnetSettings.setNetworkPort("23");
        this.setControl(panel);
    }

    public boolean dataChanged(IPropertiesContainer data, TypedEvent e) {
        return false;
    }

    public void setupData(IPropertiesContainer data) {
    }

    public void extractData(IPropertiesContainer data) {
        data.setProperty("tm.terminal.connector.id", (Object)"org.eclipse.tm.internal.terminal.telnet.TelnetConnector");
        data.setProperty("connector.type.id", (Object)"org.eclipse.tcf.te.ui.terminals.type.telnet");
        this.telnetSettingsPage.saveSettings();
        data.setProperty("ip.host", (Object)this.telnetSettings.getHost());
        data.setProperty("ip.port", this.telnetSettings.getNetworkPort());
        data.setProperty("timeout", this.telnetSettings.getTimeout());
    }

    protected void fillSettingsForHost(String host) {
        if (host != null && host.length() != 0) {
            if (this.hostSettingsMap.containsKey(host)) {
                Map hostSettings = (Map)this.hostSettingsMap.get(host);
                if (hostSettings.get("ip.host") != null) {
                    this.telnetSettings.setHost((String)hostSettings.get("ip.host"));
                }
                if (hostSettings.get("ip.port") != null) {
                    this.telnetSettings.setNetworkPort((String)hostSettings.get("ip.port"));
                }
                if (hostSettings.get("timeout") != null) {
                    this.telnetSettings.setTimeout((String)hostSettings.get("timeout"));
                }
            } else {
                this.telnetSettings.setHost(this.getSelectionHost());
                this.telnetSettings.setNetworkPort("23");
            }
            this.telnetSettingsPage.loadSettings();
        }
    }

    protected void saveSettingsForHost(boolean add) {
        String host = this.getHostFromSettings();
        if (host != null && host.length() != 0) {
            if (this.hostSettingsMap.containsKey(host)) {
                Map hostSettings = (Map)this.hostSettingsMap.get(host);
                hostSettings.put("ip.host", this.telnetSettings.getHost());
                hostSettings.put("ip.port", Integer.toString(this.telnetSettings.getNetworkPort()));
                hostSettings.put("timeout", Integer.toString(this.telnetSettings.getTimeout()));
            } else if (add) {
                HashMap<String, String> hostSettings = new HashMap<String, String>();
                hostSettings.put("ip.host", this.telnetSettings.getHost());
                hostSettings.put("ip.port", Integer.toString(this.telnetSettings.getNetworkPort()));
                hostSettings.put("timeout", Integer.toString(this.telnetSettings.getTimeout()));
                this.hostSettingsMap.put(host, hostSettings);
            }
        }
    }

    public boolean isValid() {
        return this.telnetSettingsPage.validateSettings();
    }

    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        this.saveSettingsForHost(true);
        super.doSaveWidgetValues(settings, idPrefix);
    }

    protected String getHostFromSettings() {
        this.telnetSettingsPage.saveSettings();
        return this.telnetSettings.getHost();
    }
}

