/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.handler;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerManager;
import org.eclipse.tcf.te.runtime.statushandler.interfaces.IStatusHandler;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.ui.handlers.HandlerUtil;

public class ResetRedirectHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object candidate;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (candidate = ((IStructuredSelection)selection).getFirstElement()) instanceof IPeerModel) {
            final IPeerModel peerModel = (IPeerModel)candidate;
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ResetRedirectHandler.this.resetRedirect(peerModel);
                }
            });
        }
        return null;
    }

    public void resetRedirect(IPeerModel peerModel) {
        block4: {
            Assert.isNotNull((Object)peerModel);
            Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
            HashMap attributes = new HashMap();
            attributes.putAll(peerModel.getPeer().getAttributes());
            if (attributes.get("redirect.proxy") != null) {
                attributes.remove("redirect.proxy");
                try {
                    IURIPersistenceService uRIPersistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                    if (uRIPersistenceService == null) {
                        throw new IOException("Persistence service instance unavailable.");
                    }
                    TransientPeer peer = new TransientPeer(attributes);
                    uRIPersistenceService.write((Object)peer, null);
                    peerModel.setProperty("instance", (Object)peer);
                    ((ILocatorModelUpdateService)Model.getModel().getService(ILocatorModelUpdateService.class)).removeChild(peerModel);
                    peerModel.setParent(null);
                    Protocol.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ((ILocatorModelRefreshService)Model.getModel().getService(ILocatorModelRefreshService.class)).refresh();
                        }
                    });
                }
                catch (IOException e) {
                    Status status = new Status(4, UIPlugin.getUniqueIdentifier(), Messages.ResetRedirectHandler_error_resetRedirectFailed, (Throwable)e);
                    PropertiesContainer data = new PropertiesContainer();
                    data.setProperty("title", (Object)Messages.ResetRedirectHandler_error_title);
                    data.setProperty("contextHelpId", (Object)IContextHelpIds.MESSAGE_RESET_REDIRECT_FAILED);
                    data.setProperty("caller", (Object)this);
                    IStatusHandler[] handler = StatusHandlerManager.getInstance().getHandler((Object)peerModel);
                    if (handler.length <= 0) break block4;
                    handler[0].handleStatus((IStatus)status, (IPropertiesContainer)data, null);
                }
            }
        }
    }
}

