/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;

public final class Host {
    private static volatile Boolean isWindowsHost = null;
    private static volatile Boolean isInteractive = null;
    private static volatile Boolean isHeadless = null;
    private static volatile Boolean isLinuxHost = null;

    public static boolean isWindowsHost() {
        if (isWindowsHost == null) {
            isWindowsHost = System.getProperty("os.name", "").toLowerCase().startsWith("windows") ? Boolean.TRUE : Boolean.FALSE;
        }
        return isWindowsHost;
    }

    public static boolean isLinuxHost() {
        if (isLinuxHost == null) {
            isLinuxHost = System.getProperty("os.name", "").toLowerCase().startsWith("linux") ? Boolean.TRUE : Boolean.FALSE;
        }
        return isLinuxHost;
    }

    public static String getLinuxRelease() {
        String firstLine;
        block21: {
            firstLine = "Unknown";
            File etcdir = new File("/etc");
            String[] list = etcdir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String[] distStrings = new String[]{"fedora-release", "redhat-release", "SuSE-release", "lsb-release"};
                    String f = new File(name).getName();
                    String[] stringArray = distStrings;
                    int n = distStrings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String distString = stringArray[n2];
                        String filter = distString;
                        if (f.equalsIgnoreCase(filter)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
            });
            if (list == null || list.length == 0) {
                return "Unknown";
            }
            String entry = list[0];
            if (Boolean.getBoolean("shell.debug")) {
                System.out.println("UtilityEnvironment#getLinuxRelease: reading file: " + etcdir + "/" + entry);
            }
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new FileReader(new File(etcdir + "/" + entry)));
                    if ("lsb-release".equalsIgnoreCase(entry)) {
                        while (firstLine != null && !firstLine.toUpperCase().startsWith("DISTRIB_DESCRIPTION")) {
                            if (Boolean.getBoolean("shell.debug")) {
                                System.out.println("UtilityEnvironment#getLinuxRelease: firstLine='" + firstLine + "'");
                            }
                            firstLine = reader.readLine();
                        }
                    } else {
                        firstLine = reader.readLine();
                    }
                }
                catch (IOException iOException) {
                    firstLine = "Unknown";
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        String string = firstLine = firstLine != null ? firstLine : "Unknown";
        if (Boolean.getBoolean("shell.debug")) {
            System.out.println("UtilityEnvironment#getLinuxRelease: return value='" + firstLine + "'");
        }
        return firstLine;
    }

    public static boolean isInteractive() {
        if (isInteractive == null) {
            boolean batchMode = Boolean.valueOf(System.getProperty("NOINTERACTIVE"));
            isInteractive = !batchMode;
        }
        return isInteractive;
    }

    public static boolean isHeadless() {
        if (isHeadless == null) {
            String headless = System.getProperty("HEADLESS");
            isHeadless = Boolean.valueOf(headless);
        }
        return isHeadless;
    }
}

