/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.rse.shells;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.tcf.internal.rse.shells.TCFTerminalShell;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IStreams;
import org.eclipse.tcf.util.TCFTask;

public class TCFTerminalInputStream
extends InputStream {
    private final TCFTerminalShell terminal;
    private final IStreams streams;
    private final String is_id;
    private boolean connected = true;
    private boolean bEof = false;

    public TCFTerminalInputStream(TCFTerminalShell terminal, IStreams streams, String is_id) throws IOException {
        if (streams == null) {
            throw new IOException("TCP streams is null");
        }
        this.terminal = terminal;
        this.streams = streams;
        this.is_id = is_id;
    }

    public synchronized int read() throws IOException {
        if (!this.connected) {
            throw new IOException("istream is not connected");
        }
        if (this.bEof) {
            return -1;
        }
        try {
            return (Integer)new TCFTask<Integer>(){

                public void run() {
                    TCFTerminalInputStream.this.streams.read(TCFTerminalInputStream.this.is_id, 1, new IStreams.DoneRead(){

                        public void doneRead(IToken token, Exception error, int lostSize, byte[] data, boolean eos) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            TCFTerminalInputStream.this.bEof = eos;
                            if (data != null) {
                                this.done(data[0] & 0xFF);
                            } else {
                                this.done(-1);
                            }
                        }
                    });
                }
            }.getIO();
        }
        catch (IOException e) {
            if (!this.connected) {
                return -1;
            }
            throw e;
        }
    }

    public synchronized int read(byte[] b, int off, final int len) throws IOException {
        if (!this.connected) {
            throw new IOException("istream is not connected");
        }
        if (this.bEof) {
            return -1;
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        try {
            byte[] data = (byte[])new TCFTask<byte[]>(){

                public void run() {
                    TCFTerminalInputStream.this.streams.read(TCFTerminalInputStream.this.is_id, len, new IStreams.DoneRead(){

                        public void doneRead(IToken token, Exception error, int lostSize, byte[] data, boolean eos) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            TCFTerminalInputStream.this.bEof = eos;
                            this.done(data);
                        }
                    });
                }
            }.getIO();
            if (data != null) {
                int length = data.length;
                System.arraycopy(data, 0, b, off, length);
                return length;
            }
            if (this.bEof) {
                return -1;
            }
            return 0;
        }
        catch (IOException e) {
            if (!this.connected) {
                return -1;
            }
            throw e;
        }
    }

    public void close() throws IOException {
        if (!this.connected) {
            return;
        }
        this.connected = false;
        new TCFTask<Object>(){

            public void run() {
                TCFTerminalInputStream.this.streams.disconnect(TCFTerminalInputStream.this.is_id, new IStreams.DoneDisconnect(){

                    public void doneDisconnect(IToken token, Exception error) {
                        if (error != null) {
                            this.error(error);
                            return;
                        }
                        TCFTerminalInputStream.this.terminal.onInputStreamClosed();
                        this.done(this);
                    }
                });
            }
        }.getIO();
    }
}

