/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.model.steps;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IDebugService;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerManager;
import org.eclipse.tcf.te.runtime.statushandler.interfaces.IStatusHandler;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.processes.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.processes.core.interfaces.IContextHelpIds;
import org.eclipse.tcf.te.tcf.processes.core.model.ProcessTreeNode;
import org.eclipse.tcf.te.tcf.processes.core.nls.Messages;

public class AttachStep {
    public void executeAttach(final ProcessTreeNode node, final ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)((Object)node));
        if (node.pContext != null && !node.pContext.isAttached()) {
            if (node.peerNode != null) {
                IDebugService dbgService = (IDebugService)ServiceManager.getInstance().getService((Object)node.peerNode, IDebugService.class, false);
                if (dbgService != null) {
                    dbgService.attach((Object)node.peerNode, (IPropertiesContainer)new PropertiesContainer(), (ICallback)new Callback(){

                        protected void internalDone(Object caller, IStatus status) {
                            callback.setProperty("launch", this.getProperty("launch"));
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    AttachStep.this.doAttach(node, callback);
                                }
                            };
                            if (Protocol.isDispatchThread()) {
                                runnable.run();
                            } else {
                                Protocol.invokeLater((Runnable)runnable);
                            }
                        }
                    });
                } else {
                    this.doAttach(node, callback);
                }
            } else {
                this.onError((Object)node, Messages.AttachStep_error_connect, null, callback);
            }
        } else if (node.pContext == null) {
            this.onError((Object)node, Messages.AttachStep_error_connect, null, callback);
        } else {
            this.onDone(callback);
        }
    }

    protected void doAttach(final ProcessTreeNode node, final ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)((Object)node));
        Tcf.getChannelManager().openChannel(node.peerNode.getPeer(), null, new IChannelManager.DoneOpenChannel(){

            public void doneOpenChannel(Throwable error, final IChannel channel) {
                if (error == null) {
                    final IProcesses service = (IProcesses)channel.getRemoteService(IProcesses.class);
                    if (service != null) {
                        service.getContext(node.pContext.getID(), new IProcesses.DoneGetContext(){

                            public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
                                if (error == null && context != null) {
                                    context.attach(new IProcesses.DoneCommand(){

                                        public void doneCommand(IToken token, Exception error) {
                                            if (error == null) {
                                                ISysMonitor monService = (ISysMonitor)channel.getRemoteService(ISysMonitor.class);
                                                if (monService != null) {
                                                    monService.getContext(node.id, new ISysMonitor.DoneGetContext(){

                                                        public void doneGetContext(IToken token, Exception error, ISysMonitor.SysMonitorContext context) {
                                                            node.updateSysMonitorContext(context);
                                                            service.getContext(node.pContext.getID(), new IProcesses.DoneGetContext(){

                                                                public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
                                                                    node.setProcessContext(context);
                                                                    AttachStep.this.onDone(callback);
                                                                }
                                                            });
                                                        }
                                                    });
                                                } else {
                                                    AttachStep.this.onDone(callback);
                                                }
                                            } else {
                                                AttachStep.this.onError((Object)node, Messages.AttachStep_error_attach, error, callback);
                                            }
                                        }
                                    });
                                } else {
                                    AttachStep.this.onError((Object)node, Messages.AttachStep_error_getContext, error, callback);
                                }
                            }
                        });
                    } else {
                        AttachStep.this.onError((Object)node, Messages.AttachStep_error_connect, error, callback);
                    }
                } else {
                    AttachStep.this.onError((Object)node, Messages.AttachStep_error_openChannel, error, callback);
                }
            }
        });
    }

    protected void onError(Object context, String message, Throwable error, ICallback callback) {
        String fullMessage;
        String detailMessage;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        String string = detailMessage = error != null ? error.getMessage() : null;
        if (detailMessage != null && detailMessage.contains("\n")) {
            detailMessage = detailMessage.replaceAll("\n", ", ");
            detailMessage = detailMessage.replaceAll(":, ", ": ");
        }
        if ((fullMessage = (fullMessage = message) != null ? NLS.bind((String)fullMessage, (Object)(detailMessage != null ? detailMessage : "")) : detailMessage) != null) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), fullMessage, error);
            if (callback == null) {
                IStatusHandler[] handlers = StatusHandlerManager.getInstance().getHandler(context);
                if (handlers.length > 0) {
                    PropertiesContainer data = new PropertiesContainer();
                    data.setProperty("title", (Object)Messages.AttachStep_error_title);
                    data.setProperty("contextHelpId", (Object)IContextHelpIds.MESSAGE_ATTACH_FAILED);
                    data.setProperty("caller", (Object)this);
                    handlers[0].handleStatus((IStatus)status, (IPropertiesContainer)data, null);
                } else {
                    CoreBundleActivator.getDefault().getLog().log((IStatus)status);
                }
            } else {
                callback.done((Object)this, (IStatus)status);
            }
        }
    }

    protected void onDone(ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (callback != null) {
            callback.done((Object)this, Status.OK_STATUS);
        }
    }
}

