/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.breakpoints;

import org.eclipse.cdt.debug.core.ICWatchpointTarget;
import org.eclipse.cdt.debug.internal.core.ICWatchpointTarget;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ISymbols;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;

public class TCFWatchpointTarget
implements ICWatchpointTarget {
    private final TCFNodeExpression fNode;

    public TCFWatchpointTarget(TCFNodeExpression node) {
        this.fNode = node;
    }

    public void canSetWatchpoint(ICWatchpointTarget.CanCreateWatchpointRequest request) {
        request.setCanCreate(true);
        request.done();
    }

    public String getExpression() {
        final TCFDataCache expressionText = this.fNode.getExpressionText();
        String expr = (String)new TCFTask<String>(this.fNode.getChannel()){

            public void run() {
                if (!expressionText.validate((Runnable)((Object)this))) {
                    return;
                }
                this.done((String)expressionText.getData());
            }
        }.getE();
        return expr != null ? expr : "";
    }

    public void getSize(final ICWatchpointTarget.GetSizeRequest request) {
        final TCFDataCache expressionType = this.fNode.getType();
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                if (!expressionType.validate((Runnable)this)) {
                    return;
                }
                ISymbols.Symbol type = (ISymbols.Symbol)expressionType.getData();
                request.setSize(type != null ? type.getSize() : 1);
                request.done();
            }
        });
    }
}

