/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.commands;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.debug.ui.IPinProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.IWorkbenchPart;

public class TCFPinViewCommand
implements IPinProvider {
    private final TCFModel model;
    private final ArrayList<PinnedView> list = new ArrayList();

    public TCFPinViewCommand(TCFModel model) {
        this.model = model;
    }

    public boolean isPinnable(IWorkbenchPart part, final Object obj) {
        if (obj instanceof TCFNode) {
            try {
                final String id = part.getSite().getId();
                return (Boolean)new TCFTask<Boolean>(this.model.getChannel()){

                    public void run() {
                        boolean mem = false;
                        boolean vars = false;
                        if (obj instanceof TCFNodeExecContext) {
                            TCFNodeExecContext node = (TCFNodeExecContext)obj;
                            TCFDataCache ctx_cache = node.getRunContext();
                            if (!ctx_cache.validate((Runnable)((Object)this))) {
                                return;
                            }
                            IRunControl.RunControlContext ctx_data = (IRunControl.RunControlContext)ctx_cache.getData();
                            if (ctx_data != null) {
                                vars = ctx_data.hasState();
                                boolean bl = mem = vars || ctx_data.getProcessID() != null;
                            }
                        }
                        if (obj instanceof TCFNodeStackFrame) {
                            vars = true;
                            mem = true;
                        }
                        if ("org.eclipse.debug.ui.RegisterView".equals(id)) {
                            this.done(vars);
                        } else if ("org.eclipse.debug.ui.VariableView".equals(id)) {
                            this.done(vars);
                        } else if ("org.eclipse.debug.ui.ExpressionView".equals(id)) {
                            this.done(mem);
                        } else {
                            this.done(false);
                        }
                    }
                }.getE();
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        return false;
    }

    public IPinProvider.IPinElementHandle pin(final IWorkbenchPart part, Object obj, final IPinProvider.IPinModelListener listener) {
        if (obj instanceof TCFNode) {
            final TCFNode node = (TCFNode)obj;
            return (IPinProvider.IPinElementHandle)new TCFTask<IPinProvider.IPinElementHandle>(){

                public void run() {
                    PinnedView p = new PinnedView(part, node, listener);
                    TCFPinViewCommand.this.model.setPin(part, node);
                    TCFPinViewCommand.this.list.add(p);
                    this.done(p);
                }
            }.getE();
        }
        return null;
    }

    public void unpin(final IWorkbenchPart part, final IPinProvider.IPinElementHandle handle) {
        new TCFTask<Object>(){

            public void run() {
                TCFPinViewCommand.this.model.setPin(part, null);
                if (TCFPinViewCommand.this.list.remove(handle)) {
                    ((PinnedView)handle).dispose();
                }
                this.done(null);
            }
        };
    }

    public boolean isPinnedTo(Object obj, final IPinProvider.IPinElementHandle handle) {
        if (obj instanceof TCFNode) {
            return (Boolean)new TCFTask<Boolean>(){

                public void run() {
                    this.done(TCFPinViewCommand.this.list.contains(handle));
                }
            }.getE();
        }
        return false;
    }

    private class PinnedView
    implements IPinProvider.IPinElementHandle {
        private final IPinProvider.IPinModelListener listener;
        private final IWorkbenchPart part;
        private final TCFNode node;
        private final IPresentationContext ctx;
        final IRunControl.RunControlListener rc_listener = new IRunControl.RunControlListener(){

            public void contextAdded(IRunControl.RunControlContext[] contexts) {
            }

            public void contextChanged(IRunControl.RunControlContext[] contexts) {
                IRunControl.RunControlContext[] runControlContextArray = contexts;
                int n = contexts.length;
                int n2 = 0;
                while (n2 < n) {
                    IRunControl.RunControlContext ctx = runControlContextArray[n2];
                    if (PinnedView.this.node.getID().equals(ctx.getID())) {
                        PinnedView.this.updateLabel();
                    }
                    ++n2;
                }
            }

            public void contextRemoved(String[] context_ids) {
                String[] stringArray = context_ids;
                int n = context_ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    if (PinnedView.this.node.getID().equals(id)) {
                        PinnedView.this.updateLabel();
                    }
                    ++n2;
                }
            }

            public void contextSuspended(String id, String pc, String reason, Map<String, Object> params) {
                if (PinnedView.this.node.getID().equals(id)) {
                    PinnedView.this.updateLabel();
                }
            }

            public void contextResumed(String id) {
                if (PinnedView.this.node.getID().equals(id)) {
                    PinnedView.this.updateLabel();
                }
            }

            public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
                String[] stringArray = suspended_ids;
                int n = suspended_ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    if (PinnedView.this.node.getID().equals(id)) {
                        PinnedView.this.updateLabel();
                    }
                    ++n2;
                }
            }

            public void containerResumed(String[] context_ids) {
                String[] stringArray = context_ids;
                int n = context_ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    if (PinnedView.this.node.getID().equals(id)) {
                        PinnedView.this.updateLabel();
                    }
                    ++n2;
                }
            }

            public void contextException(String id, String msg) {
                if (PinnedView.this.node.getID().equals(id)) {
                    PinnedView.this.updateLabel();
                }
            }
        };

        PinnedView(IWorkbenchPart part, TCFNode node, IPinProvider.IPinModelListener listener) {
            this.part = part;
            this.node = node;
            this.listener = listener;
            this.ctx = new PresentationContext("org.eclipse.tcf.debug.ui.pinned_view", part);
            IRunControl rc = (IRunControl)TCFPinViewCommand.this.model.getChannel().getRemoteService(IRunControl.class);
            if (rc != null) {
                rc.addListener(this.rc_listener);
            }
        }

        void updateLabel() {
        }

        void dispose() {
            IRunControl rc = (IRunControl)TCFPinViewCommand.this.model.getChannel().getRemoteService(IRunControl.class);
            if (rc != null) {
                rc.removeListener(this.rc_listener);
            }
        }

        public Object getDebugContext() {
            return this.node;
        }

        public String getLabel() {
            return (String)new TCFTask<String>(){

                public void run() {
                    TCFPinViewCommand.this.model.update(new ILabelUpdate[]{new ILabelUpdate(){
                        String text;

                        public IPresentationContext getPresentationContext() {
                            return PinnedView.this.ctx;
                        }

                        public Object getElement() {
                            return PinnedView.this.node;
                        }

                        public TreePath getElementPath() {
                            return null;
                        }

                        public Object getViewerInput() {
                            return null;
                        }

                        public void setStatus(IStatus status) {
                        }

                        public IStatus getStatus() {
                            return null;
                        }

                        public void done() {
                            this.done_update(this.text);
                        }

                        public void cancel() {
                        }

                        public boolean isCanceled() {
                            return false;
                        }

                        public String[] getColumnIds() {
                            return null;
                        }

                        public void setLabel(String text, int columnIndex) {
                            if (columnIndex == 0) {
                                this.text = text;
                            }
                        }

                        public void setFontData(FontData fontData, int columnIndex) {
                        }

                        public void setImageDescriptor(ImageDescriptor image, int columnIndex) {
                        }

                        public void setForeground(RGB foreground, int columnIndex) {
                        }

                        public void setBackground(RGB background, int columnIndex) {
                        }
                    }});
                }

                private void done_update(String text) {
                    if (text == null) {
                        text = PinnedView.this.node.getID();
                    }
                    this.done(text);
                }
            }.getE();
        }

        public IPinProvider.IPinElementColorDescriptor getPinElementColorDescriptor() {
            return null;
        }
    }
}

