/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.internal.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.filesystem.core.model.AbstractTreeNode;
import org.eclipse.tcf.te.tcf.processes.core.model.ProcessTreeNode;
import org.eclipse.tcf.te.tcf.processes.core.model.steps.TerminateStep;
import org.eclipse.tcf.te.tcf.processes.ui.nls.Messages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class TerminateHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            for (Object candidate : (IStructuredSelection)selection) {
                if (!(candidate instanceof ProcessTreeNode)) continue;
                final ProcessTreeNode process = (ProcessTreeNode)candidate;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        TerminateStep step = new TerminateStep();
                        step.executeTerminate(process, (ICallback)new TerminateCallback(process));
                    }
                };
                Protocol.invokeLater((Runnable)runnable);
            }
        }
        return null;
    }

    static class TerminateCallback
    extends Callback {
        private ProcessTreeNode node;

        public TerminateCallback(ProcessTreeNode node) {
            this.node = node;
        }

        protected void internalDone(Object caller, final IStatus status) {
            if (status.isOK()) {
                this.node.getParent().removeChild((AbstractTreeNode)this.node);
            } else {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String message = status.getMessage();
                        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        MessageDialog.openError((Shell)parent, (String)Messages.TerminateHandler_TerminationError, (String)message);
                    }
                });
            }
        }
    }
}

