/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.categories;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtension;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class Category
extends ExecutableExtension
implements ICategory,
IDisposable,
IPersistableElement {
    private ImageDescriptor descriptor = null;
    private Image image = null;
    private int rank = -1;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String attrRank;
        super.setInitializationData(config, propertyName, data);
        String attrIcon = config.getAttribute("icon");
        if (attrIcon != null) {
            this.descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)config.getNamespaceIdentifier(), (String)attrIcon);
            if (this.descriptor != null) {
                this.image = JFaceResources.getResources().createImageWithDefault(this.descriptor);
            }
        }
        if ((attrRank = config.getAttribute("rank")) != null) {
            try {
                this.rank = Integer.valueOf(attrRank);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPersistableElement.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public void saveState(IMemento memento) {
        memento.putString("id", this.getId());
    }

    public String getFactoryId() {
        return "org.eclipse.tcf.te.ui.views.categoryFactory";
    }

    public void dispose() {
        if (this.descriptor != null) {
            JFaceResources.getResources().destroyImage(this.descriptor);
            this.descriptor = null;
        }
        this.image = null;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public int getRank() {
        return this.rank;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getLabel());
        buffer.append(" [");
        buffer.append(this.getId());
        buffer.append("] {rank=");
        buffer.append(this.getRank());
        buffer.append("}");
        return buffer.toString();
    }
}

