/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.editor;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.tcf.te.ui.views.editor.EditorEventListener;
import org.eclipse.tcf.te.ui.views.editor.EditorInput;
import org.eclipse.tcf.te.ui.views.extensions.EditorPageBinding;
import org.eclipse.tcf.te.ui.views.extensions.EditorPageBindingExtensionPointManager;
import org.eclipse.tcf.te.ui.views.extensions.EditorPageExtensionPointManager;
import org.eclipse.tcf.te.ui.views.interfaces.IEditorPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public final class Editor
extends FormEditor
implements IPersistableEditor,
ITabbedPropertySheetPageContributor {
    private IMemento mementoToRestore;
    private EditorEventListener listener;

    protected void addPages() {
        EditorPageBinding[] bindings;
        IEditorInput input = this.getEditorInput();
        EditorPageBinding[] editorPageBindingArray = bindings = EditorPageBindingExtensionPointManager.getInstance().getApplicableEditorPageBindings(input);
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            EditorPageBinding binding = editorPageBindingArray[n2];
            this.processPageBinding(binding);
            ++n2;
        }
        if (this.mementoToRestore != null) {
            for (Object page : this.pages) {
                if (!(page instanceof IPersistableEditor)) continue;
                ((IPersistableEditor)page).restoreState(this.mementoToRestore);
            }
            this.mementoToRestore = null;
        }
    }

    public void updatePageList() {
        IEditorInput input = this.getEditorInput();
        ArrayList<EditorPageBinding> bindings = new ArrayList<EditorPageBinding>(Arrays.asList(EditorPageBindingExtensionPointManager.getInstance().getApplicableEditorPageBindings(input)));
        ArrayList<Object> oldPages = this.pages != null ? new ArrayList<Object>(Arrays.asList(this.pages.toArray())) : new ArrayList();
        for (Object e : oldPages) {
            if (!(e instanceof IFormPage)) continue;
            IFormPage page = (IFormPage)e;
            EditorPageBinding binding = null;
            for (EditorPageBinding candidate : bindings) {
                if (!candidate.getPageId().equals(page.getId())) continue;
                binding = candidate;
                break;
            }
            if (binding != null) {
                bindings.remove((Object)binding);
                continue;
            }
            this.removePage(this.pages.indexOf(page));
        }
        for (EditorPageBinding editorPageBinding : bindings) {
            this.processPageBinding(editorPageBinding);
        }
    }

    protected void processPageBinding(EditorPageBinding binding) {
        IEditorPage page;
        Assert.isNotNull((Object)((Object)binding));
        String pageId = binding.getPageId();
        if (pageId != null && (page = EditorPageExtensionPointManager.getInstance().getEditorPage(pageId, true)) != null) {
            try {
                page.initialize(this);
                String insertBefore = binding.getInsertBefore().trim();
                String insertAfter = binding.getInsertAfter().trim();
                if (!"".equals(insertBefore)) {
                    if ("first".equalsIgnoreCase(insertBefore)) {
                        this.addPage(0, page);
                    } else {
                        int index = this.getIndexOf(insertBefore);
                        if (index != -1) {
                            this.addPage(index, page);
                        } else {
                            this.addPage(page);
                        }
                    }
                } else if (!"".equals(insertAfter) && !"last".equalsIgnoreCase(insertAfter)) {
                    int index = this.getIndexOf(insertAfter);
                    if (index != -1 && index + 1 < this.pages.size()) {
                        this.addPage(index + 1, page);
                    } else {
                        this.addPage(page);
                    }
                } else {
                    this.addPage(page);
                }
            }
            catch (PartInitException partInitException) {}
        }
    }

    private int getIndexOf(String pageId) {
        Assert.isNotNull((Object)pageId);
        int i = 0;
        while (i < this.pages.size()) {
            IFormPage fpage;
            Object page = this.pages.get(i);
            if (page instanceof IFormPage && (fpage = (IFormPage)page).getId().equals(pageId)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (!"".equals(input.getName())) {
            this.setPartName(input.getName());
        }
        if (this.listener != null) {
            this.listener.dispose();
            this.listener = null;
        }
        this.listener = new EditorEventListener(this);
    }

    public void updatePartName() {
        IEditorInput input = this.getEditorInput();
        String oldPartName = this.getPartName();
        if (input instanceof EditorInput) {
            ((EditorInput)input).name = null;
            if (!oldPartName.equals(input.getName())) {
                this.setPartName(input.getName());
            }
        }
    }

    public void dispose() {
        if (this.listener != null) {
            this.listener.dispose();
            this.listener = null;
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.commitPages(true);
        this.editorDirtyStateChanged();
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void restoreState(IMemento memento) {
        this.mementoToRestore = this.internalGetMemento(memento);
    }

    public void saveState(IMemento memento) {
        memento = this.internalGetMemento(memento);
        for (Object page : this.pages) {
            if (!(page instanceof IPersistable)) continue;
            ((IPersistable)page).saveState(memento);
        }
    }

    private IMemento internalGetMemento(IMemento memento) {
        IMemento editorMemento = memento;
        if (memento != null) {
            editorMemento = memento.getChild(Editor.class.getName());
            if (editorMemento == null) {
                editorMemento = memento.createChild(Editor.class.getName());
            }
        } else {
            editorMemento = XMLMemento.createWriteRoot((String)Editor.class.getName());
        }
        return editorMemento;
    }

    public Object getAdapter(Class adapter) {
        Object adapterInstance;
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        Object object = adapterInstance = this.getActivePageInstance() != null ? this.getActivePageInstance().getAdapter(adapter) : null;
        if (adapterInstance == null) {
            adapterInstance = super.getAdapter(adapter);
        }
        return adapterInstance;
    }

    public String getContributorId() {
        return "org.eclipse.tcf.te.ui";
    }
}

