/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.BaseEditBrowseTextControl;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;

public class TransportTypeControl
extends BaseEditBrowseTextControl {
    private static final List<String> TRANSPORT_TYPES = Arrays.asList("TCP", "SSL", "PIPE", "Custom");

    public TransportTypeControl(IDialogPage parentPage) {
        super(parentPage);
        this.setIsGroup(false);
        this.setReadOnly(true);
        this.setHideBrowseButton(true);
        this.setEditFieldLabel(Messages.TransportTypeControl_label);
        this.setAdjustBackgroundColor(parentPage != null);
    }

    public String[] getTransportTypes() {
        return TRANSPORT_TYPES.toArray(new String[TRANSPORT_TYPES.size()]);
    }

    public void setupPanel(Composite parent) {
        super.setupPanel(parent);
        ArrayList<String> transportTypeLabels = new ArrayList<String>();
        for (String transportType : TRANSPORT_TYPES) {
            String label = this.getTransportTypeLabel(transportType);
            if (label == null) continue;
            transportTypeLabels.add(label);
        }
        this.setEditFieldControlHistory(transportTypeLabels.toArray(new String[transportTypeLabels.size()]));
        SWTControlUtil.select((Control)this.getEditFieldControl(), (int)0);
        SWTControlUtil.setEnabled((Control)this.getEditFieldControl(), (transportTypeLabels.size() > 1 ? 1 : 0) != 0);
    }

    protected String getTransportTypeLabel(String transportType) {
        Assert.isNotNull((Object)transportType);
        if ("TCP".equals(transportType)) {
            return Messages.TransportTypeControl_tcpType_label;
        }
        if ("SSL".equals(transportType)) {
            return Messages.TransportTypeControl_sslType_label;
        }
        if ("PIPE".equals(transportType)) {
            return Messages.TransportTypeControl_pipeType_label;
        }
        if ("Custom".equals(transportType)) {
            return Messages.TransportTypeControl_customType_label;
        }
        return null;
    }

    public String getSelectedTransportType() {
        String type = this.getEditFieldControlText();
        if (Messages.TransportTypeControl_tcpType_label.equals(type)) {
            type = "TCP";
        } else if (Messages.TransportTypeControl_sslType_label.equals(type)) {
            type = "SSL";
        } else if (Messages.TransportTypeControl_pipeType_label.equals(type)) {
            type = "PIPE";
        } else if (Messages.TransportTypeControl_customType_label.equals(type)) {
            type = "Custom";
        }
        return type;
    }

    public void setSelectedTransportType(String transportType) {
        Assert.isNotNull((Object)transportType);
        String label = this.getTransportTypeLabel(transportType);
        int index = SWTControlUtil.indexOf((Control)this.getEditFieldControl(), (String)label);
        if (index != -1) {
            SWTControlUtil.select((Control)this.getEditFieldControl(), (int)index);
        }
    }

    public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
    }

    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
    }
}

