/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerManager;
import org.eclipse.tcf.te.runtime.statushandler.interfaces.IStatusHandler;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.views.Managers;
import org.eclipse.tcf.te.ui.views.ViewsUtil;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.tcf.te.ui.views.interfaces.categories.ICategorizable;
import org.eclipse.tcf.te.ui.views.interfaces.categories.ICategoryManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteHandler
extends AbstractHandler {
    private Shell shell = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null) {
            this.delete(selection, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    ViewsUtil.refresh((String)"org.eclipse.tcf.te.ui.views.View");
                }
            });
        }
        this.shell = null;
        return null;
    }

    public boolean canDelete(ISelection selection) {
        Assert.isNotNull((Object)selection);
        boolean canDelete = false;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            canDelete = true;
            for (Object element : (IStructuredSelection)selection) {
                if (!(element instanceof IPeerModel)) {
                    canDelete = false;
                    break;
                }
                boolean isStatic = this.isStatic((IPeerModel)element);
                boolean isStartedByCurrentUser = this.isStartedByCurrentUser((IPeerModel)element);
                if (!isStatic) {
                    ICategory[] categories;
                    ICategory[] iCategoryArray = categories = this.getParentCategories(selection, (IPeerModel)element);
                    int n = categories.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICategory category = iCategoryArray[n2];
                        if ("org.eclipse.tcf.te.ui.views.category.neighborhood".equals(category.getId())) {
                            canDelete = false;
                            break;
                        }
                        if ("org.eclipse.tcf.te.ui.views.category.mytargets".equals(category.getId()) && isStartedByCurrentUser) {
                            canDelete = false;
                            break;
                        }
                        ++n2;
                    }
                }
                if (!canDelete) break;
            }
        }
        return canDelete;
    }

    private boolean isStatic(final IPeerModel node) {
        Assert.isNotNull((Object)node);
        final AtomicBoolean isStatic = new AtomicBoolean();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String value = (String)node.getPeer().getAttributes().get("static.transient");
                isStatic.set(value != null && Boolean.parseBoolean(value.trim()));
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return isStatic.get();
    }

    private boolean isStartedByCurrentUser(final IPeerModel node) {
        Assert.isNotNull((Object)node);
        final AtomicReference username = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                username.set(node.getPeer().getUserName());
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return System.getProperty("user.name").equals(username.get());
    }

    private ICategory[] getParentCategories(ISelection selection, IPeerModel node) {
        Assert.isNotNull((Object)selection);
        Assert.isNotNull((Object)node);
        ArrayList<ICategory> categories = new ArrayList<ICategory>();
        if (selection instanceof ITreeSelection) {
            TreePath[] pathes;
            TreePath[] treePathArray = pathes = ((ITreeSelection)selection).getPathsFor((Object)node);
            int n = pathes.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                TreePath parentPath = path.getParentPath();
                while (parentPath != null) {
                    if (parentPath.getLastSegment() instanceof ICategory && !categories.contains(parentPath.getLastSegment())) {
                        categories.add((ICategory)parentPath.getLastSegment());
                        break;
                    }
                    parentPath = parentPath.getParentPath();
                }
                ++n2;
            }
        }
        return categories.toArray(new ICategory[categories.size()]);
    }

    public void delete(ISelection selection, final ICallback callback) {
        Operation[] operations;
        boolean confirmed;
        Assert.isNotNull((Object)selection);
        Assert.isNotNull((Object)callback);
        boolean invokeCallback = true;
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (confirmed = this.confirmDelete(operations = this.selection2operations((IStructuredSelection)selection)))) {
            ILocatorModelRefreshService service;
            ILocatorModel model;
            boolean refreshModel;
            block7: {
                refreshModel = false;
                try {
                    Operation[] operationArray = operations;
                    int n = operations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Operation op = operationArray[n2];
                        if (Operation.TYPE.Remove.equals((Object)op.type)) {
                            refreshModel = true;
                        }
                        op.execute();
                        ++n2;
                    }
                }
                catch (Exception e) {
                    Status status = new Status(4, UIPlugin.getUniqueIdentifier(), Messages.DeleteHandler_error_deleteFailed, (Throwable)e);
                    PropertiesContainer data = new PropertiesContainer();
                    data.setProperty("title", (Object)Messages.DeleteHandler_error_title);
                    data.setProperty("contextHelpId", (Object)IContextHelpIds.MESSAGE_DELETE_FAILED);
                    data.setProperty("caller", (Object)this);
                    IStatusHandler[] handler = StatusHandlerManager.getInstance().getHandler((Object)selection);
                    if (handler.length <= 0) break block7;
                    handler[0].handleStatus((IStatus)status, (IPropertiesContainer)data, null);
                }
            }
            if (refreshModel && (model = Model.getModel()) != null && (service = (ILocatorModelRefreshService)model.getService(ILocatorModelRefreshService.class)) != null) {
                invokeCallback = false;
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        service.refresh();
                        callback.done((Object)DeleteHandler.this, Status.OK_STATUS);
                    }
                });
            }
        }
        if (invokeCallback) {
            callback.done((Object)this, Status.OK_STATUS);
        }
    }

    private Operation[] selection2operations(IStructuredSelection selection) {
        Assert.isNotNull((Object)selection);
        ArrayList<Operation> operations = new ArrayList<Operation>();
        for (Object element : selection) {
            Assert.isTrue((boolean)(element instanceof IPeerModel));
            IPeerModel node = (IPeerModel)element;
            boolean isStatic = this.isStatic(node);
            ICategory[] categories = this.getParentCategories((ISelection)selection, node);
            if (categories.length == 0 && isStatic) {
                Operation op = new Operation();
                op.node = node;
                op.type = Operation.TYPE.Remove;
                operations.add(op);
                continue;
            }
            ICategory[] iCategoryArray = categories;
            int n = categories.length;
            int n2 = 0;
            while (n2 < n) {
                Operation op;
                ICategory category = iCategoryArray[n2];
                if ("org.eclipse.tcf.te.ui.views.category.favorites".equals(category.getId())) {
                    op = new Operation();
                    op.node = node;
                    op.type = Operation.TYPE.Unlink;
                    op.parentCategory = category;
                    operations.add(op);
                } else if ("org.eclipse.tcf.te.ui.views.category.mytargets".equals(category.getId())) {
                    op = new Operation();
                    op.node = node;
                    if (isStatic) {
                        op.type = Operation.TYPE.Remove;
                    } else {
                        op.type = Operation.TYPE.Unlink;
                        op.parentCategory = category;
                    }
                    operations.add(op);
                }
                ++n2;
            }
        }
        return operations.toArray(new Operation[operations.size()]);
    }

    private boolean confirmDelete(Operation[] operations) {
        Assert.isNotNull((Object)operations);
        boolean confirmed = false;
        ArrayList<Operation> toRemove = new ArrayList<Operation>();
        Operation[] operationArray = operations;
        int n = operations.length;
        int n2 = 0;
        while (n2 < n) {
            Operation op = operationArray[n2];
            if (Operation.TYPE.Remove.equals((Object)op.type)) {
                toRemove.add(op);
            }
            ++n2;
        }
        if (!toRemove.isEmpty()) {
            String question = this.getConfirmQuestion(toRemove);
            Shell parent = this.shell != null ? this.shell : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            confirmed = MessageDialog.openQuestion((Shell)parent, (String)Messages.DeleteHandlerDelegate_DialogTitle, (String)question);
        } else {
            confirmed = true;
        }
        return confirmed;
    }

    private String getConfirmQuestion(List<Operation> toRemove) {
        String question;
        Assert.isNotNull(toRemove);
        if (toRemove.size() == 1) {
            final Operation op = toRemove.get(0);
            final AtomicReference name = new AtomicReference();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    name.set(op.node.getPeer().getName());
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            question = NLS.bind((String)Messages.DeleteHandlerDelegate_MsgDeleteOnePeer, name.get());
        } else {
            question = NLS.bind((String)Messages.DeleteHandlerDelegate_MsgDeleteMultiplePeers, (Object)toRemove.size());
        }
        return question;
    }

    private static class Operation {
        public IPeerModel node;
        public TYPE type;
        public ICategory parentCategory;

        public void execute() throws Exception {
            Assert.isNotNull((Object)this.node);
            Assert.isNotNull((Object)((Object)this.type));
            if (TYPE.Remove.equals((Object)this.type)) {
                IURIPersistenceService service = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                if (service == null) {
                    throw new IOException("Persistence service instance unavailable.");
                }
                service.delete((Object)this.node, null);
            } else if (TYPE.Unlink.equals((Object)this.type)) {
                Assert.isNotNull((Object)this.parentCategory);
                ICategoryManager manager = Managers.getCategoryManager();
                Assert.isNotNull((Object)manager);
                ICategorizable categorizable = (ICategorizable)this.node.getAdapter(ICategorizable.class);
                if (categorizable == null) {
                    categorizable = (ICategorizable)Platform.getAdapterManager().getAdapter((Object)this.node, ICategorizable.class);
                }
                Assert.isNotNull((Object)categorizable);
                manager.remove(this.parentCategory.getId(), categorizable.getId());
            }
        }

        public static enum TYPE {
            Remove,
            Unlink;

        }
    }
}

