/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.internal.tabbed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.ui.nls.Messages;
import org.eclipse.tcf.te.ui.tables.properties.NodePropertiesTableTableNode;
import org.eclipse.ui.forms.widgets.Section;

public class PeerGeneralSectionContentProvider
implements IStructuredContentProvider {
    private final boolean updateParentSectionTitle;

    public PeerGeneralSectionContentProvider(boolean updateParentSectionTitle) {
        this.updateParentSectionTitle = updateParentSectionTitle;
    }

    public void dispose() {
    }

    public Object[] getElements(final Object inputElement) {
        ArrayList<NodePropertiesTableTableNode> nodes = new ArrayList<NodePropertiesTableTableNode>();
        if (inputElement instanceof IPeerModel) {
            final HashMap properties = new HashMap();
            if (Protocol.isDispatchThread()) {
                properties.putAll(((IPeerModel)inputElement).getPeer().getAttributes());
            } else {
                Protocol.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        properties.putAll(((IPeerModel)inputElement).getPeer().getAttributes());
                    }
                });
            }
            for (Map.Entry entry : properties.entrySet()) {
                String name = (String)entry.getKey();
                if (name.endsWith(".silent") || name.contains(".transient")) continue;
                NodePropertiesTableTableNode propertiesNode = new NodePropertiesTableTableNode(name, entry.getValue() != null ? entry.getValue().toString() : "");
                nodes.add(propertiesNode);
            }
        }
        return nodes.toArray(new NodePropertiesTableTableNode[nodes.size()]);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (!this.updateParentSectionTitle) {
            return;
        }
        String sectionTitle = null;
        Object element = null;
        if (newInput instanceof ITreeSelection && !((ITreeSelection)newInput).isEmpty()) {
            ITreeSelection selection = (ITreeSelection)newInput;
            TreePath[] pathes = selection.getPaths();
            TreePath path = pathes.length > 0 ? pathes[0] : null;
            Object object = element = path != null ? path.getLastSegment() : null;
        }
        if (newInput instanceof IPeerModel) {
            element = newInput;
        }
        if (element instanceof IPeerModel) {
            sectionTitle = NLS.bind((String)Messages.NodePropertiesTableControl_section_title, (Object)"Peer");
        }
        if (sectionTitle == null || "".equals(sectionTitle.trim())) {
            sectionTitle = Messages.NodePropertiesTableControl_section_title_noSelection;
        }
        if (sectionTitle.length() < 40) {
            StringBuilder buffer = new StringBuilder(sectionTitle);
            while (buffer.length() < 40) {
                buffer.append(" ");
            }
            sectionTitle = buffer.toString();
        }
        Control control = viewer.getControl();
        while (control != null && !control.isDisposed()) {
            if (control instanceof Section) {
                Section section = (Section)control;
                try {
                    section.setText(sectionTitle);
                }
                catch (SWTException sWTException) {}
                break;
            }
            control = control.getParent();
        }
    }
}

