/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.navigator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.IModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerRedirector;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.ui.navigator.ModelListener;
import org.eclipse.tcf.te.tcf.ui.navigator.nodes.PeerRedirectorGroupNode;
import org.eclipse.tcf.te.ui.swt.DisplayUtil;
import org.eclipse.tcf.te.ui.views.Managers;
import org.eclipse.tcf.te.ui.views.extensions.CategoriesExtensionPointManager;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.tcf.te.ui.views.interfaces.IRoot;
import org.eclipse.tcf.te.ui.views.interfaces.categories.ICategorizable;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.navigator.NavigatorFilterService;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorFilterService;

public class ContentProviderDelegate
implements ICommonContentProvider,
ITreePathContentProvider {
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final String REDIRECT_PEERS_FILTER_ID = "org.eclipse.tcf.te.tcf.ui.navigator.RedirectPeersFilter";
    IModelListener modelListener = null;
    private final Map<String, PeerRedirectorGroupNode> roots = new HashMap<String, PeerRedirectorGroupNode>();

    public Object[] getChildren(Object parentElement) {
        List candidates;
        String catID;
        Object[] children = NO_ELEMENTS;
        String string = catID = parentElement instanceof ICategory ? ((ICategory)parentElement).getId() : null;
        if (parentElement instanceof ICategory) {
            parentElement = Model.getModel();
        }
        if (parentElement instanceof ILocatorModel) {
            final IPeerModel[] peers = ((ILocatorModel)parentElement).getPeers();
            final ArrayList candidates2 = new ArrayList();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    block16: {
                        block17: {
                            block15: {
                                if (!"org.eclipse.tcf.te.ui.views.category.favorites".equals(catID)) break block15;
                                IPeerModel[] iPeerModelArray = peers;
                                int n = peers.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IPeerModel peer = iPeerModelArray[n2];
                                    ICategorizable categorizable = (ICategorizable)peer.getAdapter(ICategorizable.class);
                                    if (categorizable == null) {
                                        categorizable = (ICategorizable)Platform.getAdapterManager().getAdapter((Object)peer, ICategorizable.class);
                                    }
                                    Assert.isNotNull((Object)categorizable);
                                    boolean isFavorite = Managers.getCategoryManager().belongsTo(catID, categorizable.getId());
                                    if (isFavorite && !candidates2.contains(peer)) {
                                        candidates2.add(peer);
                                    }
                                    ++n2;
                                }
                                break block16;
                            }
                            if (!"org.eclipse.tcf.te.ui.views.category.mytargets".equals(catID)) break block17;
                            IPeerModel[] iPeerModelArray = peers;
                            int n = peers.length;
                            int n3 = 0;
                            while (n3 < n) {
                                IPeerModel peer = iPeerModelArray[n3];
                                ICategorizable categorizable = (ICategorizable)peer.getAdapter(ICategorizable.class);
                                if (categorizable == null) {
                                    categorizable = (ICategorizable)Platform.getAdapterManager().getAdapter((Object)peer, ICategorizable.class);
                                }
                                Assert.isNotNull((Object)categorizable);
                                String value = (String)peer.getPeer().getAttributes().get("static.transient");
                                boolean isStatic = value != null && Boolean.parseBoolean(value.trim());
                                boolean isProxy = peer.getPeer().getAttributes().containsKey("Proxy");
                                value = (String)peer.getPeer().getAttributes().get("ValueAdd");
                                boolean isValueAdd = value != null && ("1".equals(value.trim()) || Boolean.parseBoolean(value.trim()));
                                boolean startedByCurrentUser = System.getProperty("user.name").equals(peer.getPeer().getUserName());
                                boolean isMyTargets = Managers.getCategoryManager().belongsTo(catID, categorizable.getId());
                                if (!isMyTargets && (isStatic || startedByCurrentUser)) {
                                    if (isProxy || isValueAdd) {
                                        Managers.getCategoryManager().addTransient(catID, categorizable.getId());
                                    } else {
                                        Managers.getCategoryManager().add(catID, categorizable.getId());
                                    }
                                    isMyTargets = true;
                                }
                                if (isMyTargets && !candidates2.contains(peer)) {
                                    candidates2.add(peer);
                                }
                                ++n3;
                            }
                            break block16;
                        }
                        if (!"org.eclipse.tcf.te.ui.views.category.neighborhood".equals(catID)) break block16;
                        IPeerModel[] iPeerModelArray = peers;
                        int n = peers.length;
                        int n4 = 0;
                        while (n4 < n) {
                            IPeerModel peer = iPeerModelArray[n4];
                            ICategorizable categorizable = (ICategorizable)peer.getAdapter(ICategorizable.class);
                            if (categorizable == null) {
                                categorizable = (ICategorizable)Platform.getAdapterManager().getAdapter((Object)peer, ICategorizable.class);
                            }
                            Assert.isNotNull((Object)categorizable);
                            String value = (String)peer.getPeer().getAttributes().get("static.transient");
                            boolean isStatic = value != null && Boolean.parseBoolean(value.trim());
                            boolean isProxy = peer.getPeer().getAttributes().containsKey("Proxy");
                            value = (String)peer.getPeer().getAttributes().get("ValueAdd");
                            boolean isValueAdd = value != null && ("1".equals(value.trim()) || Boolean.parseBoolean(value.trim()));
                            boolean isNeighborhood = Managers.getCategoryManager().belongsTo(catID, categorizable.getId());
                            if (!isNeighborhood && !isStatic) {
                                if (isProxy || isValueAdd) {
                                    Managers.getCategoryManager().addTransient(catID, categorizable.getId());
                                } else {
                                    Managers.getCategoryManager().add(catID, categorizable.getId());
                                }
                                isNeighborhood = true;
                            }
                            if (!(!isNeighborhood && isStatic || candidates2.contains(peer))) {
                                candidates2.add(peer);
                            }
                            ++n4;
                        }
                    }
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            children = candidates2.toArray(new IPeerModel[candidates2.size()]);
        } else if (parentElement instanceof IPeerModel) {
            String parentPeerId = ((IPeerModel)parentElement).getPeerId();
            List candidates3 = Model.getModel().getChildren(parentPeerId);
            if (candidates3 != null && candidates3.size() > 0) {
                PeerRedirectorGroupNode rootNode = this.roots.get(parentPeerId);
                if (rootNode == null) {
                    rootNode = new PeerRedirectorGroupNode(parentPeerId);
                    this.roots.put(parentPeerId, rootNode);
                }
                children = new Object[]{rootNode};
            } else {
                this.roots.remove(parentPeerId);
            }
        } else if (parentElement instanceof PeerRedirectorGroupNode && (candidates = Model.getModel().getChildren(((PeerRedirectorGroupNode)parentElement).peerId)) != null && candidates.size() > 0) {
            children = candidates.toArray();
        }
        return children;
    }

    public Object[] getChildren(TreePath parentPath) {
        return parentPath != null ? this.getChildren(parentPath.getLastSegment()) : NO_ELEMENTS;
    }

    public Object getParent(final Object element) {
        if (element instanceof IPeerModel) {
            if (((IPeerModel)element).getPeer() instanceof IPeerRedirector) {
                IPeer parentPeer = ((IPeerRedirector)((IPeerModel)element).getPeer()).getParent();
                String parentPeerId = parentPeer.getID();
                if (!this.roots.containsKey(parentPeerId)) {
                    this.roots.put(parentPeer.getID(), new PeerRedirectorGroupNode(parentPeerId));
                }
                return this.roots.get(parentPeerId);
            }
            ILocatorModel category = null;
            String[] categoryIds = Managers.getCategoryManager().getCategoryIds(((IPeerModel)element).getPeerId());
            if (categoryIds != null && categoryIds.length > 0) {
                category = CategoriesExtensionPointManager.getInstance().getCategory(categoryIds[0], false);
            }
            return category != null ? category : ((IPeerModel)element).getModel();
        }
        if (element instanceof PeerRedirectorGroupNode) {
            final AtomicReference parent = new AtomicReference();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    parent.set(((ILocatorModelLookupService)Model.getModel().getService(ILocatorModelLookupService.class)).lkupPeerModelById(((PeerRedirectorGroupNode)element).peerId));
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            return parent.get();
        }
        return null;
    }

    public TreePath[] getParents(Object element) {
        ArrayList<TreePath> pathes = new ArrayList<TreePath>();
        if (element instanceof IPeerModel) {
            Object parent;
            ICategory favCategory;
            if (Managers.getCategoryManager().belongsTo("org.eclipse.tcf.te.ui.views.category.favorites", ((IPeerModel)element).getPeerId()) && (favCategory = CategoriesExtensionPointManager.getInstance().getCategory("org.eclipse.tcf.te.ui.views.category.favorites", false)) != null) {
                pathes.add(new TreePath(new Object[]{favCategory}));
            }
            if ((parent = this.getParent(element)) != null) {
                pathes.add(new TreePath(new Object[]{parent}));
            }
        }
        return pathes.toArray(new TreePath[pathes.size()]);
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = false;
        if (element instanceof ILocatorModel) {
            hasChildren = ((ILocatorModel)element).getPeers().length > 0;
        } else if (element instanceof IPeerModel) {
            List children = Model.getModel().getChildren(((IPeerModel)element).getPeerId());
            hasChildren = children != null && children.size() > 0;
        } else if (element instanceof PeerRedirectorGroupNode) {
            List children = Model.getModel().getChildren(((PeerRedirectorGroupNode)element).peerId);
            hasChildren = children != null && children.size() > 0;
        } else if (element instanceof ICategory) {
            Object[] children = this.getChildren(element);
            hasChildren = children != null && children.length > 0;
        }
        return hasChildren;
    }

    public boolean hasChildren(TreePath path) {
        return path != null ? this.hasChildren(path.getLastSegment()) : false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.roots.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        final ILocatorModel model = Model.getModel();
        if (this.modelListener == null && model != null && viewer instanceof CommonViewer) {
            this.modelListener = new ModelListener(model, (CommonViewer)viewer);
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    model.addListener(ContentProviderDelegate.this.modelListener);
                }
            });
        }
        if (model != null && newInput instanceof IRoot) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((ILocatorModelRefreshService)model.getService(ILocatorModelRefreshService.class)).refresh();
                }
            });
        }
    }

    public void init(ICommonContentExtensionSite config) {
        INavigatorFilterService fs;
        Assert.isNotNull((Object)config);
        INavigatorContentService cs = config.getService();
        INavigatorFilterService iNavigatorFilterService = fs = cs != null ? cs.getFilterService() : null;
        if (fs != null && !fs.isActive(REDIRECT_PEERS_FILTER_ID) && fs instanceof NavigatorFilterService) {
            final NavigatorFilterService navFilterService = (NavigatorFilterService)fs;
            navFilterService.addActiveFilterIds(new String[]{REDIRECT_PEERS_FILTER_ID});
            DisplayUtil.safeAsyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    navFilterService.updateViewer();
                }
            });
        }
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }
}

