/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreePathViewerSorter;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tcf.te.ui.trees.Pending;

public class TreeViewerSorter
extends TreePathViewerSorter {
    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof Pending || e2 instanceof Pending) {
            return e1 instanceof Pending ? (e2 instanceof Pending ? 0 : 1) : -1;
        }
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            return this.doCompare(viewer, e1, e2, this.doGetSortColumnLabel(viewer), this.doGetSortColumnIndex(viewer), this.doDetermineInverter(viewer));
        }
        return super.compare(viewer, e1, e2);
    }

    protected String doGetText(Viewer viewer, Object node, int index) {
        if (node != null && this.doGetLabelProvider(viewer) != null) {
            return this.doGetLabelProvider(viewer).getText(node);
        }
        return null;
    }

    protected ILabelProvider doGetLabelProvider(Viewer viewer) {
        IBaseLabelProvider candidate;
        if (viewer instanceof ContentViewer && (candidate = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
            return (ILabelProvider)candidate;
        }
        return null;
    }

    protected int doDetermineInverter(Viewer viewer) {
        Tree tree;
        int inverter = 1;
        if (viewer instanceof TreeViewer && ((TreeViewer)viewer).getTree() != null && !(tree = ((TreeViewer)viewer).getTree()).isDisposed() && tree.getSortDirection() == 1024) {
            inverter = -1;
        }
        return inverter;
    }

    protected String doGetSortColumnLabel(Viewer viewer) {
        if (viewer instanceof TreeViewer && ((TreeViewer)viewer).getTree() != null && !((TreeViewer)viewer).getTree().isDisposed()) {
            Tree tree = ((TreeViewer)viewer).getTree();
            return tree.getSortColumn() != null ? tree.getSortColumn().getText() : "";
        }
        return "";
    }

    protected int doGetSortColumnIndex(Viewer viewer) {
        if (viewer instanceof TreeViewer && ((TreeViewer)viewer).getTree() != null && !((TreeViewer)viewer).getTree().isDisposed()) {
            Tree tree = ((TreeViewer)viewer).getTree();
            return tree.getSortColumn() != null ? Arrays.asList(tree.getColumns()).indexOf(tree.getSortColumn()) : -1;
        }
        return -1;
    }

    protected int doCompare(Viewer viewer, Object node1, Object node2, String sortColumn, int index, int inverter) {
        if (node1 == null && node2 == null) {
            return 0;
        }
        if (node1 != null && node2 == null) {
            return 1;
        }
        if (node1 == null && node2 != null) {
            return -1;
        }
        String text1 = this.doGetText(viewer, node1, index);
        String text2 = this.doGetText(viewer, node2, index);
        if (text1.length() > 0 && text2.length() > 0) {
            char c1 = text1.charAt(0);
            char c2 = text2.charAt(0);
            if (Character.isDigit(c1) || Character.isDigit(c2)) {
                if (Character.isDigit(c1) && !Character.isDigit(c2)) {
                    return -1 * inverter;
                }
                if (!Character.isDigit(c1) && Character.isDigit(c2)) {
                    return 1 * inverter;
                }
            }
            if (Character.isUpperCase(c1) || Character.isUpperCase(c2)) {
                if (Character.isUpperCase(c1) && !Character.isUpperCase(c2)) {
                    return -1 * inverter;
                }
                if (!Character.isUpperCase(c1) && Character.isUpperCase(c2)) {
                    return 1 * inverter;
                }
            }
            Matcher m1 = Pattern.compile("(\\D+)(\\d+)").matcher(text1);
            Matcher m2 = Pattern.compile("(\\D+)(\\d+)").matcher(text2);
            if (m1.matches() && m2.matches()) {
                String p11 = m1.group(1);
                String p12 = m1.group(2);
                String p21 = m2.group(1);
                String p22 = m2.group(2);
                if (p11 != null && p11.equals(p21)) {
                    try {
                        int result = 0;
                        long l1 = Long.parseLong(p12);
                        long l2 = Long.parseLong(p22);
                        if (l1 > l2) {
                            result = 1;
                        }
                        if (l1 < l2) {
                            result = -1;
                        }
                        return result;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            if (text1.matches(".*[A-Z]+.*") || text2.matches(".*[A-Z]+.*")) {
                if (text1.matches(".*[A-Z]+.*") && !text2.matches(".*[A-Z]+.*")) {
                    return -1 * inverter;
                }
                if (!text1.matches(".*[A-Z]+.*") && text2.matches(".*[A-Z]+.*")) {
                    return 1 * inverter;
                }
                int minLength = Math.min(text1.length(), text2.length());
                int i = 0;
                while (i < minLength) {
                    char ch1 = text1.charAt(i);
                    char ch2 = text2.charAt(i);
                    if (Character.isUpperCase(ch1) && !Character.isUpperCase(ch2)) {
                        return -1 * inverter;
                    }
                    if (!Character.isUpperCase(ch1) && Character.isUpperCase(ch2)) {
                        return 1 * inverter;
                    }
                    if (Character.isUpperCase(ch1) && Character.isUpperCase(ch2)) break;
                    ++i;
                }
            }
        }
        return this.getComparator().compare(text1, text2) * inverter;
    }
}

