/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.wizards.newWizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class NewWizardCategory
implements IWizardCategory,
IWorkbenchAdapter {
    private String id;
    private String label;
    private IWizardCategory parent;
    private List<IWizardCategory> categories = new ArrayList<IWizardCategory>();
    private List<IWizardDescriptor> wizards = new ArrayList<IWizardDescriptor>();

    public NewWizardCategory(String id, String label) {
        this.id = id;
        this.label = label;
    }

    public NewWizardCategory(IWizardCategory baseCategory) {
        IWizardDescriptor[] baseWizards;
        this.id = baseCategory.getId();
        this.label = baseCategory.getLabel();
        this.parent = baseCategory.getParent();
        IWizardCategory[] baseCategories = baseCategory.getCategories();
        if (baseCategories != null && baseCategories.length > 0) {
            this.categories = new ArrayList<IWizardCategory>(Arrays.asList(baseCategories));
        }
        if ((baseWizards = baseCategory.getWizards()) != null && baseWizards.length > 0) {
            this.wizards = new ArrayList<IWizardDescriptor>(Arrays.asList(baseWizards));
        }
    }

    public void clear() {
        this.categories.clear();
        this.wizards.clear();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof IWizardCategory) {
            return ((IWizardCategory)other).getId().equals(this.getId());
        }
        return super.equals(other);
    }

    public void setParent(IWizardCategory parent) {
        this.parent = parent;
    }

    public IWizardCategory findCategory(IPath path) {
        String searchString = path.segment(0);
        IWizardCategory[] iWizardCategoryArray = this.getCategories();
        int n = iWizardCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardCategory category = iWizardCategoryArray[n2];
            if (category.getId().equals(searchString)) {
                if (path.segmentCount() == 1) {
                    return category;
                }
                return category.findCategory(path.removeFirstSegments(1));
            }
            ++n2;
        }
        return null;
    }

    public IWizardCategory findCategory(String id) {
        IWizardCategory category;
        IWizardCategory[] iWizardCategoryArray = this.getCategories();
        int n = iWizardCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            category = iWizardCategoryArray[n2];
            if (id.equals(category.getId())) {
                return category;
            }
            ++n2;
        }
        iWizardCategoryArray = this.getCategories();
        n = iWizardCategoryArray.length;
        n2 = 0;
        while (n2 < n) {
            category = iWizardCategoryArray[n2];
            IWizardCategory found = null;
            if (category instanceof NewWizardCategory) {
                found = ((NewWizardCategory)category).findCategory(id);
            }
            if (category instanceof WizardCollectionElement) {
                found = ((WizardCollectionElement)category).findCategory(id);
            }
            if (found != null) {
                return found;
            }
            ++n2;
        }
        return null;
    }

    public IWizardDescriptor findWizard(String id) {
        IWizardDescriptor[] iWizardDescriptorArray = this.getWizards();
        int n = iWizardDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardDescriptor wizard = iWizardDescriptorArray[n2];
            if (wizard.getId().equals(id)) {
                return wizard;
            }
            ++n2;
        }
        iWizardDescriptorArray = this.getCategories();
        n = iWizardDescriptorArray.length;
        n2 = 0;
        while (n2 < n) {
            IWizardDescriptor category = iWizardDescriptorArray[n2];
            IWizardDescriptor wizard = category.findWizard(id);
            if (wizard != null) {
                return wizard;
            }
            ++n2;
        }
        return null;
    }

    public void addCategory(IWizardCategory category) {
        Assert.isNotNull((Object)category);
        this.categories.add(category);
    }

    public void removeCategory(IWizardCategory category) {
        Assert.isNotNull((Object)category);
        this.categories.remove(category);
    }

    public IWizardCategory[] getCategories() {
        return this.categories.toArray(new IWizardCategory[this.categories.size()]);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public IWizardCategory getParent() {
        return this.parent;
    }

    public IPath getPath() {
        return this.getParent() != null ? this.getParent().getPath().append(this.getId()) : new Path(this.getId());
    }

    public void addWizard(IWizardDescriptor wizard) {
        this.wizards.add(wizard);
    }

    public IWizardDescriptor[] getWizards() {
        return this.wizards.toArray(new IWizardDescriptor[this.wizards.size()]);
    }

    public Object[] getChildren(Object o) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return WorkbenchImages.getImageDescriptor((String)"IMG_OBJ_FOLDER");
    }

    public String getLabel(Object o) {
        return this.getLabel();
    }

    public Object getParent(Object o) {
        return this.getParent();
    }
}

