/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.wire.serial;

import gnu.io.CommPortIdentifier;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.controls.activator.UIPlugin;
import org.eclipse.tcf.te.ui.controls.nls.Messages;
import org.eclipse.tcf.te.ui.controls.panels.AbstractWizardConfigurationPanel;
import org.eclipse.tcf.te.ui.controls.validator.NumberValidator;
import org.eclipse.tcf.te.ui.controls.validator.Validator;
import org.eclipse.tcf.te.ui.controls.wire.serial.SerialPortAddressDialog;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode3;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class SerialLinePanel
extends AbstractWizardConfigurationPanel
implements IDataExchangeNode3 {
    public static final String fcDefaultTTYSpeed = "9600";
    public static final String fcDefaultTTYDeviceWin32 = "COM1";
    public static final String fcDefaultTTYDeviceSolaris = "/dev/cua/a";
    public static final String fcDefaultTTYDeviceLinux = "/dev/ttyS0";
    public static final String fcDefaultTTYDatabits = "8";
    public static final String fcDefaultTTYParity = "None";
    public static final String fcDefaultTTYStopbits = "1";
    public static final String fcDefaultTTYFlowControl = "None";
    public static final String fcDefaultTTYTimeout = "5";
    public static final String fcEditableTTYOther = "Other...";
    public static final String[] fcTTYSpeedRates = new String[]{"600", "1200", "2400", "4800", "9600", "14400", "19200", "38400", "57600", "115200"};
    public static final String[] fcTTYDatabits = new String[]{"8", "7"};
    public static final String[] fcTTYParity = new String[]{"None", "Odd", "Even"};
    public static final String[] fcTTYStopbits = new String[]{"1", "2"};
    public static final String[] fcTTYFlowControl = new String[]{"None", "Hardware", "Software"};
    private final boolean editable;
    private final boolean terminalMode;
    private final boolean showAdvancedSerialOptions;
    Label hostTTYDeviceLabel;
    Combo hostTTYDeviceCombo;
    Label hostTTYSpeedLabel;
    Combo hostTTYSpeedCombo;
    Label hostTTYBitsLabel;
    Combo hostTTYBitsCombo;
    Label hostTTYParityLabel;
    Combo hostTTYParityCombo;
    Label hostTTYStopbitsLabel;
    Combo hostTTYStopbitsCombo;
    Label hostTTYFlowControlLabel;
    Combo hostTTYFlowControlCombo;
    Label hostTTYTimeoutLabel;
    Text hostTTYTimeoutText;
    protected IInputValidator inputValidatorBaud;
    int lastSelected = -1;
    int lastSelectedBaud = -1;
    private final String fcSelectedTTYDeviceSlotId = "SerialLinePanel.selectedTTYDevice." + System.getProperty("os.name");
    private final String fcSelectedTTYSpeedRateSlotId = "SerialLinePanel.selectedTTYSpeedRate." + System.getProperty("os.name");
    private final String fcSelectedTTYDatabitsSlotId = "SerialLinePanel.selectedTTYDatabits." + System.getProperty("os.name");
    private final String fcSelectedTTYParitySlotId = "SerialLinePanel.selectedTTYParity." + System.getProperty("os.name");
    private final String fcSelectedTTYStopbitsSlotId = "SerialLinePanel.selectedTTYStopbits." + System.getProperty("os.name");
    private final String fcSelectedTTYFlowControlSlotId = "SerialLinePanel.selectedTTYFlowControl." + System.getProperty("os.name");
    private final String fcSelectedTTYTimeoutSlotId = "SerialLinePanel.selectedTTYTimeout." + System.getProperty("os.name");

    public SerialLinePanel(BaseDialogPageControl parentPageControl, boolean terminalMode, boolean editable) {
        this(parentPageControl, terminalMode, editable, false);
    }

    public SerialLinePanel(BaseDialogPageControl parentPageControl, boolean terminalMode, boolean editable, boolean showAdvancedOptions) {
        super(parentPageControl);
        this.terminalMode = terminalMode;
        this.editable = editable;
        this.showAdvancedSerialOptions = showAdvancedOptions;
    }

    protected IInputValidator getCustomSerialBaudRateInputValidator() {
        if (this.inputValidatorBaud == null) {
            this.inputValidatorBaud = new CustomSerialBaudRateInputValidator();
        }
        return this.inputValidatorBaud;
    }

    protected boolean isAdjustBackgroundColor() {
        return this.getParentControl().getParentPage() != null || this.terminalMode;
    }

    @Override
    public void setupPanel(Composite parent, FormToolkit toolkit) {
        Composite section;
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)toolkit);
        boolean adjustBackgroundColor = this.isAdjustBackgroundColor();
        Composite panel = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (adjustBackgroundColor) {
            panel.setBackground(parent.getBackground());
        }
        this.setControl(panel);
        if (!this.terminalMode) {
            section = toolkit.createSection(panel, 256);
            Assert.isNotNull((Object)section);
            ((Section)section).setText(Messages.SerialLinePanel_section);
            section.setLayout((Layout)new GridLayout());
            section.setLayoutData((Object)new GridData(4, 1, true, false));
        } else {
            section = panel;
        }
        if (adjustBackgroundColor) {
            section.setBackground(panel.getBackground());
        }
        final Composite client = toolkit.createComposite(section);
        Assert.isNotNull((Object)client);
        client.setLayout((Layout)new GridLayout(this.terminalMode ? 2 : 4, false));
        client.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (adjustBackgroundColor) {
            client.setBackground(section.getBackground());
        }
        if (section instanceof Section) {
            ((Section)section).setClient((Control)client);
        }
        this.hostTTYDeviceLabel = new Label(client, 0);
        this.hostTTYDeviceLabel.setText(this.terminalMode ? Messages.SerialLinePanel_hostTTYDevice_label_terminalMode : Messages.SerialLinePanel_hostTTYDevice_label);
        this.hostTTYDeviceCombo = new Combo(client, 2060);
        this.hostTTYDeviceCombo.setLayoutData((Object)new GridData(768));
        this.hostTTYDeviceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SerialLinePanel.fcEditableTTYOther.equals(SWTControlUtil.getText((Control)SerialLinePanel.this.hostTTYDeviceCombo))) {
                    ArrayList<String> tty = new ArrayList<String>();
                    ArrayList<String> tcp = new ArrayList<String>();
                    String selected = SWTControlUtil.getItem((Control)SerialLinePanel.this.hostTTYDeviceCombo, (int)SerialLinePanel.this.lastSelected);
                    String[] stringArray = SWTControlUtil.getItems((Control)SerialLinePanel.this.hostTTYDeviceCombo);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String device = stringArray[n2];
                        if (!device.equalsIgnoreCase(SerialLinePanel.fcEditableTTYOther)) {
                            if (device.toUpperCase().startsWith("TCP:")) {
                                tcp.add(device);
                            } else {
                                tty.add(device);
                            }
                        }
                        ++n2;
                    }
                    SerialPortAddressDialog dialog = new SerialPortAddressDialog(client.getShell(), selected, tty, tcp);
                    if (dialog.open() == 0) {
                        String device = dialog.getData();
                        if (device != null && device.trim().length() > 0) {
                            SWTControlUtil.add((Control)SerialLinePanel.this.hostTTYDeviceCombo, (String)device.trim());
                            SWTControlUtil.setText((Control)SerialLinePanel.this.hostTTYDeviceCombo, (String)device.trim());
                        } else if (SerialLinePanel.this.lastSelected != -1) {
                            SWTControlUtil.setText((Control)SerialLinePanel.this.hostTTYDeviceCombo, (String)SWTControlUtil.getItem((Control)SerialLinePanel.this.hostTTYDeviceCombo, (int)SerialLinePanel.this.lastSelected));
                        }
                    } else if (SerialLinePanel.this.lastSelected != -1) {
                        SWTControlUtil.setText((Control)SerialLinePanel.this.hostTTYDeviceCombo, (String)SWTControlUtil.getItem((Control)SerialLinePanel.this.hostTTYDeviceCombo, (int)SerialLinePanel.this.lastSelected));
                    }
                }
                SerialLinePanel.this.lastSelected = SWTControlUtil.getSelectionIndex((Control)SerialLinePanel.this.hostTTYDeviceCombo);
                IValidatingContainer validatingContainer = SerialLinePanel.this.getParentControl().getValidatingContainer();
                if (validatingContainer != null) {
                    validatingContainer.validate();
                }
            }
        });
        this.hostTTYSpeedLabel = new Label(client, 0);
        this.hostTTYSpeedLabel.setText(this.terminalMode ? Messages.SerialLinePanel_hostTTYSpeed_label_terminalMode : Messages.SerialLinePanel_hostTTYSpeed_label);
        this.hostTTYSpeedCombo = new Combo(client, 2060);
        this.hostTTYSpeedCombo.setLayoutData((Object)new GridData(768));
        this.hostTTYSpeedCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SerialLinePanel.fcEditableTTYOther.equals(SWTControlUtil.getText((Control)SerialLinePanel.this.hostTTYSpeedCombo))) {
                    InputDialog dialog = new InputDialog(SerialLinePanel.this.getControl().getShell(), Messages.SerialLinePanel_customSerialBaudRate_title, Messages.SerialLinePanel_customSerialBaudRate_message, "", SerialLinePanel.this.getCustomSerialBaudRateInputValidator());
                    if (dialog.open() == 0) {
                        String device = dialog.getValue();
                        if (device != null && device.trim().length() > 0) {
                            int index = SWTControlUtil.indexOf((Control)SerialLinePanel.this.hostTTYSpeedCombo, (String)SerialLinePanel.fcEditableTTYOther);
                            if (index != -1 && index == SWTControlUtil.getItemCount((Control)SerialLinePanel.this.hostTTYSpeedCombo) - 1) {
                                SWTControlUtil.add((Control)SerialLinePanel.this.hostTTYSpeedCombo, (String)device.trim());
                            } else if (index != -1) {
                                SWTControlUtil.setItem((Control)SerialLinePanel.this.hostTTYSpeedCombo, (int)(index + 1), (String)device.trim());
                            }
                            SWTControlUtil.setText((Control)SerialLinePanel.this.hostTTYSpeedCombo, (String)device.trim());
                        } else if (SerialLinePanel.this.lastSelectedBaud != -1) {
                            SWTControlUtil.setText((Control)SerialLinePanel.this.hostTTYSpeedCombo, (String)SWTControlUtil.getItem((Control)SerialLinePanel.this.hostTTYSpeedCombo, (int)SerialLinePanel.this.lastSelectedBaud));
                        }
                    } else if (SerialLinePanel.this.lastSelectedBaud != -1) {
                        SWTControlUtil.setText((Control)SerialLinePanel.this.hostTTYSpeedCombo, (String)SWTControlUtil.getItem((Control)SerialLinePanel.this.hostTTYSpeedCombo, (int)SerialLinePanel.this.lastSelectedBaud));
                    }
                }
                SerialLinePanel.this.lastSelectedBaud = SWTControlUtil.getSelectionIndex((Control)SerialLinePanel.this.hostTTYSpeedCombo);
                IValidatingContainer validatingContainer = SerialLinePanel.this.getParentControl().getValidatingContainer();
                if (validatingContainer != null) {
                    validatingContainer.validate();
                }
            }
        });
        UIPlugin.getTraceHandler().trace("SerialLinePanel: Start quering the available comm ports.", "trace/serialLinePanel", (Object)this);
        if (this.getParentControl().getRunnableContext() instanceof WizardDialog) {
            IRunnableContext context = this.getParentControl().getRunnableContext();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.SerialLinePanel_task_queryAvailableSerialDevices, -1);
                    SerialLinePanel.this.queryAvailableSerialDevices();
                    monitor.done();
                }
            };
            try {
                context.run(true, false, runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        } else {
            BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    SerialLinePanel.this.queryAvailableSerialDevices();
                }
            });
        }
        if (this.editable) {
            SWTControlUtil.add((Control)this.hostTTYDeviceCombo, (String)fcEditableTTYOther);
        }
        if (SWTControlUtil.indexOf((Control)this.hostTTYDeviceCombo, (String)this.getDefaultHostTTYDevice()) != -1) {
            SWTControlUtil.setText((Control)this.hostTTYDeviceCombo, (String)this.getDefaultHostTTYDevice());
        } else if ("".equals(SWTControlUtil.getText((Control)this.hostTTYDeviceCombo)) && SWTControlUtil.getItemCount((Control)this.hostTTYDeviceCombo) > 0) {
            if (SWTControlUtil.getItemCount((Control)this.hostTTYDeviceCombo) == 1 && fcEditableTTYOther.equals(SWTControlUtil.getItem((Control)this.hostTTYDeviceCombo, (int)0))) {
                SWTControlUtil.add((Control)this.hostTTYDeviceCombo, (String)"", (int)0, (boolean)true);
            }
            SWTControlUtil.setText((Control)this.hostTTYDeviceCombo, (String)SWTControlUtil.getItem((Control)this.hostTTYDeviceCombo, (int)0));
        }
        if (SWTControlUtil.getItemCount((Control)this.hostTTYDeviceCombo) > 0) {
            SWTControlUtil.setEnabled((Control)this.hostTTYDeviceCombo, (boolean)true);
        } else {
            SWTControlUtil.setEnabled((Control)this.hostTTYDeviceCombo, (boolean)false);
        }
        this.lastSelected = SWTControlUtil.getSelectionIndex((Control)this.hostTTYDeviceCombo);
        String[] stringArray = fcTTYSpeedRates;
        int n = fcTTYSpeedRates.length;
        int runnable = 0;
        while (runnable < n) {
            String fcTTYSpeedRate = stringArray[runnable];
            SWTControlUtil.add((Control)this.hostTTYSpeedCombo, (String)fcTTYSpeedRate);
            ++runnable;
        }
        if (this.editable) {
            SWTControlUtil.add((Control)this.hostTTYSpeedCombo, (String)fcEditableTTYOther);
        }
        SWTControlUtil.setText((Control)this.hostTTYSpeedCombo, (String)fcDefaultTTYSpeed);
        this.lastSelectedBaud = SWTControlUtil.getSelectionIndex((Control)this.hostTTYSpeedCombo);
        if (this.showAdvancedSerialOptions) {
            Composite panel2;
            Composite bitsPanel;
            Composite composite = bitsPanel = this.terminalMode ? client : new Composite(client, 0);
            if (!this.terminalMode) {
                layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                layout.numColumns = 3;
                bitsPanel.setLayout((Layout)layout);
                GridData layoutData = new GridData(768);
                layoutData.horizontalSpan = 4;
                bitsPanel.setLayoutData((Object)layoutData);
            }
            Composite composite2 = panel2 = this.terminalMode ? client : new Composite(bitsPanel, 0);
            if (!this.terminalMode) {
                layout = new GridLayout(2, false);
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                panel.setLayout((Layout)layout);
                panel.setLayoutData((Object)new GridData(768));
            }
            this.hostTTYBitsLabel = new Label(panel2, 0);
            this.hostTTYBitsLabel.setText(Messages.SerialLinePanel_hostTTYDatabits_label);
            this.hostTTYBitsCombo = new Combo(panel2, 2060);
            this.hostTTYBitsCombo.setLayoutData((Object)new GridData(768));
            this.hostTTYBitsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IValidatingContainer validatingContainer = SerialLinePanel.this.getParentControl().getValidatingContainer();
                    if (validatingContainer != null) {
                        validatingContainer.validate();
                    }
                }
            });
            String[] stringArray2 = fcTTYDatabits;
            int n2 = fcTTYDatabits.length;
            int n3 = 0;
            while (n3 < n2) {
                String fcTTYDatabit = stringArray2[n3];
                SWTControlUtil.add((Control)this.hostTTYBitsCombo, (String)fcTTYDatabit);
                ++n3;
            }
            SWTControlUtil.setText((Control)this.hostTTYBitsCombo, (String)fcDefaultTTYDatabits);
            this.hostTTYParityLabel = new Label(panel2, 0);
            this.hostTTYParityLabel.setText(Messages.SerialLinePanel_hostTTYParity_label);
            this.hostTTYParityCombo = new Combo(panel2, 2060);
            this.hostTTYParityCombo.setLayoutData((Object)new GridData(768));
            this.hostTTYParityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IValidatingContainer validatingContainer = SerialLinePanel.this.getParentControl().getValidatingContainer();
                    if (validatingContainer != null) {
                        validatingContainer.validate();
                    }
                }
            });
            stringArray2 = fcTTYParity;
            n2 = fcTTYParity.length;
            n3 = 0;
            while (n3 < n2) {
                String element = stringArray2[n3];
                SWTControlUtil.add((Control)this.hostTTYParityCombo, (String)element);
                ++n3;
            }
            SWTControlUtil.setText((Control)this.hostTTYParityCombo, (String)"None");
            this.hostTTYStopbitsLabel = new Label(panel2, 0);
            this.hostTTYStopbitsLabel.setText(Messages.SerialLinePanel_hostTTYStopbits_label);
            this.hostTTYStopbitsCombo = new Combo(panel2, 2060);
            this.hostTTYStopbitsCombo.setLayoutData((Object)new GridData(768));
            this.hostTTYStopbitsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IValidatingContainer validatingContainer = SerialLinePanel.this.getParentControl().getValidatingContainer();
                    if (validatingContainer != null) {
                        validatingContainer.validate();
                    }
                }
            });
            stringArray2 = fcTTYStopbits;
            n2 = fcTTYStopbits.length;
            n3 = 0;
            while (n3 < n2) {
                String fcTTYStopbit = stringArray2[n3];
                SWTControlUtil.add((Control)this.hostTTYStopbitsCombo, (String)fcTTYStopbit);
                ++n3;
            }
            SWTControlUtil.setText((Control)this.hostTTYStopbitsCombo, (String)fcDefaultTTYStopbits);
            this.hostTTYFlowControlLabel = new Label(panel2, 0);
            this.hostTTYFlowControlLabel.setText(Messages.SerialLinePanel_hostTTYFlowControl_label);
            this.hostTTYFlowControlCombo = new Combo(panel2, 2060);
            this.hostTTYFlowControlCombo.setLayoutData((Object)new GridData(768));
            this.hostTTYFlowControlCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IValidatingContainer validatingContainer = SerialLinePanel.this.getParentControl().getValidatingContainer();
                    if (validatingContainer != null) {
                        validatingContainer.validate();
                    }
                }
            });
            stringArray2 = fcTTYFlowControl;
            n2 = fcTTYFlowControl.length;
            n3 = 0;
            while (n3 < n2) {
                String element = stringArray2[n3];
                SWTControlUtil.add((Control)this.hostTTYFlowControlCombo, (String)element);
                ++n3;
            }
            SWTControlUtil.setText((Control)this.hostTTYFlowControlCombo, (String)"None");
            if (this.terminalMode) {
                this.hostTTYTimeoutLabel = new Label(panel2, 0);
                this.hostTTYTimeoutLabel.setText(Messages.SerialLinePanel_hostTTYTimeout_label);
                this.hostTTYTimeoutText = new Text(panel2, 2052);
                this.hostTTYTimeoutText.setLayoutData((Object)new GridData(768));
                this.hostTTYTimeoutText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        IValidatingContainer validatingContainer = SerialLinePanel.this.getParentControl().getValidatingContainer();
                        if (validatingContainer != null) {
                            validatingContainer.validate();
                        }
                    }
                });
                SWTControlUtil.setText((Control)this.hostTTYTimeoutText, (String)fcDefaultTTYTimeout);
            }
        }
    }

    protected void queryAvailableSerialDevices() {
        String prop = System.getProperty("gnu.io.rxtx.NoVersionOutput");
        if (prop == null && !Platform.inDebugMode()) {
            System.setProperty("gnu.io.rxtx.NoVersionOutput", "true");
        }
        try {
            Enumeration ttyPortIds = CommPortIdentifier.getPortIdentifiers();
            if (!ttyPortIds.hasMoreElements()) {
                UIPlugin.getTraceHandler().trace("SerialLinePanel: NO comm ports available at all!", "trace/serialLinePanel", (Object)this);
            }
            final ArrayList<String> ports = new ArrayList<String>();
            while (ttyPortIds.hasMoreElements()) {
                CommPortIdentifier port = (CommPortIdentifier)ttyPortIds.nextElement();
                String type = "unknown";
                if (port.getPortType() == 2) {
                    type = "parallel";
                }
                if (port.getPortType() == 1) {
                    type = "serial";
                }
                UIPlugin.getTraceHandler().trace("SerialLinePanel: Found comm port: name='" + port.getName() + "', type='" + type, "trace/serialLinePanel", (Object)this);
                if (port.getPortType() != 1) continue;
                UIPlugin.getTraceHandler().trace("SerialLinePanel: Adding found serial comm port to combo!", "trace/serialLinePanel", (Object)this);
                if (ports.contains(port.getName())) continue;
                ports.add(port.getName());
            }
            if (!ports.isEmpty()) {
                Collections.sort(ports);
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (String port : ports) {
                            SWTControlUtil.add((Control)SerialLinePanel.this.hostTTYDeviceCombo, (String)port);
                        }
                    }
                });
            }
        }
        catch (UnsatisfiedLinkError e) {
            Status status = new Status(2, UIPlugin.getUniqueIdentifier(), Messages.SerialLinePanel_warning_FailedToLoadSerialPorts, (Throwable)e);
            UIPlugin.getDefault().getLog().log((IStatus)status);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
    }

    @Override
    public void setEnabled(boolean enabled) {
        SWTControlUtil.setEnabled((Control)this.hostTTYDeviceLabel, (boolean)enabled);
        SWTControlUtil.setEnabled((Control)this.hostTTYDeviceCombo, (boolean)enabled);
        SWTControlUtil.setEnabled((Control)this.hostTTYSpeedLabel, (boolean)enabled);
        SWTControlUtil.setEnabled((Control)this.hostTTYSpeedCombo, (boolean)enabled);
        SWTControlUtil.setEnabled((Control)this.hostTTYBitsLabel, (boolean)enabled);
        SWTControlUtil.setEnabled((Control)this.hostTTYBitsCombo, (boolean)enabled);
        SWTControlUtil.setEnabled((Control)this.hostTTYParityLabel, (boolean)enabled);
        SWTControlUtil.setEnabled((Control)this.hostTTYParityCombo, (boolean)enabled);
        SWTControlUtil.setEnabled((Control)this.hostTTYStopbitsLabel, (boolean)enabled);
        SWTControlUtil.setEnabled((Control)this.hostTTYStopbitsCombo, (boolean)enabled);
        SWTControlUtil.setEnabled((Control)this.hostTTYFlowControlLabel, (boolean)enabled);
        SWTControlUtil.setEnabled((Control)this.hostTTYFlowControlCombo, (boolean)enabled);
    }

    public String getDefaultHostTTYDevice() {
        String osName = System.getProperty("os.name");
        if (osName.equalsIgnoreCase("Linux")) {
            return fcDefaultTTYDeviceLinux;
        }
        if (osName.equalsIgnoreCase("SunOS")) {
            return fcDefaultTTYDeviceSolaris;
        }
        if (osName.toLowerCase().startsWith("windows")) {
            return fcDefaultTTYDeviceWin32;
        }
        return "";
    }

    public String getDefaultHostTTYSpeed() {
        return fcDefaultTTYSpeed;
    }

    public String getDefaultHostTTYDatabits() {
        return fcDefaultTTYDatabits;
    }

    public String getDefaultHostTTYParity() {
        return "None";
    }

    public String getDefaultHostTTYStopbits() {
        return fcDefaultTTYStopbits;
    }

    public String getDefaultHostTTYFlowControl() {
        return "None";
    }

    public String getDefaultHostTTYTimeout() {
        return fcDefaultTTYTimeout;
    }

    protected void doSetTextInCombo(Combo combo, String value) {
        Assert.isNotNull((Object)combo);
        Assert.isNotNull((Object)value);
        if (SWTControlUtil.indexOf((Control)combo, (String)value) != 1) {
            SWTControlUtil.setText((Control)combo, (String)value);
        }
    }

    public void setSelectedTTYDevice(String value) {
        this.doSetTextInCombo(this.hostTTYDeviceCombo, value);
    }

    public void setSelectedTTYDevice(int index) {
        if (index >= 0 && index < SWTControlUtil.getItemCount((Control)this.hostTTYDeviceCombo)) {
            SWTControlUtil.setText((Control)this.hostTTYDeviceCombo, (String)SWTControlUtil.getItem((Control)this.hostTTYDeviceCombo, (int)index));
        }
    }

    public void setSelectedTTYSpeed(String value) {
        this.doSetTextInCombo(this.hostTTYSpeedCombo, value);
    }

    public void setSelectedTTYDatabits(String value) {
        this.doSetTextInCombo(this.hostTTYBitsCombo, value);
    }

    public void setSelectedTTYParity(String value) {
        this.doSetTextInCombo(this.hostTTYParityCombo, value);
    }

    public void setSelectedTTYStopbits(String value) {
        this.doSetTextInCombo(this.hostTTYStopbitsCombo, value);
    }

    public void setSelectedTTYFlowControl(String value) {
        this.doSetTextInCombo(this.hostTTYFlowControlCombo, value);
    }

    @Override
    public boolean isValid() {
        String selectedTTYDevice = SWTControlUtil.getText((Control)this.hostTTYDeviceCombo);
        if (selectedTTYDevice == null || selectedTTYDevice.trim().length() == 0) {
            this.setMessage(Messages.SerialLinePanel_error_emptyHostTTYDevice, 3);
            return false;
        }
        if (fcEditableTTYOther.equals(selectedTTYDevice)) {
            this.setMessage(Messages.SerialLinePanel_info_editableTTYDeviceSelected, 1);
            return false;
        }
        String selectedTTYSpeedRate = SWTControlUtil.getText((Control)this.hostTTYSpeedCombo);
        if (selectedTTYSpeedRate == null || selectedTTYSpeedRate.trim().length() == 0) {
            this.setMessage(Messages.SerialLinePanel_error_emptyHostTTYSpeedRate, 3);
            return false;
        }
        if (fcEditableTTYOther.equals(selectedTTYSpeedRate)) {
            this.setMessage(Messages.SerialLinePanel_info_editableTTYBaudRateSelected, 1);
            return false;
        }
        if (this.showAdvancedSerialOptions) {
            String option = SWTControlUtil.getText((Control)this.hostTTYBitsCombo);
            if (option == null || option.trim().length() == 0) {
                this.setMessage(Messages.SerialLinePanel_error_emptyHostTTYDatabits, 3);
                return false;
            }
            option = SWTControlUtil.getText((Control)this.hostTTYParityCombo);
            if (option == null || option.trim().length() == 0) {
                this.setMessage(Messages.SerialLinePanel_error_emptyHostTTYParity, 3);
                return false;
            }
            option = SWTControlUtil.getText((Control)this.hostTTYStopbitsCombo);
            if (option == null || option.trim().length() == 0) {
                this.setMessage(Messages.SerialLinePanel_error_emptyHostTTYStopbits, 3);
                return false;
            }
            option = SWTControlUtil.getText((Control)this.hostTTYFlowControlCombo);
            if (option == null || option.trim().length() == 0) {
                this.setMessage(Messages.SerialLinePanel_error_emptyHostTTYFlowControl, 3);
                return false;
            }
            if (this.terminalMode && ((option = SWTControlUtil.getText((Control)this.hostTTYTimeoutText)) == null || option.trim().length() == 0)) {
                this.setMessage(Messages.SerialLinePanel_error_emptyHostTTYFlowControl, 3);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean dataChanged(IPropertiesContainer data, TypedEvent e) {
        Assert.isNotNull((Object)data);
        boolean isDirty = false;
        if (!this.terminalMode) {
            String value;
            HashMap container = (HashMap)data.getProperty("serial");
            if (container == null) {
                container = new HashMap();
            }
            if ((value = SWTControlUtil.getText((Control)this.hostTTYDeviceCombo)) != null) {
                isDirty |= !value.equals(container.get("device") != null ? container.get("device") : "");
            }
            if ((value = SWTControlUtil.getText((Control)this.hostTTYSpeedCombo)) != null) {
                isDirty |= !value.equals(container.get("baudrate") != null ? container.get("baudrate") : "");
            }
            if (this.showAdvancedSerialOptions) {
                value = SWTControlUtil.getText((Control)this.hostTTYBitsCombo);
                if (value != null) {
                    isDirty |= !value.equals(container.get("databits") != null ? container.get("databits") : "");
                }
                if ((value = SWTControlUtil.getText((Control)this.hostTTYParityCombo)) != null) {
                    isDirty |= !value.equals(container.get("parity") != null ? container.get("parity") : "");
                }
                if ((value = SWTControlUtil.getText((Control)this.hostTTYStopbitsCombo)) != null) {
                    isDirty |= !value.equals(container.get("stopbits") != null ? container.get("stopbits") : "");
                }
                if ((value = SWTControlUtil.getText((Control)this.hostTTYFlowControlCombo)) != null) {
                    isDirty |= !value.equals(container.get("flowcontrol") != null ? container.get("flowcontrol") : "");
                }
            }
        } else {
            String value = SWTControlUtil.getText((Control)this.hostTTYDeviceCombo);
            if (value != null) {
                isDirty |= !value.equals(data.getStringProperty("serial.device") != null ? data.getStringProperty("serial.device") : "");
            }
            if ((value = SWTControlUtil.getText((Control)this.hostTTYSpeedCombo)) != null) {
                isDirty |= !value.equals(data.getStringProperty("serial.baudrate") != null ? data.getStringProperty("serial.baudrate") : "");
            }
            if (this.showAdvancedSerialOptions) {
                value = SWTControlUtil.getText((Control)this.hostTTYBitsCombo);
                if (value != null) {
                    isDirty |= !value.equals(data.getStringProperty("serial.databits") != null ? data.getStringProperty("serial.databits") : "");
                }
                if ((value = SWTControlUtil.getText((Control)this.hostTTYParityCombo)) != null) {
                    isDirty |= !value.equals(data.getStringProperty("serial.parity") != null ? data.getStringProperty("serial.parity") : "");
                }
                if ((value = SWTControlUtil.getText((Control)this.hostTTYStopbitsCombo)) != null) {
                    isDirty |= !value.equals(data.getStringProperty("serial.stopbits") != null ? data.getStringProperty("serial.stopbits") : "");
                }
                if ((value = SWTControlUtil.getText((Control)this.hostTTYFlowControlCombo)) != null) {
                    isDirty |= !value.equals(data.getStringProperty("serial.flowcontrol") != null ? data.getStringProperty("serial.flowcontrol") : "");
                }
                if ((value = SWTControlUtil.getText((Control)this.hostTTYTimeoutText)) != null) {
                    isDirty |= !value.equals(data.getStringProperty("timeout") != null ? data.getStringProperty("timeout") : "");
                }
            }
        }
        return isDirty;
    }

    @Override
    public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
        String selectedTTYSpeedRate;
        Assert.isNotNull((Object)settings);
        String selectedTTYDevice = settings.get(this.getParentControl().prefixDialogSettingsSlotId(this.fcSelectedTTYDeviceSlotId, idPrefix));
        if (selectedTTYDevice != null && selectedTTYDevice.trim().length() > 0 && SWTControlUtil.indexOf((Control)this.hostTTYDeviceCombo, (String)selectedTTYDevice) != -1) {
            SWTControlUtil.setText((Control)this.hostTTYDeviceCombo, (String)selectedTTYDevice);
        }
        if ((selectedTTYSpeedRate = settings.get(this.getParentControl().prefixDialogSettingsSlotId(this.fcSelectedTTYSpeedRateSlotId, idPrefix))) != null && selectedTTYSpeedRate.trim().length() > 0 && SWTControlUtil.indexOf((Control)this.hostTTYSpeedCombo, (String)selectedTTYSpeedRate) != -1) {
            SWTControlUtil.setText((Control)this.hostTTYSpeedCombo, (String)selectedTTYSpeedRate);
        }
        if (this.showAdvancedSerialOptions) {
            String option = settings.get(this.getParentControl().prefixDialogSettingsSlotId(this.fcSelectedTTYDatabitsSlotId, idPrefix));
            if (option != null && option.trim().length() > 0 && SWTControlUtil.indexOf((Control)this.hostTTYBitsCombo, (String)option) != -1) {
                SWTControlUtil.setText((Control)this.hostTTYBitsCombo, (String)option);
            }
            if ((option = settings.get(this.getParentControl().prefixDialogSettingsSlotId(this.fcSelectedTTYParitySlotId, idPrefix))) != null && option.trim().length() > 0 && SWTControlUtil.indexOf((Control)this.hostTTYParityCombo, (String)option) != -1) {
                SWTControlUtil.setText((Control)this.hostTTYParityCombo, (String)option);
            }
            if ((option = settings.get(this.getParentControl().prefixDialogSettingsSlotId(this.fcSelectedTTYStopbitsSlotId, idPrefix))) != null && option.trim().length() > 0 && SWTControlUtil.indexOf((Control)this.hostTTYStopbitsCombo, (String)option) != -1) {
                SWTControlUtil.setText((Control)this.hostTTYStopbitsCombo, (String)option);
            }
            if ((option = settings.get(this.getParentControl().prefixDialogSettingsSlotId(this.fcSelectedTTYFlowControlSlotId, idPrefix))) != null && option.trim().length() > 0 && SWTControlUtil.indexOf((Control)this.hostTTYFlowControlCombo, (String)option) != -1) {
                SWTControlUtil.setText((Control)this.hostTTYFlowControlCombo, (String)option);
            }
            if (this.terminalMode && (option = settings.get(this.getParentControl().prefixDialogSettingsSlotId(this.fcSelectedTTYTimeoutSlotId, idPrefix))) != null && option.trim().length() > 0 && SWTControlUtil.indexOf((Control)this.hostTTYTimeoutText, (String)option) != -1) {
                SWTControlUtil.setText((Control)this.hostTTYTimeoutText, (String)option);
            }
        }
    }

    @Override
    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        Assert.isNotNull((Object)settings);
        settings.put(this.getParentControl().prefixDialogSettingsSlotId(this.fcSelectedTTYDeviceSlotId, idPrefix), SWTControlUtil.getText((Control)this.hostTTYDeviceCombo));
        settings.put(this.getParentControl().prefixDialogSettingsSlotId(this.fcSelectedTTYSpeedRateSlotId, idPrefix), SWTControlUtil.getText((Control)this.hostTTYSpeedCombo));
        if (this.showAdvancedSerialOptions) {
            settings.put(this.getParentControl().prefixDialogSettingsSlotId(this.fcSelectedTTYDatabitsSlotId, idPrefix), SWTControlUtil.getText((Control)this.hostTTYBitsCombo));
            settings.put(this.getParentControl().prefixDialogSettingsSlotId(this.fcSelectedTTYParitySlotId, idPrefix), SWTControlUtil.getText((Control)this.hostTTYParityCombo));
            settings.put(this.getParentControl().prefixDialogSettingsSlotId(this.fcSelectedTTYStopbitsSlotId, idPrefix), SWTControlUtil.getText((Control)this.hostTTYStopbitsCombo));
            settings.put(this.getParentControl().prefixDialogSettingsSlotId(this.fcSelectedTTYFlowControlSlotId, idPrefix), SWTControlUtil.getText((Control)this.hostTTYFlowControlCombo));
            if (this.terminalMode) {
                settings.put(this.getParentControl().prefixDialogSettingsSlotId(this.fcSelectedTTYTimeoutSlotId, idPrefix), SWTControlUtil.getText((Control)this.hostTTYTimeoutText));
            }
        }
    }

    public void setupData(IPropertiesContainer data) {
        if (data == null) {
            return;
        }
        if (!this.terminalMode) {
            HashMap container = (HashMap)data.getProperty("serial");
            if (container == null) {
                container = new HashMap();
            }
            SWTControlUtil.setText((Control)this.hostTTYDeviceCombo, (String)((String)container.get("device")));
            SWTControlUtil.setText((Control)this.hostTTYSpeedCombo, (String)((String)container.get("baudrate")));
            if (this.showAdvancedSerialOptions) {
                SWTControlUtil.setText((Control)this.hostTTYBitsCombo, (String)((String)container.get("databits")));
                SWTControlUtil.setText((Control)this.hostTTYParityCombo, (String)((String)container.get("parity")));
                SWTControlUtil.setText((Control)this.hostTTYStopbitsCombo, (String)((String)container.get("stopbits")));
                SWTControlUtil.setText((Control)this.hostTTYFlowControlCombo, (String)((String)container.get("flowcontrol")));
            }
        } else {
            SWTControlUtil.setText((Control)this.hostTTYDeviceCombo, (String)data.getStringProperty("serial.device"));
            SWTControlUtil.setText((Control)this.hostTTYSpeedCombo, (String)data.getStringProperty("serial.baudrate"));
            if (this.showAdvancedSerialOptions) {
                SWTControlUtil.setText((Control)this.hostTTYBitsCombo, (String)data.getStringProperty("serial.databits"));
                SWTControlUtil.setText((Control)this.hostTTYParityCombo, (String)data.getStringProperty("serial.parity"));
                SWTControlUtil.setText((Control)this.hostTTYStopbitsCombo, (String)data.getStringProperty("serial.stopbits"));
                SWTControlUtil.setText((Control)this.hostTTYFlowControlCombo, (String)data.getStringProperty("serial.flowcontrol"));
                SWTControlUtil.setText((Control)this.hostTTYTimeoutText, (String)data.getStringProperty("timeout"));
            }
        }
    }

    public void extractData(IPropertiesContainer data) {
        if (data == null) {
            return;
        }
        if (!this.terminalMode) {
            HashMap<String, String> container = (HashMap<String, String>)data.getProperty("serial");
            if (container == null) {
                container = new HashMap<String, String>();
            }
            container.put("device", SWTControlUtil.getText((Control)this.hostTTYDeviceCombo));
            container.put("baudrate", SWTControlUtil.getText((Control)this.hostTTYSpeedCombo));
            container.put("databits", this.showAdvancedSerialOptions ? SWTControlUtil.getText((Control)this.hostTTYBitsCombo) : null);
            container.put("parity", this.showAdvancedSerialOptions ? SWTControlUtil.getText((Control)this.hostTTYParityCombo) : null);
            container.put("stopbits", this.showAdvancedSerialOptions ? SWTControlUtil.getText((Control)this.hostTTYStopbitsCombo) : null);
            container.put("flowcontrol", this.showAdvancedSerialOptions ? SWTControlUtil.getText((Control)this.hostTTYFlowControlCombo) : null);
            data.setProperty("serial", !container.isEmpty() ? container : null);
        } else {
            data.setProperty("serial.device", (Object)SWTControlUtil.getText((Control)this.hostTTYDeviceCombo));
            data.setProperty("serial.baudrate", (Object)SWTControlUtil.getText((Control)this.hostTTYSpeedCombo));
            data.setProperty("serial.databits", this.showAdvancedSerialOptions ? SWTControlUtil.getText((Control)this.hostTTYBitsCombo) : null);
            data.setProperty("serial.parity", this.showAdvancedSerialOptions ? SWTControlUtil.getText((Control)this.hostTTYParityCombo) : null);
            data.setProperty("serial.stopbits", this.showAdvancedSerialOptions ? SWTControlUtil.getText((Control)this.hostTTYStopbitsCombo) : null);
            data.setProperty("serial.flowcontrol", this.showAdvancedSerialOptions ? SWTControlUtil.getText((Control)this.hostTTYFlowControlCombo) : null);
            data.setProperty("timeout", this.showAdvancedSerialOptions ? SWTControlUtil.getText((Control)this.hostTTYTimeoutText) : null);
        }
    }

    public void initializeData(IPropertiesContainer data) {
    }

    public void removeData(IPropertiesContainer data) {
        if (data == null) {
            return;
        }
        data.setProperty("serial", null);
    }

    public void copyData(IPropertiesContainer src, IPropertiesContainer dst) {
        Assert.isNotNull((Object)src);
        Assert.isNotNull((Object)dst);
        Map srcContainer = (Map)src.getProperty("serial");
        HashMap dstContainer = null;
        if (srcContainer != null) {
            dstContainer = new HashMap(srcContainer);
        }
        dst.setProperty("serial", dstContainer);
    }

    protected class CustomSerialBaudRateInputValidator
    implements IInputValidator {
        private final Validator validator = new NumberValidator();

        public CustomSerialBaudRateInputValidator() {
            this.validator.setMessageText("RegexValidator_Error_InvalidValue", Messages.SerialLinePanel_error_invalidCharactesBaudRate);
        }

        public String isValid(String newText) {
            if (newText != null && newText.trim().length() > 0) {
                if (!this.validator.isValid(newText)) {
                    return this.validator.getMessage();
                }
            } else if (newText != null) {
                return "";
            }
            return null;
        }
    }
}

