/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.rse.files;

import java.util.Vector;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterContainer;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultSet;
import org.eclipse.rse.services.search.ISearchService;
import org.eclipse.rse.subsystems.files.core.ILanguageUtilityFactory;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.subsystems.IHostFileToRemoteFileAdapter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.tcf.internal.rse.ITCFService;
import org.eclipse.tcf.internal.rse.Messages;
import org.eclipse.tcf.internal.rse.TCFConnectorService;
import org.eclipse.tcf.internal.rse.TCFConnectorServiceManager;
import org.eclipse.tcf.internal.rse.files.TCFFileAdapter;
import org.eclipse.tcf.internal.rse.files.TCFFileService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFFileSubSystemConfiguration
extends FileServiceSubSystemConfiguration {
    private final TCFFileAdapter file_adapter = new TCFFileAdapter();

    public TCFFileSubSystemConfiguration() {
        if (Messages.IS_UNIX_STYLE.equalsIgnoreCase("true")) {
            this.setIsUnixStyle(true);
        } else {
            this.setIsUnixStyle(false);
        }
    }

    public ISubSystem createSubSystemInternal(IHost host) {
        TCFConnectorService connectorService = (TCFConnectorService)this.getConnectorService(host);
        return new FileServiceSubSystem(host, (IConnectorService)connectorService, this.getFileService(host), this.getHostFileAdapter(), this.createSearchService(host));
    }

    public IFileService createFileService(IHost host) {
        return new TCFFileService(host);
    }

    public IHostSearchResultConfiguration createSearchConfiguration(IHost host, IHostSearchResultSet resultSet, Object searchTarget, SystemSearchString searchString) {
        return null;
    }

    public ISearchService createSearchService(IHost host) {
        return null;
    }

    public IHostFileToRemoteFileAdapter getHostFileAdapter() {
        return this.file_adapter;
    }

    public ILanguageUtilityFactory getLanguageUtilityFactory(IRemoteFileSubSystem ss) {
        return null;
    }

    public boolean supportsArchiveManagement() {
        return false;
    }

    public IConnectorService getConnectorService(IHost host) {
        return TCFConnectorServiceManager.getInstance().getConnectorService(host, this.getServiceImplType());
    }

    public Class<ITCFService> getServiceImplType() {
        return ITCFService.class;
    }

    public void setConnectorService(IHost host, IConnectorService connectorService) {
        TCFConnectorServiceManager.getInstance().setConnectorService(host, this.getServiceImplType(), connectorService);
    }

    protected ISystemFilterPool createDefaultFilterPool(ISystemFilterPoolManager mgr) {
        ISystemFilterPool pool = null;
        try {
            pool = mgr.createSystemFilterPool(TCFFileSubSystemConfiguration.getDefaultFilterPoolName((String)mgr.getName(), (String)this.getId()), true);
            Vector<String> filterStrings = new Vector<String>();
            RemoteFileFilterString myHomeFilterString = new RemoteFileFilterString((IRemoteFileSubSystemConfiguration)this);
            myHomeFilterString.setPath(".");
            myHomeFilterString.setFile("*");
            filterStrings.add(myHomeFilterString.toString());
            ISystemFilter filter = mgr.createSystemFilter((ISystemFilterContainer)pool, "Home", filterStrings);
            filter.setNonChangable(true);
            filter.setSingleFilterStringOnly(true);
            filterStrings = new Vector();
            RemoteFileFilterString rootFilesFilterString = new RemoteFileFilterString((IRemoteFileSubSystemConfiguration)this);
            rootFilesFilterString.setPath("");
            rootFilesFilterString.setFile("*");
            filterStrings.add(rootFilesFilterString.toString());
            filter = mgr.createSystemFilter((ISystemFilterContainer)pool, "Root", filterStrings);
            filter.setNonChangable(true);
            filter.setSingleFilterStringOnly(true);
        }
        catch (Exception exc) {
            SystemBasePlugin.logError((String)"Error creating default filter pool", (Throwable)exc);
        }
        return pool;
    }
}

