/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.model;

import java.beans.PropertyChangeEvent;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.core.interfaces.IViewerInput;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.filesystem.core.model.ITreeNodeModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.processes.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.processes.core.callbacks.RefreshChildrenDoneOpenChannel;
import org.eclipse.tcf.te.tcf.processes.core.model.ProcessTreeNode;
import org.eclipse.tcf.te.tcf.processes.core.nls.Messages;

public class ProcessModel
implements ITreeNodeModel {
    static final String PROCESS_ROOT_KEY = String.valueOf(CoreBundleActivator.getUniqueIdentifier()) + ".process.root";
    ProcessTreeNode root;
    int interval;
    Timer pollingTimer;
    boolean stopped;
    IPeerModel peerModel;
    ICallback refreshCallback;

    public static ProcessModel getProcessModel(final IPeerModel peerModel) {
        if (peerModel != null) {
            if (Protocol.isDispatchThread()) {
                ProcessModel model = (ProcessModel)peerModel.getProperty(PROCESS_ROOT_KEY);
                if (model == null) {
                    model = new ProcessModel(peerModel);
                    peerModel.setProperty(PROCESS_ROOT_KEY, (Object)model);
                }
                return model;
            }
            final AtomicReference reference = new AtomicReference();
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    reference.set(ProcessModel.getProcessModel(peerModel));
                }
            });
            return (ProcessModel)reference.get();
        }
        return null;
    }

    static ProcessTreeNode createRootNode(IPeerModel peerModel) {
        ProcessTreeNode node = new ProcessTreeNode();
        node.type = "ProcRootNode";
        node.peerNode = peerModel;
        node.name = Messages.ProcessLabelProvider_RootNodeLabel;
        return node;
    }

    ProcessModel(IPeerModel peerModel) {
        this.peerModel = peerModel;
        this.stopped = true;
        this.refreshCallback = new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                if (!ProcessModel.this.stopped) {
                    ProcessModel.this.scheduleRefreshing();
                } else {
                    ProcessModel.this.pollingTimer.cancel();
                    ProcessModel.this.pollingTimer = null;
                }
            }
        };
    }

    public ProcessTreeNode getRoot() {
        if (this.root == null) {
            this.root = this.createRoot();
        }
        return this.root;
    }

    ProcessTreeNode createRoot() {
        return ProcessModel.createRootNode(this.peerModel);
    }

    void startPolling() {
        this.setStopped(false);
        this.pollingTimer = new Timer();
        this.scheduleRefreshing();
    }

    void setStopped(boolean stopped) {
        if (this.stopped != stopped) {
            boolean old = this.stopped;
            this.stopped = stopped;
            Boolean oldValue = old;
            Boolean newValue = stopped;
            PropertyChangeEvent event = new PropertyChangeEvent(this.peerModel, "stopped", oldValue, newValue);
            IViewerInput viewerInput = (IViewerInput)this.peerModel.getAdapter(IViewerInput.class);
            viewerInput.firePropertyChange(event);
        }
    }

    void stopPolling() {
        this.setStopped(true);
    }

    void scheduleRefreshing() {
        TimerTask pollingTask = new TimerTask(){

            @Override
            public void run() {
                if (ProcessModel.this.root.childrenQueried && !ProcessModel.this.root.childrenQueryRunning) {
                    ProcessModel.this.root.refresh(ProcessModel.this.refreshCallback);
                } else {
                    ProcessModel.this.refreshCallback.done((Object)this, Status.OK_STATUS);
                }
            }
        };
        this.pollingTimer.schedule(pollingTask, (long)this.interval * 1000L);
    }

    public void setInterval(int interval) {
        Assert.isTrue((interval >= 0 ? 1 : 0) != 0);
        if (this.interval != interval) {
            if (this.interval == 0) {
                this.interval = interval;
                this.startPolling();
            } else {
                this.interval = interval;
                if (interval == 0) {
                    this.stopPolling();
                }
            }
        }
    }

    public int getInterval() {
        return this.interval;
    }

    public boolean isRefreshStopped() {
        return this.stopped;
    }

    public void refreshChildren(ProcessTreeNode node) {
        Tcf.getChannelManager().openChannel(node.peerNode.getPeer(), null, (IChannelManager.DoneOpenChannel)new RefreshChildrenDoneOpenChannel(node));
    }
}

