/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.model;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.filesystem.core.model.AbstractTreeNode;
import org.eclipse.tcf.te.tcf.processes.core.callbacks.QueryDoneOpenChannel;
import org.eclipse.tcf.te.tcf.processes.core.callbacks.RefreshDoneOpenChannel;

public final class ProcessTreeNode
extends AbstractTreeNode {
    public ISysMonitor.SysMonitorContext context;
    public IProcesses.ProcessContext pContext;
    public String id = null;
    public String parentId = null;
    public long pid = 0L;
    public long ppid = 0L;
    public String state = null;
    public String username = null;

    public ProcessTreeNode() {
    }

    public ProcessTreeNode(ProcessTreeNode parentNode, ISysMonitor.SysMonitorContext aContext) {
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        Assert.isNotNull((Object)aContext);
        this.context = aContext;
        this.pContext = null;
        this.name = aContext.getFile();
        this.type = "ProcNode";
        this.id = aContext.getID();
        this.pid = aContext.getPID();
        this.ppid = aContext.getPPID();
        this.parentId = aContext.getParentID();
        this.state = aContext.getState();
        this.username = aContext.getUserName();
        this.parent = parentNode;
        this.peerNode = parentNode.peerNode;
    }

    public ProcessTreeNode(ProcessTreeNode parentNode, IProcesses.ProcessContext aContext) {
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        Assert.isNotNull((Object)aContext);
        this.context = null;
        this.pContext = aContext;
        this.name = aContext.getName();
        this.type = "ProcNode";
        this.id = aContext.getID();
        this.pid = this.id != null ? this.parsePID(this.id) : -1L;
        this.parentId = aContext.getParentID();
        this.ppid = this.parentId != null ? this.parsePID(this.parentId) : -1L;
        this.parent = parentNode;
        this.peerNode = parentNode.peerNode;
    }

    private long parsePID(String string) {
        if (string.startsWith("P")) {
            string = string.substring(1);
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProcessTreeNode> getChildren() {
        ArrayList<ProcessTreeNode> result = new ArrayList<ProcessTreeNode>();
        List list = this.children;
        synchronized (list) {
            for (AbstractTreeNode child : this.children) {
                result.add((ProcessTreeNode)child);
            }
        }
        return result;
    }

    public boolean isSystemRoot() {
        return this.type != null && this.type.equals("ProcRootNode");
    }

    public void updateSysMonitorContext(ISysMonitor.SysMonitorContext aContext) {
        Assert.isNotNull((Object)aContext);
        ISysMonitor.SysMonitorContext oldContext = this.context;
        this.context = aContext;
        this.name = aContext.getFile();
        this.id = aContext.getID();
        this.pid = aContext.getPID();
        this.ppid = aContext.getPPID();
        this.parentId = aContext.getParentID();
        this.state = aContext.getState();
        this.username = aContext.getUserName();
        if (oldContext != aContext) {
            this.firePropertyChange(new PropertyChangeEvent((Object)this, "context", oldContext, aContext));
        }
    }

    public void updateProcessContext(IProcesses.ProcessContext aContext) {
        Assert.isNotNull((Object)aContext);
        IProcesses.ProcessContext oldContext = this.pContext;
        this.pContext = aContext;
        this.name = aContext.getName();
        this.id = aContext.getID();
        this.parentId = aContext.getParentID();
        if (oldContext != aContext) {
            this.firePropertyChange(new PropertyChangeEvent((Object)this, "pContext", oldContext, aContext));
        }
    }

    public void setProcessContext(IProcesses.ProcessContext pContext) {
        IProcesses.ProcessContext oldContext = this.pContext;
        this.pContext = pContext;
        if (oldContext != pContext) {
            this.firePropertyChange(new PropertyChangeEvent((Object)this, "pContext", oldContext, pContext));
        }
    }

    public void setSysMonitorContext(ISysMonitor.SysMonitorContext sContext) {
        ISysMonitor.SysMonitorContext oldContext = this.context;
        this.context = sContext;
        if (oldContext != sContext) {
            this.firePropertyChange(new PropertyChangeEvent((Object)this, "sContext", oldContext, this.context));
        }
    }

    protected IChannelManager.DoneOpenChannel doCreateRefreshDoneOpenChannel(ICallback callback) {
        return new RefreshDoneOpenChannel(callback, this);
    }

    protected IChannelManager.DoneOpenChannel doCreateQueryDoneOpenChannel(ICallback callback) {
        return new QueryDoneOpenChannel(this, callback);
    }

    public ProcessTreeNode getParent() {
        return (ProcessTreeNode)this.parent;
    }
}

