/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.core.bindings.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.launch.core.bindings.interfaces.ILaunchBinding;

public class LaunchBinding
implements ILaunchBinding {
    private String id;
    private final String[] modes;

    public LaunchBinding(String id, String modes) {
        Assert.isNotNull((Object)id);
        this.id = id;
        this.modes = modes != null ? modes.trim().split("( )*,( )*") : new String[0];
    }

    @Override
    public final String getId() {
        return this.id;
    }

    public final String[] getModes() {
        return this.modes;
    }

    @Override
    public boolean isValidLaunchMode(String launchMode) {
        if (launchMode == null || launchMode.length() == 0) {
            return true;
        }
        String[] stringArray = this.getModes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String candidate = stringArray[n2];
            if (launchMode.equals(candidate)) {
                return true;
            }
            ++n2;
        }
        return this.getModes().length == 0;
    }

    public String toString() {
        StringBuffer toString = new StringBuffer();
        toString.append("LaunchBinding(");
        toString.append(this.id);
        toString.append(", launchModes");
        toString.append(this.toString(this.getModes()));
        toString.append(")");
        return toString.toString();
    }

    protected String toString(String[] strings) {
        StringBuffer toString = new StringBuffer();
        toString.append('[');
        if (strings != null) {
            int i = 0;
            while (i < strings.length) {
                if (i > 0) {
                    toString.append(',');
                }
                toString.append(strings[i]);
                ++i;
            }
        }
        toString.append(']');
        return toString.toString();
    }
}

