/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.breakpointactions.BreakpointActionManager;
import org.eclipse.cdt.debug.core.breakpointactions.IBreakpointAction;
import org.eclipse.cdt.debug.core.breakpointactions.ILogActionEnabler;
import org.eclipse.cdt.debug.core.breakpointactions.IResumeActionEnabler;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.tcf.internal.cdt.ui.Activator;
import org.eclipse.tcf.internal.debug.actions.TCFAction;
import org.eclipse.tcf.internal.debug.model.TCFBreakpointsModel;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenLogExpressions;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelManager;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;

public class TCFBreakpointActions {
    private final TCFModelManager.ModelManagerListener launch_listener = new TCFModelManager.ModelManagerListener(){

        public void onConnected(TCFLaunch launch, TCFModel model) {
            if (!$assertionsDisabled && TCFBreakpointActions.this.rc_listeners.get(launch) != null) {
                throw new AssertionError();
            }
            new RunControlListener(model);
        }

        public void onDisconnected(TCFLaunch launch, TCFModel model) {
            RunControlListener l = (RunControlListener)TCFBreakpointActions.this.rc_listeners.remove(launch);
            if (l != null) {
                l.dispose();
            }
        }
    };
    private final TCFBreakpointsModel bp_model;
    private final TCFModelManager model_manager;
    private final BreakpointActionManager bp_action_manager;
    private final Map<TCFLaunch, RunControlListener> rc_listeners;

    TCFBreakpointActions() {
        assert (Protocol.isDispatchThread());
        this.bp_action_manager = CDebugCorePlugin.getDefault().getBreakpointActionManager();
        this.bp_model = TCFBreakpointsModel.getBreakpointsModel();
        this.model_manager = TCFModelManager.getModelManager();
        this.model_manager.addListener(this.launch_listener);
        this.rc_listeners = new HashMap<TCFLaunch, RunControlListener>();
        ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            TCFLaunch tcf_launch;
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof TCFLaunch && !(tcf_launch = (TCFLaunch)launch).isDisconnected() && !tcf_launch.isConnecting()) {
                this.launch_listener.onConnected(tcf_launch, this.model_manager.getModel(tcf_launch));
            }
            ++n2;
        }
    }

    void dispose() {
        assert (Protocol.isDispatchThread());
        this.model_manager.removeListener(this.launch_listener);
        for (RunControlListener l : this.rc_listeners.values()) {
            l.dispose();
        }
        this.rc_listeners.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BreakpointActionAdapter
    extends TCFAction
    implements IAdaptable,
    ILogActionEnabler,
    IResumeActionEnabler {
        private final HashMap<String, BreakpointActionAdapter> active_actions;
        private final TCFNodeExecContext node;
        private final Job job;
        private boolean started;
        private boolean resumed;

        BreakpointActionAdapter(final HashMap<String, BreakpointActionAdapter> actions, final IBreakpoint breakpoint, TCFNodeExecContext node) {
            super(node.getModel().getLaunch(), node.getID());
            this.active_actions = actions;
            this.node = node;
            this.job = new Job("Breakpoint actions"){

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status = Status.OK_STATUS;
                    try {
                        IMarker marker = breakpoint.getMarker();
                        String names = marker.getAttribute("BREAKPOINT_ACTIONS", "");
                        String[] actions2 = names.split(",");
                        int i = 0;
                        while (i < actions2.length && !monitor.isCanceled()) {
                            String name = actions2[i];
                            IBreakpointAction action = TCFBreakpointActions.this.bp_action_manager.findBreakpointAction(name);
                            if (action != null) {
                                monitor.setTaskName(action.getSummary());
                                status = action.execute(breakpoint, (IAdaptable)BreakpointActionAdapter.this, monitor);
                                if (status.getCode() != 0) break;
                            }
                            monitor.worked(1);
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        status = new Status(4, "org.eclipse.tcf.cdt.ui", 4, "Cannot execute breakpoint action", (Throwable)e);
                    }
                    if (!monitor.isCanceled() && status.getCode() != 0) {
                        Activator.log(status);
                    }
                    Protocol.invokeAndWait((Runnable)new Runnable(){

                        public void run() {
                            if (!$assertionsDisabled && BreakpointActionAdapter.this.aborted != (actions.get(BreakpointActionAdapter.this.ctx_id) != BreakpointActionAdapter.this)) {
                                throw new AssertionError();
                            }
                            if (!BreakpointActionAdapter.this.aborted) {
                                actions.remove(BreakpointActionAdapter.this.ctx_id);
                            }
                            BreakpointActionAdapter.this.done();
                        }
                    });
                    return status;
                }
            };
            BreakpointActionAdapter a = actions.get(this.ctx_id);
            if (a != null) {
                a.abort();
            }
            assert (actions.get(this.ctx_id) == null);
            actions.put(this.ctx_id, this);
        }

        public Object getAdapter(Class adapter) {
            if (adapter.isInstance((Object)this)) {
                return this;
            }
            return Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }

        public void resume() throws Exception {
            new TCFTask<Boolean>(this.node.getChannel()){

                public void run() {
                    if (BreakpointActionAdapter.this.aborted || BreakpointActionAdapter.this.resumed || BreakpointActionAdapter.this.node.isDisposed()) {
                        this.done(false);
                        return;
                    }
                    TCFDataCache state_cache = BreakpointActionAdapter.this.node.getState();
                    if (!state_cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    TCFContextState state_data = (TCFContextState)state_cache.getData();
                    if (state_data == null || !state_data.is_suspended) {
                        this.done(false);
                        return;
                    }
                    TCFDataCache ctx_cache = BreakpointActionAdapter.this.node.getRunContext();
                    if (!ctx_cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    IRunControl.RunControlContext ctx_data = (IRunControl.RunControlContext)ctx_cache.getData();
                    if (ctx_data == null) {
                        this.done(false);
                        return;
                    }
                    BreakpointActionAdapter.this.resumed = true;
                    ctx_data.resume(0, 1, new IRunControl.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            if (error != null && !BreakpointActionAdapter.this.aborted) {
                                this.error(error);
                            } else {
                                this.done(true);
                            }
                        }
                    });
                }
            }.get();
        }

        public String evaluateExpression(final String expression) throws Exception {
            return (String)new TCFTask<String>(this.node.getChannel()){

                public void run() {
                    if (BreakpointActionAdapter.this.aborted || BreakpointActionAdapter.this.node.isDisposed()) {
                        this.done("");
                        return;
                    }
                    TCFChildrenLogExpressions cache = BreakpointActionAdapter.this.node.getLogExpressionCache();
                    cache.addScript(expression);
                    if (!cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    TCFNodeExpression expr = cache.findScript(expression);
                    String s = expr.getValueText(true, (Runnable)((Object)this));
                    if (s != null) {
                        this.done(String.valueOf(expression) + " = " + s);
                    }
                }
            }.get();
        }

        public void run() {
            if (this.aborted) {
                this.done();
            } else {
                this.node.postStateChangedDelta();
                this.job.schedule();
                this.started = true;
            }
        }

        public int getPriority() {
            return 100;
        }

        public void abort() {
            assert (this.aborted == (this.active_actions.get(this.ctx_id) != this));
            if (this.aborted) {
                return;
            }
            super.abort();
            this.active_actions.remove(this.ctx_id);
            if (this.started && this.job.cancel()) {
                this.done();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RunControlListener
    implements IRunControl.RunControlListener {
        private final IRunControl rc;
        private final TCFModel model;
        private final HashMap<String, BreakpointActionAdapter> active_actions;

        RunControlListener(TCFModel model) {
            this.model = model;
            this.active_actions = new HashMap();
            this.rc = (IRunControl)model.getLaunch().getService(IRunControl.class);
            if (this.rc != null) {
                this.rc.addListener((IRunControl.RunControlListener)this);
            }
        }

        void dispose() {
            BreakpointActionAdapter[] arr;
            if (this.rc != null) {
                this.rc.removeListener((IRunControl.RunControlListener)this);
            }
            BreakpointActionAdapter[] breakpointActionAdapterArray = arr = this.active_actions.values().toArray(new BreakpointActionAdapter[this.active_actions.size()]);
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                BreakpointActionAdapter a = breakpointActionAdapterArray[n2];
                a.abort();
                ++n2;
            }
        }

        public void contextAdded(IRunControl.RunControlContext[] contexts) {
        }

        public void contextChanged(IRunControl.RunControlContext[] contexts) {
        }

        public void contextRemoved(String[] context_ids) {
            String[] stringArray = context_ids;
            int n = context_ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                BreakpointActionAdapter a = this.active_actions.get(id);
                if (a != null) {
                    a.abort();
                }
                ++n2;
            }
        }

        public void contextSuspended(String context, String pc, String reason, Map<String, Object> params) {
            if (params == null) {
                return;
            }
            Object ids = params.get("BPs");
            if (ids == null) {
                return;
            }
            TCFNodeExecContext node = (TCFNodeExecContext)this.model.getNode(context);
            if (node == null) {
                return;
            }
            Collection c = (Collection)ids;
            for (String bp_id : c) {
                IBreakpoint bp = TCFBreakpointActions.this.bp_model.getBreakpoint(bp_id);
                if (!TCFBreakpointActions.this.bp_action_manager.breakpointHasActions(bp)) continue;
                new BreakpointActionAdapter(this.active_actions, bp, node);
            }
        }

        public void contextResumed(String context) {
            BreakpointActionAdapter a = this.active_actions.get(context);
            if (a != null && !a.resumed) {
                a.abort();
            }
        }

        public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
            this.contextSuspended(context, pc, reason, params);
        }

        public void containerResumed(String[] context_ids) {
            String[] stringArray = context_ids;
            int n = context_ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.contextResumed(id);
                ++n2;
            }
        }

        public void contextException(String context, String msg) {
        }
    }
}

