/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug;

import java.util.UUID;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.internal.debug.launch.TCFLocalAgent;
import org.eclipse.tcf.internal.debug.launch.TCFUserDefPeer;
import org.eclipse.tcf.internal.debug.model.TCFBreakpointsModel;
import org.eclipse.tcf.protocol.Protocol;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.tcf.debug";
    private static Activator plugin;
    private static TCFBreakpointsModel bp_model;
    private static final String client_id;

    static {
        client_id = UUID.randomUUID().toString();
    }

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        bp_model = new TCFBreakpointsModel();
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                TCFUserDefPeer.loadPeers();
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        bp_model.dispose();
        bp_model = null;
        TCFLocalAgent.destroy();
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static TCFBreakpointsModel getBreakpointsModel() {
        return bp_model;
    }

    public static String getClientID() {
        return client_id;
    }

    public static void log(String msg, Throwable err) {
        if (plugin == null || plugin.getLog() == null) {
            System.err.println(msg);
            if (err != null) {
                err.printStackTrace();
            }
        } else {
            plugin.getLog().log((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, msg, err));
        }
    }
}

