/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.tests;

import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.eclipse.tcf.internal.debug.tests.ITCFTest;
import org.eclipse.tcf.internal.debug.tests.RunControl;
import org.eclipse.tcf.internal.debug.tests.TCFTestSuite;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IDiagnostics;
import org.eclipse.tcf.services.IRunControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestAttachTerminate
implements ITCFTest,
IRunControl.RunControlListener {
    private final TCFTestSuite test_suite;
    private final RunControl test_rc;
    private final IDiagnostics diag;
    private final IRunControl rc;
    private final Random rnd = new Random();
    private int cnt = 0;
    private int timer = 0;
    private final HashSet<String> test_ctx_ids = new HashSet();

    TestAttachTerminate(TCFTestSuite test_suite, RunControl test_rc, IChannel channel) {
        this.test_suite = test_suite;
        this.test_rc = test_rc;
        this.diag = (IDiagnostics)channel.getRemoteService(IDiagnostics.class);
        this.rc = (IRunControl)channel.getRemoteService(IRunControl.class);
    }

    @Override
    public void start() {
        if (this.diag == null || this.rc == null) {
            this.test_suite.done(this, null);
        } else {
            this.rc.addListener((IRunControl.RunControlListener)this);
            this.diag.getTestList(new IDiagnostics.DoneGetTestList(){

                public void doneGetTestList(IToken token, Throwable error, String[] list) {
                    if (!TestAttachTerminate.this.test_suite.isActive(TestAttachTerminate.this)) {
                        return;
                    }
                    if (error != null) {
                        TestAttachTerminate.this.exit(error);
                    } else if (list.length > 0) {
                        TestAttachTerminate.this.startTestContext(list[TestAttachTerminate.this.rnd.nextInt(list.length)]);
                        Protocol.invokeLater((long)100L, (Runnable)new Runnable(){

                            public void run() {
                                if (!TestAttachTerminate.this.test_suite.isActive(TestAttachTerminate.this)) {
                                    return;
                                }
                                TestAttachTerminate testAttachTerminate = TestAttachTerminate.this;
                                testAttachTerminate.timer = testAttachTerminate.timer + 1;
                                if (((TestAttachTerminate)(this).TestAttachTerminate.this).test_suite.cancel) {
                                    TestAttachTerminate.this.exit(null);
                                } else if (TestAttachTerminate.this.timer < 2400) {
                                    Protocol.invokeLater((long)100L, (Runnable)this);
                                } else if (TestAttachTerminate.this.test_ctx_ids.isEmpty()) {
                                    TestAttachTerminate.this.exit(new Error("Timeout waiting for 'contextAdded' event"));
                                } else {
                                    TestAttachTerminate.this.exit(new Error("Timeout waiting for 'contextRemoved' event. Context: " + TestAttachTerminate.this.test_ctx_ids));
                                }
                            }
                        });
                        return;
                    }
                    TestAttachTerminate.this.exit(null);
                }
            });
        }
    }

    @Override
    public boolean canResume(String id) {
        return true;
    }

    private void startTestContext(String test_name) {
        int i = 0;
        while (i < 4) {
            this.diag.runTest(test_name, new IDiagnostics.DoneRunTest(){

                public void doneRunTest(IToken token, Throwable error, String id) {
                    TestAttachTerminate testAttachTerminate = TestAttachTerminate.this;
                    testAttachTerminate.cnt = testAttachTerminate.cnt - 1;
                    if (error != null) {
                        TestAttachTerminate.this.exit(error);
                    } else if (id == null) {
                        TestAttachTerminate.this.exit(new Error("Invalid ID in Diagnostics.runTest responce"));
                    } else if (TestAttachTerminate.this.test_rc.getContext(id) == null) {
                        TestAttachTerminate.this.exit(new Error("Missing 'contextAdded' event for context " + id));
                    } else {
                        TestAttachTerminate.this.test_ctx_ids.add(id);
                        TestAttachTerminate.this.test_rc.cancel(id);
                    }
                }
            });
            ++this.cnt;
            ++i;
        }
    }

    private void exit(Throwable x) {
        if (!this.test_suite.isActive(this)) {
            return;
        }
        this.rc.removeListener((IRunControl.RunControlListener)this);
        this.test_suite.done(this, x);
    }

    public void containerResumed(String[] context_ids) {
    }

    public void containerSuspended(String main_context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
    }

    public void contextAdded(IRunControl.RunControlContext[] contexts) {
    }

    public void contextChanged(IRunControl.RunControlContext[] contexts) {
    }

    public void contextException(String context, String msg) {
    }

    public void contextRemoved(String[] context_ids) {
        String[] stringArray = context_ids;
        int n = context_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (this.test_ctx_ids.remove(id)) {
                this.timer = 0;
            }
            ++n2;
        }
        if (this.cnt == 0 && this.test_ctx_ids.isEmpty()) {
            this.exit(null);
        }
    }

    public void contextResumed(String context) {
    }

    public void contextSuspended(String context, String pc, String reason, Map<String, Object> params) {
    }
}

