/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.core.AbstractPeer;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.osgi.services.IValueAddService;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.core.nls.Messages;
import org.eclipse.tcf.te.tcf.core.va.ValueAddManager;
import org.eclipse.tcf.te.tcf.core.va.interfaces.IValueAdd;
import org.osgi.framework.Bundle;

public final class ChannelManager
extends PlatformObject
implements IChannelManager {
    final Map<String, AtomicInteger> refCounters = new HashMap<String, AtomicInteger>();
    final Map<String, IChannel> channels = new HashMap<String, IChannel>();
    final Map<IPeer, List<DoneHandleValueAdds>> inProgress = new HashMap<IPeer, List<DoneHandleValueAdds>>();

    @Override
    public void openChannel(final IPeer peer, final Map<String, Boolean> flags, final IChannelManager.DoneOpenChannel done) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                ChannelManager.this.internalHandleValueAdds(peer, flags, new DoneHandleValueAdds(){

                    @Override
                    public void doneHandleValueAdds(Throwable error, IValueAdd[] valueAdds) {
                        if (error == null) {
                            if (valueAdds != null && valueAdds.length > 0) {
                                ChannelManager.this.internalChainValueAdds(valueAdds, peer, flags, done);
                            } else {
                                ChannelManager.this.internalOpenChannel(peer, (Map<String, Boolean>)flags, done);
                            }
                        } else {
                            ChannelManager.this.internalShutdownValueAdds(peer, valueAdds);
                            done.doneOpenChannel(error, null);
                        }
                    }
                });
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeLater((Runnable)runnable);
        }
    }

    void internalOpenChannel(IPeer peer, Map<String, Boolean> flags, final IChannelManager.DoneOpenChannel done) {
        block18: {
            IChannel finChannel;
            boolean noValueAdd;
            Assert.isNotNull((Object)peer);
            Assert.isNotNull((Object)done);
            Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
            IChannel channel = null;
            final String id = peer.getID();
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_message, (Object)id, flags), 0, "trace/channelManager", 1, (Object)this);
            }
            boolean forceNew = flags != null && flags.containsKey("forceNew") ? flags.get("forceNew") : false;
            boolean bl = noValueAdd = flags != null && flags.containsKey("noValueAdd") ? flags.get("noValueAdd") : false;
            if (noValueAdd) {
                forceNew = true;
            }
            IChannel iChannel = channel = !forceNew ? this.channels.get(id) : null;
            if (channel != null && (channel.getState() == 1 || channel.getState() == 0)) {
                AtomicInteger counter = this.refCounters.get(id);
                if (counter == null) {
                    counter = new AtomicInteger(0);
                    this.refCounters.put(id, counter);
                }
                counter.incrementAndGet();
                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_reuse_message, (Object)id, (Object)counter.toString()), 0, "trace/channelManager", 1, (Object)this);
                }
            } else if (channel != null) {
                channel = null;
                this.channels.remove(id);
                this.refCounters.remove(id);
            }
            if (channel == null) {
                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_new_message, (Object)id), 0, "trace/channelManager", 1, (Object)this);
                }
                try {
                    channel = peer.openChannel();
                    if (channel != null) {
                        if (!forceNew) {
                            this.channels.put(id, channel);
                        }
                        if (!forceNew) {
                            this.refCounters.put(id, new AtomicInteger(1));
                        }
                        finChannel = channel;
                        channel.addChannelListener(new IChannel.IChannelListener(){

                            public void onChannelOpened() {
                                finChannel.removeChannelListener((IChannel.IChannelListener)this);
                                finChannel.addChannelListener((IChannel.IChannelListener)new ChannelMonitor(id, finChannel));
                                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_success_message, (Object)id), 0, "trace/channelManager", 1, (Object)ChannelManager.this);
                                }
                                done.doneOpenChannel(null, finChannel);
                            }

                            public void onChannelClosed(Throwable error) {
                                finChannel.removeChannelListener((IChannel.IChannelListener)this);
                                ChannelManager.this.channels.remove(id);
                                ChannelManager.this.refCounters.remove(id);
                                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_failed_message, (Object)id, (Object)error), 0, "trace/channelManager", 1, (Object)this);
                                }
                                done.doneOpenChannel(error, finChannel);
                            }

                            public void congestionLevel(int level) {
                            }
                        });
                        break block18;
                    }
                    done.doneOpenChannel(new Exception("Unexpected null return value from IPeer#openChannel()!"), null);
                }
                catch (Throwable e) {
                    if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                        CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_failed_message, (Object)id, (Object)e), 0, "trace/channelManager", 1, (Object)this);
                    }
                    done.doneOpenChannel(e, channel);
                }
            } else if (channel.getState() == 0) {
                finChannel = channel;
                channel.addChannelListener(new IChannel.IChannelListener(){

                    public void onChannelOpened() {
                        done.doneOpenChannel(null, finChannel);
                    }

                    public void onChannelClosed(Throwable error) {
                        done.doneOpenChannel(error, finChannel);
                    }

                    public void congestionLevel(int level) {
                    }
                });
            } else {
                done.doneOpenChannel(null, channel);
            }
        }
    }

    @Override
    public void openChannel(final Map<String, String> peerAttributes, final Map<String, Boolean> flags, final IChannelManager.DoneOpenChannel done) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                ChannelManager.this.internalOpenChannel(peerAttributes, (Map<String, Boolean>)flags, done);
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeLater((Runnable)runnable);
        }
    }

    void internalOpenChannel(Map<String, String> peerAttributes, Map<String, Boolean> flags, IChannelManager.DoneOpenChannel done) {
        Assert.isNotNull(peerAttributes);
        Assert.isNotNull((Object)done);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        this.openChannel(this.getOrCreatePeerInstance(peerAttributes), flags, done);
    }

    private IPeer getOrCreatePeerInstance(Map<String, String> peerAttributes) {
        Assert.isNotNull(peerAttributes);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        String peerId = peerAttributes.get("ID");
        Assert.isNotNull((Object)peerId);
        boolean isTransient = peerAttributes.containsKey("transient") ? Boolean.parseBoolean(peerAttributes.remove("transient")) : false;
        IPeer peer = (IPeer)Protocol.getLocator().getPeers().get(peerId);
        if (peer == null) {
            Object object = peer = isTransient ? new TransientPeer(peerAttributes) : new AbstractPeer(peerAttributes);
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_createPeer_new_message, (Object)peerId, (Object)isTransient), 0, "trace/channelManager", 1, (Object)this);
            }
        }
        return peer;
    }

    @Override
    public IChannel getChannel(final IPeer peer) {
        final AtomicReference channel = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                channel.set(ChannelManager.this.internalGetChannel(peer));
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return (IChannel)channel.get();
    }

    public IChannel internalGetChannel(IPeer peer) {
        Assert.isNotNull((Object)peer);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        return this.channels.get(peer.getID());
    }

    @Override
    public void getRedirectionPath(final IPeer peer, final IValueAddService.DoneGetRedirectionPath done) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                ChannelManager.this.internalGetRedirectionPath(peer, done);
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeLater((Runnable)runnable);
        }
    }

    void internalGetRedirectionPath(final IPeer peer, final IValueAddService.DoneGetRedirectionPath done) {
        Assert.isNotNull((Object)peer);
        Assert.isNotNull((Object)done);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        this.internalHandleValueAdds(peer, new DoneHandleValueAdds(){

            @Override
            public void doneHandleValueAdds(Throwable error, IValueAdd[] valueAdds) {
                StringBuilder redirectionPath = new StringBuilder();
                String peerId = peer.getID();
                if (error == null && valueAdds != null && valueAdds.length > 0) {
                    IValueAdd[] iValueAddArray = valueAdds;
                    int n = valueAdds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IValueAdd valueAdd = iValueAddArray[n2];
                        if (redirectionPath.length() > 0) {
                            redirectionPath.append("/");
                        }
                        redirectionPath.append(valueAdd.getPeer(peerId).getID());
                        ++n2;
                    }
                }
                if (redirectionPath.length() > 0) {
                    redirectionPath.append("/");
                }
                redirectionPath.append(peerId);
                done.doneGetRedirectionPath(error, redirectionPath.toString());
            }
        });
    }

    @Override
    public void closeChannel(final IChannel channel) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                ChannelManager.this.internalCloseChannel(channel);
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeLater((Runnable)runnable);
        }
    }

    void internalCloseChannel(IChannel channel) {
        AtomicInteger counter;
        Assert.isNotNull((Object)channel);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        String id = channel.getRemotePeer().getID();
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
            CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_closeChannel_message, (Object)id), 0, "trace/channelManager", 1, (Object)this);
        }
        if ((counter = this.refCounters.get(id)) == null || counter.decrementAndGet() == 0) {
            channel.close();
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_closeChannel_closed_message, (Object)id), 0, "trace/channelManager", 1, (Object)this);
            }
            this.refCounters.remove(id);
            this.channels.remove(id);
        } else if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
            CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_closeChannel_inuse_message, (Object)id, (Object)counter.toString()), 0, "trace/channelManager", 1, (Object)this);
        }
    }

    @Override
    public void closeAll() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                ChannelManager.this.internalCloseAll();
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeLater((Runnable)runnable);
        }
    }

    void internalCloseAll() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IChannel[] openChannels = this.channels.values().toArray(new IChannel[this.channels.values().size()]);
        this.refCounters.clear();
        this.channels.clear();
        IChannel[] iChannelArray = openChannels;
        int n = openChannels.length;
        int n2 = 0;
        while (n2 < n) {
            IChannel channel = iChannelArray[n2];
            this.internalCloseChannel(channel);
            ++n2;
        }
        this.internalShutdownAllValueAdds();
    }

    void internalShutdownValueAdds(IPeer peer, IValueAdd[] valueAdds) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)peer);
        Assert.isNotNull((Object)valueAdds);
        String id = peer.getID();
        if (valueAdds.length > 0) {
            this.doShutdownValueAdds(id, valueAdds);
        }
    }

    void doShutdownValueAdds(String id, IValueAdd[] valueAdds) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)valueAdds);
        IValueAdd[] iValueAddArray = valueAdds;
        int n = valueAdds.length;
        int n2 = 0;
        while (n2 < n) {
            IValueAdd valueAdd = iValueAddArray[n2];
            valueAdd.shutdown(id, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                }
            });
            ++n2;
        }
    }

    void internalShutdownAllValueAdds() {
        IValueAdd[] valueAdds;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IValueAdd[] iValueAddArray = valueAdds = ValueAddManager.getInstance().getValueAdds(false);
        int n = valueAdds.length;
        int n2 = 0;
        while (n2 < n) {
            IValueAdd valueAdd = iValueAddArray[n2];
            valueAdd.shutdownAll((ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                }
            });
            ++n2;
        }
    }

    void internalHandleValueAdds(IPeer peer, Map<String, Boolean> flags, DoneHandleValueAdds done) {
        IChannel channel;
        boolean noValueAdd;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)peer);
        Assert.isNotNull((Object)done);
        String id = peer.getID();
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
            CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_valueAdd_check, (Object)id), 0, "trace/channelManager", 1, (Object)this);
        }
        boolean forceNew = flags != null && flags.containsKey("forceNew") ? flags.get("forceNew") : false;
        boolean bl = noValueAdd = flags != null && flags.containsKey("noValueAdd") ? flags.get("noValueAdd") : false;
        if (noValueAdd) {
            forceNew = true;
        }
        IChannel iChannel = channel = !forceNew ? this.channels.get(id) : null;
        if (channel != null && (channel.getState() == 1 || channel.getState() == 0)) {
            done.doneHandleValueAdds(null, null);
            return;
        }
        this.internalHandleValueAdds(peer, done);
    }

    void internalHandleValueAdds(final IPeer peer, DoneHandleValueAdds done) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)peer);
        Assert.isNotNull((Object)done);
        String id = peer.getID();
        if (this.inProgress.containsKey(peer)) {
            List<DoneHandleValueAdds> dones = this.inProgress.get(peer);
            Assert.isNotNull(dones);
            dones.add(done);
            return;
        }
        ArrayList<DoneHandleValueAdds> dones = new ArrayList<DoneHandleValueAdds>();
        dones.add(done);
        this.inProgress.put(peer, dones);
        final DoneHandleValueAdds myDone = new DoneHandleValueAdds(){

            @Override
            public void doneHandleValueAdds(Throwable error, IValueAdd[] valueAdds) {
                List<DoneHandleValueAdds> dones = ChannelManager.this.inProgress.remove(peer);
                for (DoneHandleValueAdds done : dones) {
                    done.doneHandleValueAdds(error, valueAdds);
                }
            }
        };
        IValueAdd[] valueAdds = ValueAddManager.getInstance().getValueAdd(peer);
        if (valueAdds.length == 0) {
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_valueAdd_noneApplicable, (Object)id), 0, "trace/channelManager", 1, (Object)this);
            }
            myDone.doneHandleValueAdds(null, valueAdds);
            return;
        }
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
            CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_valueAdd_numApplicable, (Object)valueAdds.length, (Object)id), 0, "trace/channelManager", 1, (Object)this);
        }
        ArrayList<IValueAdd> available = new ArrayList<IValueAdd>();
        DoneLaunchValueAdd innerDone = new DoneLaunchValueAdd(){

            @Override
            public void doneLaunchValueAdd(Throwable error, List<IValueAdd> available) {
                myDone.doneHandleValueAdds(error, available.toArray(new IValueAdd[available.size()]));
            }
        };
        this.doLaunchValueAdd(id, valueAdds, 0, available, innerDone);
    }

    void doLaunchValueAdd(final String id, final IValueAdd[] valueAdds, final int i, final List<IValueAdd> available, final DoneLaunchValueAdd done) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)valueAdds);
        Assert.isTrue((valueAdds.length > 0 ? 1 : 0) != 0);
        Assert.isNotNull(available);
        Assert.isNotNull((Object)done);
        final IValueAdd valueAdd = valueAdds[i];
        valueAdd.isAlive(id, (ICallback)new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                boolean alive = (Boolean)this.getResult();
                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_valueAdd_isAlive, (Object[])new Object[]{i, valueAdd.getLabel(), alive, id}), 0, "trace/channelManager", 1, (Object)ChannelManager.this);
                }
                if (!alive) {
                    valueAdd.launch(id, (ICallback)new Callback(){

                        protected void internalDone(Object caller, IStatus status) {
                            Throwable error = status.getException();
                            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                                CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_valueAdd_launch, (Object[])new Object[]{i, valueAdd.getLabel(), error == null ? "success" : "failed", error != null ? error.getLocalizedMessage() : null, id}), 0, "trace/channelManager", 1, (Object)ChannelManager.this);
                            }
                            if (error != null && valueAdd.isOptional()) {
                                status = new Status(2, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.ChannelManager_valueAdd_launchFailed, (Object)valueAdd.getLabel(), (Object)error.getLocalizedMessage()), error);
                                Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log(status);
                                error = null;
                            } else {
                                available.add(valueAdd);
                            }
                            if (error != null) {
                                done.doneLaunchValueAdd(error, available);
                            } else if (i + 1 < valueAdds.length) {
                                DoneLaunchValueAdd innerDone = new DoneLaunchValueAdd(){

                                    @Override
                                    public void doneLaunchValueAdd(Throwable error, List<IValueAdd> available) {
                                        done.doneLaunchValueAdd(error, available);
                                    }
                                };
                                ChannelManager.this.doLaunchValueAdd(id, valueAdds, i + 1, available, innerDone);
                            } else {
                                done.doneLaunchValueAdd(null, available);
                            }
                        }
                    });
                } else {
                    available.add(valueAdd);
                    if (i + 1 < valueAdds.length) {
                        DoneLaunchValueAdd innerDone = new DoneLaunchValueAdd(){

                            @Override
                            public void doneLaunchValueAdd(Throwable error, List<IValueAdd> available) {
                                done.doneLaunchValueAdd(error, available);
                            }
                        };
                        ChannelManager.this.doLaunchValueAdd(id, valueAdds, i + 1, available, innerDone);
                    } else {
                        done.doneLaunchValueAdd(null, available);
                    }
                }
            }
        });
    }

    void internalChainValueAdds(IValueAdd[] valueAdds, IPeer peer, Map<String, Boolean> flags, final IChannelManager.DoneOpenChannel done) {
        IChannel channel;
        boolean noValueAdd;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)valueAdds);
        Assert.isNotNull((Object)peer);
        Assert.isNotNull((Object)done);
        String id = peer.getID();
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
            CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_valueAdd_startChaining, (Object)id), 0, "trace/channelManager", 1, (Object)this);
        }
        boolean forceNew = flags != null && flags.containsKey("forceNew") ? flags.get("forceNew") : false;
        boolean bl = noValueAdd = flags != null && flags.containsKey("noValueAdd") ? flags.get("noValueAdd") : false;
        if (noValueAdd) {
            forceNew = true;
        }
        IChannel iChannel = channel = !forceNew ? this.channels.get(id) : null;
        if (channel != null && (channel.getState() == 1 || channel.getState() == 0)) {
            AtomicInteger counter = this.refCounters.get(id);
            if (counter == null) {
                counter = new AtomicInteger(0);
                this.refCounters.put(id, counter);
            }
            counter.incrementAndGet();
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_reuse_message, (Object)id, (Object)counter.toString()), 0, "trace/channelManager", 1, (Object)this);
            }
            done.doneOpenChannel(null, channel);
            return;
        }
        if (channel != null) {
            this.channels.remove(id);
            this.refCounters.remove(id);
        }
        DoneChainValueAdd innerDone = new DoneChainValueAdd(){

            @Override
            public void doneChainValueAdd(Throwable error, IChannel channel) {
                done.doneOpenChannel(error, channel);
            }
        };
        this.doChainValueAdd(id, peer.getAttributes(), forceNew, valueAdds, innerDone);
    }

    void doChainValueAdd(final String id, final Map<String, String> attrs, boolean forceNew, final IValueAdd[] valueAdds, final DoneChainValueAdd done) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)id);
        Assert.isNotNull(attrs);
        Assert.isNotNull((Object)valueAdds);
        Assert.isNotNull((Object)done);
        final AtomicInteger index = new AtomicInteger(0);
        final AtomicReference<IValueAdd> valueAdd = new AtomicReference<IValueAdd>();
        valueAdd.set(valueAdds[index.get()]);
        Assert.isNotNull(valueAdd.get());
        final AtomicReference<IValueAdd> nextValueAdd = new AtomicReference<IValueAdd>();
        nextValueAdd.set(index.get() + 1 < valueAdds.length ? valueAdds[index.get() + 1] : null);
        final AtomicReference<IPeer> valueAddPeer = new AtomicReference<IPeer>();
        valueAddPeer.set(((IValueAdd)valueAdd.get()).getPeer(id));
        if (valueAddPeer.get() == null) {
            done.doneChainValueAdd(new IllegalStateException("Invalid value-add peer."), null);
            return;
        }
        final AtomicReference<IPeer> nextValueAddPeer = new AtomicReference<IPeer>();
        nextValueAddPeer.set(nextValueAdd.get() != null ? ((IValueAdd)nextValueAdd.get()).getPeer(id) : null);
        if (nextValueAdd.get() != null && nextValueAddPeer.get() == null) {
            done.doneChainValueAdd(new IllegalStateException("Invalid value-add peer."), null);
            return;
        }
        IChannel channel = null;
        try {
            channel = ((IPeer)valueAddPeer.get()).openChannel();
            if (channel != null) {
                if (!forceNew) {
                    this.channels.put(id, channel);
                }
                if (!forceNew) {
                    this.refCounters.put(id, new AtomicInteger(1));
                }
                channel.redirect(nextValueAddPeer.get() != null ? ((IPeer)nextValueAddPeer.get()).getAttributes() : attrs);
                final IChannel finChannel = channel;
                channel.addChannelListener(new IChannel.IChannelListener(){

                    public void onChannelOpened() {
                        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                            CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_valueAdd_redirect_succeeded, (Object[])new Object[]{((IPeer)valueAddPeer.get()).getID(), finChannel.getRemotePeer().getID(), index.get()}), 0, "trace/channelManager", 1, (Object)ChannelManager.this);
                        }
                        if (nextValueAdd.get() == null) {
                            finChannel.removeChannelListener((IChannel.IChannelListener)this);
                            done.doneChainValueAdd(null, finChannel);
                        } else {
                            index.incrementAndGet();
                            valueAdd.set((IValueAdd)nextValueAdd.get());
                            valueAddPeer.set((IPeer)nextValueAddPeer.get());
                            if (valueAddPeer.get() == null) {
                                finChannel.removeChannelListener((IChannel.IChannelListener)this);
                                finChannel.close();
                                done.doneChainValueAdd(new IllegalStateException("Invalid value-add peer."), null);
                                return;
                            }
                            nextValueAdd.set(index.get() + 1 < valueAdds.length ? valueAdds[index.get() + 1] : null);
                            nextValueAddPeer.set(nextValueAdd.get() != null ? ((IValueAdd)nextValueAdd.get()).getPeer(id) : null);
                            if (nextValueAdd.get() != null && nextValueAddPeer.get() == null) {
                                finChannel.removeChannelListener((IChannel.IChannelListener)this);
                                finChannel.close();
                                done.doneChainValueAdd(new IllegalStateException("Invalid value-add peer."), null);
                                return;
                            }
                            finChannel.redirect(nextValueAddPeer.get() != null ? ((IPeer)nextValueAddPeer.get()).getAttributes() : attrs);
                        }
                    }

                    public void onChannelClosed(Throwable error) {
                        finChannel.removeChannelListener((IChannel.IChannelListener)this);
                        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                            CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_valueAdd_redirect_failed, (Object)((IPeer)valueAddPeer.get()).getID(), (Object)(nextValueAddPeer.get() != null ? ((IPeer)nextValueAddPeer.get()).getID() : id)), 0, "trace/channelManager", 1, (Object)ChannelManager.this);
                        }
                        ChannelManager.this.channels.remove(id);
                        ChannelManager.this.refCounters.remove(id);
                        done.doneChainValueAdd(error, finChannel);
                    }

                    public void congestionLevel(int level) {
                    }
                });
            } else {
                done.doneChainValueAdd(new Exception("Unexpected null return value from IPeer#openChannel()!"), null);
            }
        }
        catch (Throwable e) {
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_failed_message, (Object)id, (Object)e), 0, "trace/channelManager", 1, (Object)this);
            }
            done.doneChainValueAdd(e, channel);
        }
    }

    private final class ChannelMonitor
    implements IChannel.IChannelListener {
        private final IChannel channel;
        private final String id;

        public ChannelMonitor(String id, IChannel channel) {
            Assert.isNotNull((Object)id);
            Assert.isNotNull((Object)channel);
            this.id = id;
            this.channel = channel;
        }

        public void onChannelOpened() {
        }

        public void onChannelClosed(Throwable error) {
            this.channel.removeChannelListener((IChannel.IChannelListener)this);
            ChannelManager.this.channels.remove(this.id);
            ChannelManager.this.refCounters.remove(this.id);
        }

        public void congestionLevel(int level) {
        }
    }

    static interface DoneChainValueAdd {
        public void doneChainValueAdd(Throwable var1, IChannel var2);
    }

    static interface DoneHandleValueAdds {
        public void doneHandleValueAdds(Throwable var1, IValueAdd[] var2);
    }

    static interface DoneLaunchValueAdd {
        public void doneLaunchValueAdd(Throwable var1, List<IValueAdd> var2);
    }
}

