/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.va;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.runtime.processes.ProcessLauncher;
import org.eclipse.tcf.te.runtime.processes.ProcessOutputReaderThread;
import org.eclipse.tcf.te.runtime.utils.Host;
import org.eclipse.tcf.te.tcf.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.core.nls.Messages;
import org.osgi.framework.Bundle;

public class ValueAddLauncher
extends ProcessLauncher
implements IDisposable {
    private final String id;
    private final IPath path;
    private final String valueAddId;
    private Process process;
    private ProcessOutputReaderThread outputReader;

    public ValueAddLauncher(String id, IPath path, String valueAddId) {
        super(null, null, 0);
        Assert.isNotNull((Object)id);
        this.id = id;
        Assert.isNotNull((Object)path);
        this.path = path;
        Assert.isNotNull((Object)valueAddId);
        this.valueAddId = valueAddId;
    }

    public void dispose() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
    }

    public Process getProcess() {
        return this.process;
    }

    public ProcessOutputReaderThread getOutputReader() {
        return this.outputReader;
    }

    public void launch() throws Throwable {
        IPath dir = this.path.removeLastSegments(1);
        String cmd = Host.isWindowsHost() ? this.path.toOSString() : "./" + this.path.lastSegment();
        ArrayList<String> command = new ArrayList<String>();
        command.add(cmd);
        this.addToCommand(command, "-I180");
        this.addToCommand(command, "-S");
        this.addToCommand(command, "-sTCP::;ValueAdd=1");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "va/logging/enable")) {
            IPath location;
            Bundle bundle = Platform.getBundle((String)"org.eclipse.tcf.te.tcf.log.core");
            IPath iPath = location = bundle != null ? Platform.getStateLocation((Bundle)bundle) : null;
            if (location != null) {
                location = location.append(".logs");
                String name = "Output_" + this.valueAddId + "_" + this.id + ".log";
                name = name.replaceAll("\\s", "_");
                name = name.replaceAll("[:/\\;,]", "_");
                location = location.append(name);
                this.addToCommand(command, "-L" + location.toString());
                String level = Platform.getDebugOption((String)(String.valueOf(CoreBundleActivator.getUniqueIdentifier()) + "/" + "va/logging/level"));
                if (level != null && !"".equals(level.trim())) {
                    this.addToCommand(command, "-l" + level.trim());
                }
            }
        }
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
            CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ValueAddLauncher_launch_command, (Object[])new Object[]{command, this.id, this.valueAddId}), 0, "trace/channelManager", 1, (Object)this);
        }
        this.process = Runtime.getRuntime().exec(command.toArray(new String[command.size()]), null, dir.toFile());
        this.outputReader = new ProcessOutputReaderThread(null, new InputStream[]{this.process.getInputStream()});
        this.outputReader.start();
    }

    protected void addToCommand(List<String> command, String arg) {
        Assert.isNotNull(command);
        Assert.isNotNull((Object)arg);
        command.add(arg);
    }
}

