/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.process;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.ui.terminals.process.ProcessMonitor;
import org.eclipse.tcf.te.ui.terminals.process.ProcessSettings;
import org.eclipse.tcf.te.ui.terminals.process.ProcessSettingsPage;
import org.eclipse.tcf.te.ui.terminals.process.activator.UIPlugin;
import org.eclipse.tcf.te.ui.terminals.process.nls.Messages;
import org.eclipse.tcf.te.ui.terminals.streams.AbstractStreamsConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;

public class ProcessConnector
extends AbstractStreamsConnector {
    private final ProcessSettings settings;
    private PTY pty;
    private Process process;
    private ProcessMonitor monitor;
    private int width = -1;
    private int height = -1;
    private static final Object ENV_GET_MONITOR = new Object();
    private static Map<String, String> nativeEnvironment = null;
    private static Map<String, String> nativeEnvironmentCasePreserved = null;

    public ProcessConnector() {
        this(new ProcessSettings());
    }

    public ProcessConnector(ProcessSettings settings) {
        Assert.isNotNull((Object)settings);
        this.settings = settings;
    }

    public Process getProcess() {
        return this.process;
    }

    public void connect(ITerminalControl control) {
        Assert.isNotNull((Object)control);
        super.connect(control);
        this.pty = null;
        this.width = -1;
        this.height = -1;
        try {
            String lineSeparator;
            this.process = this.settings.getProcess();
            this.pty = this.settings.getPTY();
            if (this.process == null) {
                if (PTY.isSupported()) {
                    try {
                        this.pty = new PTY(false);
                    }
                    catch (IOException iOException) {}
                }
                StringBuilder command = new StringBuilder(this.settings.getImage());
                String arguments = this.settings.getArguments();
                if (arguments != null && !"".equals(arguments.trim())) {
                    command.append(" ");
                    command.append(arguments.trim());
                }
                if (this.pty != null) {
                    StreamTokenizer st = new StreamTokenizer(new StringReader(command.toString()));
                    st.resetSyntax();
                    st.whitespaceChars(0, 32);
                    st.whitespaceChars(160, 160);
                    st.wordChars(33, 255);
                    st.quoteChar(34);
                    st.quoteChar(39);
                    ArrayList<String> argv = new ArrayList<String>();
                    int ttype = st.nextToken();
                    while (ttype != -1) {
                        argv.add(st.sval);
                        ttype = st.nextToken();
                    }
                    this.process = ProcessFactory.getFactory().exec(argv.toArray(new String[argv.size()]), ProcessConnector.getProcessEnvironment(), null, this.pty);
                } else {
                    this.process = Runtime.getRuntime().exec(command.toString());
                }
            }
            if ((lineSeparator = this.settings.getLineSeparator()) == null) {
                lineSeparator = System.getProperty("line.separator");
                lineSeparator = "\r".equals(lineSeparator) ? "\\r" : ("\n".equals(lineSeparator) ? "\\n" : "\\r\\n");
            }
            this.connectStreams(control, this.process.getOutputStream(), this.process.getInputStream(), this.pty == null ? this.process.getErrorStream() : null, this.settings.isLocalEcho(), lineSeparator);
            control.setState(TerminalState.CONNECTED);
            this.monitor = new ProcessMonitor(this);
            this.monitor.startMonitoring();
        }
        catch (IOException e) {
            Status status = new Status(4, UIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.ProcessConnector_error_creatingProcess, (Object)e.getLocalizedMessage()), (Throwable)e);
            UIPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    public boolean isLocalEcho() {
        return this.settings.isLocalEcho();
    }

    public void doDisconnect() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        super.doDisconnect();
        this.fControl.setState(TerminalState.CLOSED);
    }

    public ISettingsPage makeSettingsPage() {
        return new ProcessSettingsPage(this.settings);
    }

    public String getSettingsSummary() {
        return this.settings.getImage() != null ? this.settings.getImage() : "";
    }

    public void load(ISettingsStore store) {
        this.settings.load(store);
    }

    public void save(ISettingsStore store) {
        this.settings.save(store);
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        if (this.width != newWidth || this.height != newHeight) {
            this.width = newWidth;
            this.height = newHeight;
            if (this.pty != null) {
                this.pty.setTerminalSize(newWidth, newHeight);
            }
        }
    }

    private static String[] getProcessEnvironment() {
        Map<String, String> env = ProcessConnector.getNativeEnvironment();
        env.put("TERM", "ansi");
        Iterator<Map.Entry<String, String>> iter = env.entrySet().iterator();
        ArrayList<String> strings = new ArrayList<String>(env.size());
        StringBuffer buffer = null;
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            buffer = new StringBuffer(entry.getKey());
            buffer.append('=').append(entry.getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getNativeEnvironment() {
        Object object = ENV_GET_MONITOR;
        synchronized (object) {
            if (nativeEnvironment == null) {
                Map<String, String> casePreserved = ProcessConnector.getNativeEnvironmentCasePreserved();
                if (Platform.getOS().equals("win32")) {
                    nativeEnvironment = new HashMap<String, String>();
                    for (Map.Entry<String, String> entry : casePreserved.entrySet()) {
                        nativeEnvironment.put(entry.getKey().toUpperCase(), entry.getValue());
                    }
                } else {
                    nativeEnvironment = new HashMap<String, String>(casePreserved);
                }
            }
            return new HashMap<String, String>(nativeEnvironment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getNativeEnvironmentCasePreserved() {
        Object object = ENV_GET_MONITOR;
        synchronized (object) {
            if (nativeEnvironmentCasePreserved == null) {
                nativeEnvironmentCasePreserved = new HashMap<String, String>();
                ProcessConnector.cacheNativeEnvironment(nativeEnvironmentCasePreserved);
            }
            return new HashMap<String, String>(nativeEnvironmentCasePreserved);
        }
    }

    private static void cacheNativeEnvironment(Map<String, String> cache) {
        block27: {
            Assert.isNotNull(cache);
            try {
                String nativeCommand = null;
                boolean isWin9xME = false;
                String fileName = null;
                if (Platform.getOS().equals("win32")) {
                    String osName = System.getProperty("os.name");
                    boolean bl = isWin9xME = osName != null && (osName.startsWith("Windows 9") || osName.startsWith("Windows ME"));
                    if (isWin9xME) {
                        IPath stateLocation = UIPlugin.getDefault().getStateLocation();
                        fileName = String.valueOf(stateLocation.toOSString()) + File.separator + "env.txt";
                        nativeCommand = "command.com /C set > " + fileName;
                    } else {
                        nativeCommand = "cmd.exe /C set";
                    }
                } else if (!Platform.getOS().equals("unknown")) {
                    nativeCommand = "env";
                }
                if (nativeCommand == null) {
                    return;
                }
                Process process = Runtime.getRuntime().exec(nativeCommand);
                if (isWin9xME) {
                    Properties p = new Properties();
                    File file = new File(fileName);
                    InputStream stream = null;
                    try {
                        stream = new BufferedInputStream(new FileInputStream(file));
                        p.load(stream);
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    if (!file.delete()) {
                        file.deleteOnExit();
                    }
                    Enumeration<Object> enumeration = p.keys();
                    while (enumeration.hasMoreElements()) {
                        String key = (String)enumeration.nextElement();
                        cache.put(key, (String)p.get(key));
                    }
                    break block27;
                }
                InputStream stream = process.getInputStream();
                InputStreamReader isreader = new InputStreamReader(stream);
                BufferedReader reader = new BufferedReader(isreader);
                try {
                    String line = reader.readLine();
                    String key = null;
                    String value = null;
                    while (line != null) {
                        int func = line.indexOf("=()");
                        if (func > 0) {
                            key = line.substring(0, func);
                            value = line.substring(func + 1);
                            while (line != null && !line.equals("}")) {
                                line = reader.readLine();
                                if (line == null) continue;
                                value = String.valueOf(value) + line;
                            }
                            line = reader.readLine();
                        } else {
                            int separator = line.indexOf(61);
                            if (separator > 0) {
                                key = line.substring(0, separator);
                                value = line.substring(separator + 1);
                                StringBuilder bufValue = new StringBuilder(value);
                                line = reader.readLine();
                                if (line != null) {
                                    separator = line.indexOf(61);
                                    while (separator < 0) {
                                        bufValue.append(line.trim());
                                        line = reader.readLine();
                                        if (line == null) break;
                                        separator = line.indexOf(61);
                                    }
                                }
                                value = bufValue.toString();
                            }
                        }
                        if (key != null) {
                            cache.put(key, value);
                            key = null;
                            value = null;
                            continue;
                        }
                        line = reader.readLine();
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

