/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.editor.pages;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.core.interfaces.IViewerInput;
import org.eclipse.tcf.te.ui.forms.CustomFormToolkit;
import org.eclipse.tcf.te.ui.trees.TreeControl;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractCustomFormToolkitEditorPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.osgi.framework.Bundle;

public abstract class TreeViewerExplorerEditorPage
extends AbstractCustomFormToolkitEditorPage
implements IDoubleClickListener {
    private TreeControl treeControl;
    private IToolBarManager toolbarMgr;
    private PropertyChangeListener pcListener;
    private Image formImage;

    @Override
    public void dispose() {
        Object input = this.getEditorInputNode();
        IViewerInput viewerInput = this.getViewerInput(input);
        if (viewerInput != null && this.pcListener != null) {
            viewerInput.removePropertyChangeListener(this.pcListener);
        }
        if (this.formImage != null) {
            this.formImage.dispose();
        }
        if (this.treeControl != null) {
            this.treeControl.dispose();
            this.treeControl = null;
        }
        super.dispose();
    }

    @Override
    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        ImageDescriptor iconDesc;
        URL iconURL;
        String bundleId;
        Bundle bundle;
        super.setInitializationData(config, propertyName, data);
        String iconPath = config.getAttribute("icon");
        if (iconPath != null && (bundle = Platform.getBundle((String)(bundleId = config.getContributor().getName()))) != null && (iconURL = bundle.getEntry(iconPath)) != null && (iconDesc = ImageDescriptor.createFromURL((URL)iconURL)) != null) {
            this.formImage = iconDesc.createImage();
        }
    }

    @Override
    protected Image getFormImage() {
        return this.formImage;
    }

    @Override
    protected void configureManagedForm(IManagedForm managedForm) {
        this.treeControl = this.doCreateTreeControl();
        super.configureManagedForm(managedForm);
    }

    @Override
    protected void createToolbarContributionItems(IToolBarManager manager) {
        this.toolbarMgr = manager;
        this.treeControl.createToolbarContributionItems(manager);
        super.createToolbarContributionItems(manager);
    }

    @Override
    protected void doCreateFormContent(Composite parent, CustomFormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)toolkit);
        Assert.isNotNull((Object)this.treeControl);
        this.treeControl.setupFormPanel(parent, toolkit);
        this.getSite().registerContextMenu(this.getId(), this.treeControl.getContextMenuManager(), (ISelectionProvider)this.treeControl.getViewer());
        Object input = this.getEditorInputNode();
        this.treeControl.getViewer().setInput(input);
        this.addViewerListeners();
        this.updateUI();
    }

    private void addViewerListeners() {
        TreeViewer viewer = (TreeViewer)this.treeControl.getViewer();
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeViewerExplorerEditorPage.this.propagateSelection();
            }
        });
        viewer.getTree().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                TreeViewerExplorerEditorPage.this.propagateSelection();
            }
        });
        viewer.addDoubleClickListener((IDoubleClickListener)this);
        Object input = this.getEditorInputNode();
        IViewerInput viewerInput = this.getViewerInput(input);
        if (viewerInput != null) {
            this.pcListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    Object object = event.getSource();
                    if (object == TreeViewerExplorerEditorPage.this.getEditorInputNode()) {
                        if (Display.getCurrent() != null) {
                            TreeViewerExplorerEditorPage.this.updateUI();
                        } else {
                            Display display = TreeViewerExplorerEditorPage.this.getSite().getShell().getDisplay();
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    TreeViewerExplorerEditorPage.this.updateUI();
                                }
                            });
                        }
                    }
                }
            };
            viewerInput.addPropertyChangeListener(this.pcListener);
        }
    }

    private IViewerInput getViewerInput(Object input) {
        IViewerInput viewerInput = null;
        if (input != null) {
            if (input instanceof IViewerInput) {
                viewerInput = (IViewerInput)input;
            } else {
                if (input instanceof IAdaptable) {
                    viewerInput = (IViewerInput)((IAdaptable)input).getAdapter(IViewerInput.class);
                }
                if (viewerInput == null) {
                    viewerInput = (IViewerInput)Platform.getAdapterManager().getAdapter(input, IViewerInput.class);
                }
            }
        }
        return viewerInput;
    }

    protected TreeControl doCreateTreeControl() {
        return new TreeControl(this.getViewerId(), (IWorkbenchPart)this);
    }

    public final TreeControl getTreeControl() {
        return this.treeControl;
    }

    protected void updateUI() {
        this.toolbarMgr.update(true);
        ILabelDecorator decorator = this.getTitleBarDecorator();
        if (decorator != null) {
            IManagedForm managedForm = this.getManagedForm();
            Form form = managedForm.getForm().getForm();
            Object element = this.getEditorInputNode();
            String text = this.getFormTitle();
            if (text != null && (text = decorator.decorateText(text, element)) != null) {
                try {
                    form.setText(text);
                }
                catch (Exception exception) {}
            }
            Image image = this.getFormImage();
            if ((image = decorator.decorateImage(image, element)) != null) {
                try {
                    form.setImage(image);
                }
                catch (Exception exception) {}
            }
        }
    }

    protected ILabelDecorator getTitleBarDecorator() {
        return null;
    }

    protected void propagateSelection() {
        ISelection selection = this.treeControl.getViewer().getSelection();
        ISelectionProvider selectionProvider = this.getSite().getSelectionProvider();
        try {
            selectionProvider.setSelection(selection);
            if (selectionProvider instanceof MultiPageSelectionProvider) {
                SelectionChangedEvent changedEvent = new SelectionChangedEvent(selectionProvider, selection);
                ((MultiPageSelectionProvider)selectionProvider).firePostSelectionChanged(changedEvent);
            }
        }
        catch (SWTException sWTException) {}
    }

    protected String getDoubleClickCommandId() {
        return null;
    }

    protected abstract String getViewerId();

    public void doubleClick(final DoubleClickEvent event) {
        String commandId = this.getDoubleClickCommandId();
        Command cmd = null;
        if (commandId != null) {
            ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command = cmd = service != null ? service.getCommand(commandId) : null;
        }
        if (cmd != null && cmd.isDefined() && cmd.isEnabled()) {
            final Command command = cmd;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void handleException(Throwable e) {
                }

                public void run() throws Exception {
                    ISelection selection = event.getSelection();
                    EvaluationContext ctx = new EvaluationContext(null, (Object)selection);
                    ctx.addVariable("selection", (Object)selection);
                    ctx.addVariable("activeMenuSelection", (Object)selection);
                    ctx.addVariable("activeWorkbenchWindow", (Object)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                    IWorkbenchPartSite site = TreeViewerExplorerEditorPage.this.getSite();
                    ctx.addVariable("activePartId", (Object)site.getId());
                    ctx.addVariable("activePart", (Object)TreeViewerExplorerEditorPage.this);
                    ctx.addVariable("activeSite", (Object)site);
                    ctx.addVariable("activeShell", (Object)site.getShell());
                    ctx.setAllowPluginActivation(true);
                    ParameterizedCommand pCmd = ParameterizedCommand.generateCommand((Command)command, null);
                    Assert.isNotNull((Object)pCmd);
                    IHandlerService handlerSvc = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                    Assert.isNotNull((Object)handlerSvc);
                    handlerSvc.executeCommandInContext(pCmd, null, (IEvaluationContext)ctx);
                }
            });
        } else {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object element = selection.getFirstElement();
            TreeViewer viewer = (TreeViewer)this.treeControl.getViewer();
            if (viewer.isExpandable(element)) {
                viewer.setExpandedState(element, !viewer.getExpandedState(element));
            }
        }
    }
}

