/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.internal.categories;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.ui.views.activator.UIPlugin;
import org.eclipse.tcf.te.ui.views.extensions.CategoriesExtensionPointManager;
import org.eclipse.tcf.te.ui.views.interfaces.categories.ICategoryManager;

public class CategoryManager
implements ICategoryManager {
    private final Map<String, List<String>> cat2id = new HashMap<String, List<String>>();
    private final Map<String, List<String>> id2cat = new HashMap<String, List<String>>();
    private final Map<String, List<String>> _t_cat2id = new HashMap<String, List<String>>();
    private final Map<String, List<String>> _t_id2cat = new HashMap<String, List<String>>();

    public CategoryManager() {
        this.initialize();
    }

    private IPath getRoot() {
        File file;
        try {
            file = UIPlugin.getDefault().getStateLocation().toFile();
            boolean exists = file.exists();
            if (!exists) {
                exists = file.mkdirs();
            }
            if (exists && file.canRead() && file.isDirectory()) {
                return new Path(file.toString());
            }
        }
        catch (IllegalStateException illegalStateException) {}
        file = new Path(System.getProperty("user.home")).append(".tcf").toFile();
        if (file.canRead() && file.isDirectory()) {
            return new Path(file.toString());
        }
        return null;
    }

    private void initialize() {
        Reader reader;
        IPath root = this.getRoot();
        if (root == null) {
            return;
        }
        this._t_cat2id.clear();
        this._t_id2cat.clear();
        Gson gson = new GsonBuilder().create();
        File file = root.append("cat2id.json").toFile();
        try {
            this.cat2id.clear();
            reader = null;
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                this.cat2id.putAll((Map)gson.fromJson(reader, Map.class));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException iOException) {}
        file = root.append("id2cat.json").toFile();
        try {
            this.id2cat.clear();
            reader = null;
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                this.id2cat.putAll((Map)gson.fromJson(reader, Map.class));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException iOException) {}
    }

    @Override
    public void flush() {
        Writer writer;
        IPath root = this.getRoot();
        if (root == null) {
            return;
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File file = root.append("cat2id.json").toFile();
        try {
            writer = null;
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                gson.toJson(this.cat2id, Map.class, (Appendable)writer);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException iOException) {}
        file = root.append("id2cat.json").toFile();
        try {
            writer = null;
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                gson.toJson(this.id2cat, Map.class, (Appendable)writer);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException iOException) {}
    }

    @Override
    public boolean add(String categoryId, String id) {
        List<String> cats;
        Assert.isNotNull((Object)categoryId);
        Assert.isNotNull((Object)id);
        boolean added = false;
        List<String> ids = this.cat2id.get(categoryId);
        if (ids == null) {
            ids = new ArrayList<String>();
            this.cat2id.put(categoryId, ids);
        }
        if (!ids.contains(id)) {
            added |= ids.add(id);
        }
        if ((cats = this.id2cat.get(id)) == null) {
            cats = new ArrayList<String>();
            this.id2cat.put(id, cats);
        }
        if (!cats.contains(categoryId)) {
            added |= cats.add(categoryId);
        }
        if (added) {
            this.flush();
            EventManager.getInstance().fireEvent((EventObject)new ChangeEvent((Object)CategoriesExtensionPointManager.getInstance().getCategory(categoryId, false), (Object)"added", null, (Object)id));
        }
        return added;
    }

    @Override
    public boolean addTransient(String categoryId, String id) {
        List<String> cats;
        Assert.isNotNull((Object)categoryId);
        Assert.isNotNull((Object)id);
        boolean added = false;
        List<String> ids = this._t_cat2id.get(categoryId);
        if (ids == null) {
            ids = new ArrayList<String>();
            this._t_cat2id.put(categoryId, ids);
        }
        if (!ids.contains(id)) {
            added |= ids.add(id);
        }
        if ((cats = this._t_id2cat.get(id)) == null) {
            cats = new ArrayList<String>();
            this._t_id2cat.put(id, cats);
        }
        if (!cats.contains(categoryId)) {
            added |= cats.add(categoryId);
        }
        if (added) {
            EventManager.getInstance().fireEvent((EventObject)new ChangeEvent((Object)CategoriesExtensionPointManager.getInstance().getCategory(categoryId, false), (Object)"added", null, (Object)id));
        }
        return added;
    }

    @Override
    public boolean remove(String categoryId, String id) {
        List<String> cats;
        Assert.isNotNull((Object)categoryId);
        Assert.isNotNull((Object)id);
        boolean removed = false;
        List<String> ids = this.cat2id.get(categoryId);
        if (ids != null) {
            removed |= ids.remove(id);
            if (ids.isEmpty()) {
                this.cat2id.remove(categoryId);
            }
        }
        if ((ids = this._t_cat2id.get(categoryId)) != null) {
            removed |= ids.remove(id);
            if (ids.isEmpty()) {
                this._t_cat2id.remove(categoryId);
            }
        }
        if ((cats = this.id2cat.get(id)) != null) {
            removed |= cats.remove(categoryId);
            if (cats.isEmpty()) {
                this.id2cat.remove(id);
            }
        }
        if ((cats = this._t_id2cat.get(id)) != null) {
            removed |= cats.remove(categoryId);
            if (cats.isEmpty()) {
                this._t_id2cat.remove(id);
            }
        }
        if (removed) {
            this.flush();
            EventManager.getInstance().fireEvent((EventObject)new ChangeEvent((Object)CategoriesExtensionPointManager.getInstance().getCategory(categoryId, false), (Object)"removed", (Object)id, null));
        }
        return removed;
    }

    @Override
    public boolean belongsTo(String categoryId, String id) {
        Assert.isNotNull((Object)categoryId);
        Assert.isNotNull((Object)id);
        boolean belongsTo = false;
        List<String> ids = this.cat2id.get(categoryId);
        if (ids != null && ids.contains(id)) {
            belongsTo = true;
        } else {
            ids = this._t_cat2id.get(categoryId);
            if (ids != null && ids.contains(id)) {
                belongsTo = true;
            }
        }
        return belongsTo;
    }

    @Override
    public String[] getCategoryIds(String id) {
        Assert.isNotNull((Object)id);
        ArrayList<String> allCategories = new ArrayList<String>();
        List<String> cats = this.id2cat.get(id);
        if (cats != null) {
            allCategories.addAll(cats);
        }
        if ((cats = this._t_id2cat.get(id)) != null) {
            for (String cat : cats) {
                if (allCategories.contains(cat)) continue;
                allCategories.add(cat);
            }
        }
        return allCategories.toArray(new String[allCategories.size()]);
    }
}

