/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tcf.internal.debug.launch.TCFLaunchDelegate;
import org.eclipse.tcf.internal.debug.model.TCFMemoryRegion;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.commands.MemoryMapItemDialog;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeLaunch;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.services.IMemory;
import org.eclipse.tcf.services.IMemoryMap;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;

public class MemoryMapWidget {
    private static final int SIZING_TABLE_WIDTH = 700;
    private static final int SIZING_TABLE_HEIGHT = 300;
    private static final String[] column_names = new String[]{"File", "Address", "Size", "Flags", "File offset/section"};
    private final TCFModel model;
    private final IChannel channel;
    private final TCFNode selection;
    private Combo ctx_text;
    private Table map_table;
    private TableViewer table_viewer;
    private Runnable update_map_buttons;
    private final Map<String, ArrayList<IMemoryMap.MemoryRegion>> org_maps = new HashMap<String, ArrayList<IMemoryMap.MemoryRegion>>();
    private final Map<String, ArrayList<IMemoryMap.MemoryRegion>> cur_maps = new HashMap<String, ArrayList<IMemoryMap.MemoryRegion>>();
    private final ArrayList<IMemoryMap.MemoryRegion> target_map = new ArrayList();
    private final HashMap<String, TCFNodeExecContext> target_map_nodes = new HashMap();
    private TCFNodeExecContext selected_mem_map_node;
    private IMemory.MemoryContext mem_ctx;
    private ILaunchConfiguration cfg;
    private final HashSet<String> loaded_files = new HashSet();
    private String selected_mem_map_id;
    private final ArrayList<ModifyListener> modify_listeners = new ArrayList();
    private final IStructuredContentProvider content_provider = new IStructuredContentProvider(){

        public Object[] getElements(Object input) {
            ArrayList res = new ArrayList();
            ArrayList lst = (ArrayList)MemoryMapWidget.this.cur_maps.get((String)input);
            if (lst != null) {
                res.addAll(lst);
            }
            res.addAll(MemoryMapWidget.this.target_map);
            return res.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };

    public MemoryMapWidget(Composite composite, TCFNode node) {
        if (node != null) {
            this.model = node.getModel();
            this.channel = node.getChannel();
            this.selection = node;
        } else {
            this.model = null;
            this.channel = null;
            this.selection = null;
        }
        this.createContextText(composite);
        this.createMemoryMapTable(composite);
    }

    public String getMemoryMapID() {
        return this.selected_mem_map_id;
    }

    private void createContextText(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label props_label = new Label(composite, 64);
        props_label.setLayoutData((Object)new GridData(256));
        props_label.setFont(font);
        props_label.setText("&Debug context:");
        this.ctx_text = new Combo(composite, 2060);
        this.ctx_text.setLayoutData((Object)new GridData(768));
        this.ctx_text.setFont(font);
        this.ctx_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MemoryMapWidget.this.selected_mem_map_id = MemoryMapWidget.this.ctx_text.getText();
                MemoryMapWidget.this.selected_mem_map_node = (TCFNodeExecContext)MemoryMapWidget.this.target_map_nodes.get(MemoryMapWidget.this.selected_mem_map_id);
                MemoryMapWidget.this.loadTargetMemoryMap();
                MemoryMapWidget.this.table_viewer.setInput((Object)MemoryMapWidget.this.selected_mem_map_id);
                if (MemoryMapWidget.this.selected_mem_map_id.length() == 0) {
                    MemoryMapWidget.this.selected_mem_map_id = null;
                }
                MemoryMapWidget.this.update_map_buttons.run();
            }
        });
    }

    private void createMemoryMapTable(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.map_table = new Table(composite, 68356);
        this.map_table.setFont(font);
        GridData data = new GridData(1808);
        data.widthHint = 700;
        data.heightHint = 300;
        this.map_table.setLayoutData((Object)data);
        int w = 700 / (column_names.length + 12);
        int i = 0;
        while (i < column_names.length) {
            TableColumn column = new TableColumn(this.map_table, 16384, i);
            column.setMoveable(false);
            column.setText(column_names[i]);
            switch (i) {
                case 0: {
                    column.setWidth(w * 10);
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    column.setWidth(w * 2);
                    break;
                }
                default: {
                    column.setWidth(w);
                }
            }
            ++i;
        }
        this.map_table.setHeaderVisible(true);
        this.map_table.setLinesVisible(true);
        this.map_table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                IMemoryMap.MemoryRegion r = (IMemoryMap.MemoryRegion)((IStructuredSelection)MemoryMapWidget.this.table_viewer.getSelection()).getFirstElement();
                if (r == null) {
                    return;
                }
                MemoryMapWidget.this.editRegion(r);
            }

            public void widgetSelected(SelectionEvent e) {
                MemoryMapWidget.this.update_map_buttons.run();
            }
        });
        this.table_viewer = new TableViewer(this.map_table);
        this.table_viewer.setUseHashlookup(true);
        this.table_viewer.setColumnProperties(column_names);
        this.table_viewer.setContentProvider((IContentProvider)this.content_provider);
        this.table_viewer.setLabelProvider((IBaseLabelProvider)new MapLabelProvider());
        this.createMapButtons(composite);
    }

    private void createMapButtons(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        Menu menu = new Menu((Control)this.map_table);
        SelectionAdapter sel_adapter = null;
        final Button button_add = new Button(composite, 8);
        button_add.setText("&Add...");
        button_add.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String id = MemoryMapWidget.this.ctx_text.getText();
                if (id == null || id.length() == 0) {
                    return;
                }
                HashMap<String, Object> props = new HashMap<String, Object>();
                Image image = ImageCache.getImage("icons/memory-map.gif");
                if (new MemoryMapItemDialog(MemoryMapWidget.this.map_table.getShell(), image, props, true).open() == 0) {
                    props.put("ID", id);
                    ArrayList<TCFMemoryRegion> lst = (ArrayList<TCFMemoryRegion>)MemoryMapWidget.this.cur_maps.get(id);
                    if (lst == null) {
                        lst = new ArrayList<TCFMemoryRegion>();
                        MemoryMapWidget.this.cur_maps.put(id, lst);
                    }
                    lst.add(new TCFMemoryRegion(props));
                    MemoryMapWidget.this.table_viewer.refresh();
                    MemoryMapWidget.this.notifyModifyListeners();
                }
            }
        };
        button_add.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_add = new MenuItem(menu, 8);
        item_add.setText("&Add...");
        item_add.addSelectionListener((SelectionListener)sel_adapter);
        final Button button_edit = new Button(composite, 8);
        button_edit.setText("E&dit...");
        button_edit.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IMemoryMap.MemoryRegion r = (IMemoryMap.MemoryRegion)((IStructuredSelection)MemoryMapWidget.this.table_viewer.getSelection()).getFirstElement();
                if (r == null) {
                    return;
                }
                MemoryMapWidget.this.editRegion(r);
                MemoryMapWidget.this.notifyModifyListeners();
            }
        };
        button_edit.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_edit = new MenuItem(menu, 8);
        item_edit.setText("E&dit...");
        item_edit.addSelectionListener((SelectionListener)sel_adapter);
        final Button button_remove = new Button(composite, 8);
        button_remove.setText("&Remove");
        button_remove.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String id = MemoryMapWidget.this.ctx_text.getText();
                if (id == null || id.length() == 0) {
                    return;
                }
                IMemoryMap.MemoryRegion r = (IMemoryMap.MemoryRegion)((IStructuredSelection)MemoryMapWidget.this.table_viewer.getSelection()).getFirstElement();
                if (r == null) {
                    return;
                }
                ArrayList lst = (ArrayList)MemoryMapWidget.this.cur_maps.get(id);
                if (lst != null && lst.remove(r)) {
                    MemoryMapWidget.this.table_viewer.refresh();
                }
                MemoryMapWidget.this.notifyModifyListeners();
            }
        };
        button_remove.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_remove = new MenuItem(menu, 8);
        item_remove.setText("&Remove");
        item_remove.addSelectionListener((SelectionListener)sel_adapter);
        this.map_table.setMenu(menu);
        this.update_map_buttons = new Runnable(){

            public void run() {
                IMemoryMap.MemoryRegion r = (IMemoryMap.MemoryRegion)((IStructuredSelection)MemoryMapWidget.this.table_viewer.getSelection()).getFirstElement();
                boolean manual = r != null && r.getProperties().get("ID") != null;
                button_add.setEnabled(MemoryMapWidget.this.selected_mem_map_id != null);
                button_edit.setEnabled(r != null);
                button_remove.setEnabled(manual);
                item_add.setEnabled(MemoryMapWidget.this.selected_mem_map_id != null);
                item_edit.setEnabled(r != null);
                item_remove.setEnabled(manual);
            }
        };
        this.update_map_buttons.run();
    }

    private void editRegion(IMemoryMap.MemoryRegion r) {
        int n;
        ArrayList<IMemoryMap.MemoryRegion> lst;
        boolean enable_editing;
        String id = this.ctx_text.getText();
        if (id == null || id.length() == 0) {
            return;
        }
        HashMap<String, Object> props = r.getProperties();
        boolean bl = enable_editing = props.get("ID") != null;
        if (enable_editing) {
            props = new HashMap<String, Object>(props);
        }
        Image image = ImageCache.getImage("icons/memory-map.gif");
        if (new MemoryMapItemDialog(this.map_table.getShell(), image, props, enable_editing).open() == 0 && enable_editing && (lst = this.cur_maps.get(id)) != null && (n = lst.indexOf(r)) >= 0) {
            lst.set(n, (IMemoryMap.MemoryRegion)new TCFMemoryRegion(props));
            this.table_viewer.refresh();
        }
    }

    private void readMemoryMapAttribute() {
        this.cur_maps.clear();
        try {
            new TCFTask<Boolean>(){

                public void run() {
                    try {
                        TCFLaunchDelegate.getMemMapsAttribute((Map)MemoryMapWidget.this.cur_maps, (ILaunchConfiguration)MemoryMapWidget.this.cfg);
                        this.done(true);
                    }
                    catch (Exception e) {
                        this.error(e);
                    }
                }
            }.get();
        }
        catch (Exception x) {
            Activator.log("Invalid launch cofiguration attribute", x);
        }
    }

    private void writeMemoryMapAttribute(ILaunchConfigurationWorkingCopy copy) throws Exception {
        String s = null;
        final ArrayList<Map> lst = new ArrayList<Map>();
        for (ArrayList<IMemoryMap.MemoryRegion> x : this.cur_maps.values()) {
            for (IMemoryMap.MemoryRegion r : x) {
                lst.add(r.getProperties());
            }
        }
        if (lst.size() > 0) {
            s = (String)new TCFTask<String>(){

                public void run() {
                    try {
                        this.done(JSON.toJSON((Object)lst));
                    }
                    catch (IOException e) {
                        this.error(e);
                    }
                }
            }.getIO();
        }
        copy.setAttribute("org.eclipse.tcf.debug.MemoryMap", s);
    }

    public void loadData(ILaunchConfiguration cfg) {
        this.cfg = cfg;
        this.cur_maps.clear();
        this.org_maps.clear();
        this.loadTargetMemoryNodes();
        this.readMemoryMapAttribute();
        for (String id : this.cur_maps.keySet()) {
            this.org_maps.put(id, new ArrayList(this.cur_maps.get(id)));
        }
        Object map_id = this.getSelectedMemoryNode();
        HashSet<String> ids = new HashSet<String>(this.target_map_nodes.keySet());
        if (map_id != null) {
            ids.add((String)map_id);
        }
        ids.addAll(this.cur_maps.keySet());
        Object[] arr = ids.toArray(new String[ids.size()]);
        Arrays.sort(arr);
        this.ctx_text.removeAll();
        Object[] objectArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            this.ctx_text.add((String)id);
            ++n2;
        }
        if (map_id == null && arr.length > 0) {
            map_id = arr[0];
        }
        if (map_id == null) {
            map_id = "";
        }
        this.ctx_text.setText((String)map_id);
    }

    private String getSelectedMemoryNode() {
        if (this.channel == null || this.channel.getState() != 1) {
            return null;
        }
        try {
            return (String)new TCFTask<String>(this.channel){

                public void run() {
                    TCFDataCache<TCFNodeExecContext> mem_cache = MemoryMapWidget.this.model.searchMemoryContext(MemoryMapWidget.this.selection);
                    if (mem_cache == null) {
                        this.error(new Exception("Context does not provide memory access"));
                        return;
                    }
                    if (!mem_cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    if (mem_cache.getError() != null) {
                        this.error(mem_cache.getError());
                        return;
                    }
                    String id = null;
                    TCFNodeExecContext mem_node = (TCFNodeExecContext)mem_cache.getData();
                    if (mem_node != null) {
                        TCFDataCache<TCFNodeExecContext> syms_cache = mem_node.getSymbolsNode();
                        if (!syms_cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        TCFNodeExecContext syms_node = (TCFNodeExecContext)syms_cache.getData();
                        if (syms_node != null) {
                            TCFDataCache<IMemory.MemoryContext> mem_ctx = syms_node.getMemoryContext();
                            if (!mem_ctx.validate((Runnable)((Object)this))) {
                                return;
                            }
                            if (mem_ctx.getData() != null) {
                                if (syms_node.getModel().getLaunch().isMemoryMapPreloadingSupported()) {
                                    TCFDataCache<String> name_cache = syms_node.getFullName();
                                    if (!name_cache.validate((Runnable)((Object)this))) {
                                        return;
                                    }
                                    id = (String)name_cache.getData();
                                } else {
                                    id = ((IMemory.MemoryContext)mem_ctx.getData()).getName();
                                }
                                if (id == null) {
                                    id = syms_node.getID();
                                }
                            }
                        }
                    }
                    this.done(id);
                }
            }.get();
        }
        catch (Exception x) {
            if (this.channel.getState() != 1) {
                return null;
            }
            Activator.log("Cannot get selected memory node", x);
            return null;
        }
    }

    private void loadTargetMemoryNodes() {
        this.target_map_nodes.clear();
        if (this.channel == null || this.channel.getState() != 1) {
            return;
        }
        try {
            new TCFTask<Boolean>(this.channel){

                public void run() {
                    TCFNodeLaunch n = MemoryMapWidget.this.model.getRootNode();
                    if (!this.collectMemoryNodes(n.getFilteredChildren())) {
                        return;
                    }
                    this.done(true);
                }

                private boolean collectMemoryNodes(TCFChildren children) {
                    if (!children.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    Map m = (Map)children.getData();
                    if (m != null) {
                        for (TCFNode n : m.values()) {
                            if (!(n instanceof TCFNodeExecContext)) continue;
                            TCFNodeExecContext exe = (TCFNodeExecContext)n;
                            if (!this.collectMemoryNodes(exe.getChildren())) {
                                return false;
                            }
                            TCFDataCache<TCFNodeExecContext> syms_cache = exe.getSymbolsNode();
                            if (!syms_cache.validate((Runnable)((Object)this))) {
                                return false;
                            }
                            TCFNodeExecContext syms_node = (TCFNodeExecContext)syms_cache.getData();
                            if (syms_node == null) continue;
                            TCFDataCache<IMemory.MemoryContext> mem_ctx = syms_node.getMemoryContext();
                            if (!mem_ctx.validate((Runnable)((Object)this))) {
                                return false;
                            }
                            if (mem_ctx.getData() == null) continue;
                            String id = null;
                            if (syms_node.getModel().getLaunch().isMemoryMapPreloadingSupported()) {
                                TCFDataCache<String> name_cache = syms_node.getFullName();
                                if (!name_cache.validate((Runnable)((Object)this))) {
                                    return false;
                                }
                                id = (String)name_cache.getData();
                            } else {
                                id = ((IMemory.MemoryContext)mem_ctx.getData()).getName();
                            }
                            if (id == null) {
                                id = syms_node.getID();
                            }
                            MemoryMapWidget.this.target_map_nodes.put(id, syms_node);
                        }
                    }
                    return true;
                }
            }.get();
        }
        catch (Exception x) {
            if (this.channel.getState() != 1) {
                return;
            }
            Activator.log("Cannot load target memory context info", x);
        }
    }

    private void loadTargetMemoryMap() {
        this.loaded_files.clear();
        this.target_map.clear();
        this.mem_ctx = null;
        if (this.channel == null || this.channel.getState() != 1) {
            return;
        }
        try {
            new TCFTask<Boolean>(this.channel){

                public void run() {
                    if (MemoryMapWidget.this.selected_mem_map_node != null && !MemoryMapWidget.this.selected_mem_map_node.isDisposed()) {
                        TCFDataCache<IMemory.MemoryContext> mem_cache = MemoryMapWidget.this.selected_mem_map_node.getMemoryContext();
                        if (!mem_cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        if (mem_cache.getError() != null) {
                            this.error(mem_cache.getError());
                            return;
                        }
                        MemoryMapWidget.this.mem_ctx = (IMemory.MemoryContext)mem_cache.getData();
                        TCFDataCache<TCFNodeExecContext.MemoryRegion[]> map_cache = MemoryMapWidget.this.selected_mem_map_node.getMemoryMap();
                        if (!map_cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        if (map_cache.getError() != null) {
                            this.error(map_cache.getError());
                            return;
                        }
                        if (map_cache.getData() != null) {
                            TCFNodeExecContext.MemoryRegion[] memoryRegionArray = (TCFNodeExecContext.MemoryRegion[])map_cache.getData();
                            int n = memoryRegionArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TCFNodeExecContext.MemoryRegion m = memoryRegionArray[n2];
                                Map props = m.region.getProperties();
                                if (props.get("ID") != null) {
                                    String fnm = m.region.getFileName();
                                    if (fnm != null) {
                                        MemoryMapWidget.this.loaded_files.add(fnm);
                                    }
                                } else {
                                    MemoryMapWidget.this.target_map.add(new TCFMemoryRegion(props));
                                }
                                ++n2;
                            }
                        }
                    }
                    this.done(true);
                }
            }.get();
        }
        catch (Exception x) {
            if (this.channel.getState() != 1) {
                return;
            }
            Activator.log("Cannot load target memory map", x);
        }
    }

    public boolean saveData(ILaunchConfigurationWorkingCopy copy) throws Exception {
        ArrayList<IMemoryMap.MemoryRegion> lst;
        boolean loaded_files_ok = true;
        if (this.selected_mem_map_id != null && (lst = this.cur_maps.get(this.selected_mem_map_id)) != null) {
            for (IMemoryMap.MemoryRegion r : lst) {
                String fnm = r.getFileName();
                if (fnm == null || this.loaded_files.contains(fnm)) continue;
                loaded_files_ok = false;
            }
            if (lst.size() == 0) {
                this.cur_maps.remove(this.selected_mem_map_id);
            }
        }
        if (!loaded_files_ok || !this.org_maps.equals(this.cur_maps)) {
            this.writeMemoryMapAttribute(copy);
            return true;
        }
        return false;
    }

    public void addModifyListener(ModifyListener l) {
        this.modify_listeners.add(l);
    }

    private void notifyModifyListeners() {
        for (ModifyListener l : this.modify_listeners) {
            l.modifyText(null);
        }
    }

    private class MapLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private MapLabelProvider() {
        }

        public Image getColumnImage(Object element, int column) {
            return null;
        }

        public String getColumnText(Object element, int column) {
            TCFMemoryRegion r = (TCFMemoryRegion)element;
            switch (column) {
                case 0: {
                    return r.getFileName();
                }
                case 1: 
                case 2: {
                    int l;
                    BigInteger x;
                    BigInteger bigInteger = x = column == 1 ? r.addr : r.size;
                    if (x == null) {
                        return "";
                    }
                    String s = x.toString(16);
                    int sz = 0;
                    if (MemoryMapWidget.this.mem_ctx != null) {
                        sz = MemoryMapWidget.this.mem_ctx.getAddressSize() * 2;
                    }
                    if ((l = sz - s.length()) < 0) {
                        l = 0;
                    }
                    if (l > 16) {
                        l = 16;
                    }
                    return String.valueOf("0x0000000000000000".substring(0, 2 + l)) + s;
                }
                case 3: {
                    int n = r.getFlags();
                    StringBuffer bf = new StringBuffer();
                    if ((n & 1) != 0) {
                        bf.append('r');
                    }
                    if ((n & 2) != 0) {
                        bf.append('w');
                    }
                    if ((n & 4) != 0) {
                        bf.append('x');
                    }
                    return bf.toString();
                }
                case 4: {
                    Number n = r.getOffset();
                    if (n != null) {
                        BigInteger x = JSON.toBigInteger((Number)n);
                        String s = x.toString(16);
                        int l = 16 - s.length();
                        if (l < 0) {
                            l = 0;
                        }
                        if (l > 16) {
                            l = 16;
                        }
                        return String.valueOf("0x0000000000000000".substring(0, 2 + l)) + s;
                    }
                    String s = r.getSectionName();
                    if (s != null) {
                        return s;
                    }
                    return "";
                }
            }
            return "";
        }

        public Color getBackground(Object element, int columnIndex) {
            return MemoryMapWidget.this.map_table.getBackground();
        }

        public Color getForeground(Object element, int columnIndex) {
            TCFMemoryRegion r = (TCFMemoryRegion)element;
            if (r.getProperties().get("ID") != null) {
                String fnm = r.getFileName();
                if (fnm != null && MemoryMapWidget.this.loaded_files.contains(fnm)) {
                    return MemoryMapWidget.this.map_table.getDisplay().getSystemColor(6);
                }
                return MemoryMapWidget.this.map_table.getDisplay().getSystemColor(10);
            }
            return MemoryMapWidget.this.map_table.getForeground();
        }

        public String getText(Object element) {
            return element.toString();
        }
    }
}

