/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.internal.debug.ui.preferences.DecoratingIntegerFieldEditor;
import org.eclipse.tcf.internal.debug.ui.preferences.IntegerWithBooleanFieldEditor;
import org.eclipse.tcf.internal.debug.ui.preferences.TCFPreferences;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TCFDebugPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public TCFDebugPreferencePage() {
        super(0);
        this.setPreferenceStore(TCFPreferences.getPreferenceStore());
        this.setDescription("General settings for debuggers using Target Communication Framework (TCF)");
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        this.createPerformanceGroup(parent);
        this.createStackTraceGroup(parent);
    }

    private void createPerformanceGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Performance");
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        BooleanFieldEditor autoThreadListUpdates = new BooleanFieldEditor("AutoChildrenListUpdates", "Automatic children list updates in the Debug View", (Composite)group);
        autoThreadListUpdates.fillIntoGrid((Composite)group, 3);
        this.addField((FieldEditor)autoThreadListUpdates);
        BooleanFieldEditor delayThreadListUpdates = new BooleanFieldEditor("DelayChildrenListUpdates", "Delay children list updates in the Debug View until a child context is suspended", (Composite)group);
        delayThreadListUpdates.fillIntoGrid((Composite)group, 3);
        this.addField((FieldEditor)delayThreadListUpdates);
        BooleanFieldEditor syncSteppingEditor = new BooleanFieldEditor("WaitForPCUpdateAfterStep", "Wait for editor marker to update after every step", (Composite)group);
        syncSteppingEditor.fillIntoGrid((Composite)group, 3);
        this.addField((FieldEditor)syncSteppingEditor);
        BooleanFieldEditor syncViewsEditor = new BooleanFieldEditor("WaitForViewsUpdateAfterStep", "Wait for views to update after every step", (Composite)group);
        syncViewsEditor.fillIntoGrid((Composite)group, 3);
        this.addField((FieldEditor)syncViewsEditor);
        BooleanFieldEditor delayStackEditor = new BooleanFieldEditor("DelayStackUpdateUntilLastStep", "Delay stack trace update util last step", (Composite)group);
        delayStackEditor.fillIntoGrid((Composite)group, 3);
        this.addField((FieldEditor)delayStackEditor);
        DecoratingIntegerFieldEditor minStepIntervalEditor = new DecoratingIntegerFieldEditor("MinStepInterval", "Minimum interval between steps (in milliseconds)", (Composite)group);
        minStepIntervalEditor.setValidRange(0, 10000);
        minStepIntervalEditor.fillIntoGrid((Composite)group, 3);
        this.addField((FieldEditor)minStepIntervalEditor);
        DecoratingIntegerFieldEditor minUpdateIntervalEditor = new DecoratingIntegerFieldEditor("MinUpdateInterval", "Minimum interval between view updates (in milliseconds)", (Composite)group);
        minUpdateIntervalEditor.setValidRange(0, 10000);
        minUpdateIntervalEditor.fillIntoGrid((Composite)group, 3);
        this.addField((FieldEditor)minUpdateIntervalEditor);
        BooleanFieldEditor updatesThrottleEditor = new BooleanFieldEditor("ViewUpdatesThrottle", "Reduce views updates frequency during UI jobs congestion", (Composite)group);
        updatesThrottleEditor.fillIntoGrid((Composite)group, 3);
        this.addField((FieldEditor)updatesThrottleEditor);
        BooleanFieldEditor trafficThrottleEditor = new BooleanFieldEditor("TargetTrafficThrottle", "Reduce data requests frequency during target traffic congestion", (Composite)group);
        trafficThrottleEditor.fillIntoGrid((Composite)group, 3);
        this.addField((FieldEditor)trafficThrottleEditor);
        group.setLayout((Layout)layout);
    }

    private void createStackTraceGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Stack trace");
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        BooleanFieldEditor showArgNamesEditor = new BooleanFieldEditor("StackFrameArgNames", "Show function argument names in stack frames", (Composite)group);
        showArgNamesEditor.fillIntoGrid((Composite)group, 3);
        this.addField((FieldEditor)showArgNamesEditor);
        BooleanFieldEditor showArgValuesEditor = new BooleanFieldEditor("StackFrameArgValues", "Show function argument values in stack frames", (Composite)group);
        showArgValuesEditor.fillIntoGrid((Composite)group, 3);
        this.addField((FieldEditor)showArgValuesEditor);
        IntegerWithBooleanFieldEditor limitEditor = new IntegerWithBooleanFieldEditor("StackFrameLimitEnabled", "StackFrameLimitValue", "Limit number of stack frames to", (Composite)group);
        limitEditor.setValidRange(1, Integer.MAX_VALUE);
        limitEditor.setValidateStrategy(1);
        limitEditor.fillIntoGrid((Composite)group, 3);
        this.addField((FieldEditor)limitEditor);
        group.setLayout((Layout)layout);
    }
}

