/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.controls;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.tcf.filesystem.core.model.ITreeNodeModel;
import org.eclipse.tcf.te.tcf.filesystem.ui.controls.NavigatorContentProvider;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.processes.core.model.ProcessModel;
import org.eclipse.tcf.te.tcf.processes.core.model.ProcessTreeNode;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.navigator.NavigatorFilterService;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorFilterService;

public class ProcessNavigatorContentProvider
extends NavigatorContentProvider
implements ICommonContentProvider,
ITreeViewerListener {
    private static final String SINGLE_THREAD_FILTER_ID = "org.eclipse.tcf.te.tcf.processes.ui.navigator.filter.singleThread";

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.viewer.addTreeListener((ITreeViewerListener)this);
        this.refreshChildren(newInput);
    }

    public void dispose() {
        super.dispose();
        this.viewer.removeTreeListener((ITreeViewerListener)this);
    }

    protected ITreeNodeModel doGetModel(IPeerModel peerNode) {
        return ProcessModel.getProcessModel((IPeerModel)peerNode);
    }

    public void init(ICommonContentExtensionSite config) {
        INavigatorFilterService fs;
        Assert.isNotNull((Object)config);
        INavigatorContentService cs = config.getService();
        INavigatorFilterService iNavigatorFilterService = fs = cs != null ? cs.getFilterService() : null;
        if (fs != null && !fs.isActive(SINGLE_THREAD_FILTER_ID) && fs instanceof NavigatorFilterService) {
            final NavigatorFilterService navFilterService = (NavigatorFilterService)fs;
            navFilterService.addActiveFilterIds(new String[]{SINGLE_THREAD_FILTER_ID});
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    navFilterService.updateViewer();
                }
            });
        }
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        Object element = event.getElement();
        this.refreshChildren(element);
    }

    private void refreshChildren(Object object) {
        if (object instanceof ProcessTreeNode) {
            ProcessTreeNode parent = (ProcessTreeNode)object;
            if (parent.childrenQueried && !parent.childrenQueryRunning) {
                ProcessModel pModel = ProcessModel.getProcessModel((IPeerModel)parent.peerNode);
                pModel.refreshChildren(parent);
            }
        }
    }
}

