/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.persistence;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.persistence.AbstractGsonMapPersistenceDelegate;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModelProvider;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerModel;

public class GsonPeerPersistenceDelegate
extends AbstractGsonMapPersistenceDelegate {
    public GsonPeerPersistenceDelegate() {
        super("json");
    }

    public Class<?> getPersistedClass(Object context) {
        return IPeer.class;
    }

    public Object read(Object context, Object container, String key) throws IOException {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)container);
        final IPeer peer = (IPeer)super.read(context, container, key);
        if (peer != null) {
            if (context instanceof IPeer || IPeer.class.equals(context)) {
                return peer;
            }
            if (context instanceof Class && ((Class)context).isAssignableFrom(IPeerModel.class)) {
                final AtomicReference model = new AtomicReference();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        String id = peer.getID();
                        if (id != null) {
                            IPeerModel peerModel = Model.getModel().getService(ILocatorModelLookupService.class).lkupPeerModelById(id);
                            if (peerModel == null) {
                                peerModel = new PeerModel(Model.getModel(), peer);
                                peerModel.setProperty("isghost", true);
                            }
                            model.set(peerModel);
                        }
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeAndWait((Runnable)runnable);
                }
                return model.get();
            }
        }
        return null;
    }

    protected Map<String, Object> toMap(Object context) throws IOException {
        IPeer peer = this.getPeer(context);
        if (peer != null) {
            return super.toMap((Object)peer.getAttributes());
        }
        return new HashMap<String, Object>();
    }

    protected Object fromMap(Map<String, Object> map, Object context) throws IOException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            attrs.put(entry.getKey(), entry.getValue().toString());
        }
        return new TransientPeer(attrs);
    }

    protected IPeer getPeer(Object context) {
        IPeer peer = null;
        if (context instanceof IPeer) {
            peer = (IPeer)context;
        } else if (context instanceof IPeerModel) {
            peer = ((IPeerModel)context).getPeer();
        } else if (context instanceof IPeerModelProvider) {
            peer = ((IPeerModelProvider)context).getPeerModel().getPeer();
        }
        return peer;
    }
}

