/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.protocol.IErrorReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorReport
extends Exception
implements IErrorReport {
    private static final long serialVersionUID = 3687543884858739977L;
    private final Map<String, Object> attrs;

    public ErrorReport(String msg, Map<String, Object> attrs) {
        super(msg);
        this.attrs = attrs;
        Object caused_by = attrs.get("CausedBy");
        if (caused_by != null) {
            Map map = (Map)caused_by;
            StringBuffer bf = new StringBuffer();
            bf.append("TCF error report:");
            bf.append('\n');
            Command.appendErrorProps(bf, map);
            this.initCause(new ErrorReport(bf.toString(), map));
        }
    }

    public ErrorReport(String msg, int code) {
        super(msg);
        this.attrs = new HashMap<String, Object>();
        this.attrs.put("Code", code);
        this.attrs.put("Time", System.currentTimeMillis());
        this.attrs.put("Format", msg);
        this.attrs.put("Severity", 0);
    }

    @Override
    public int getErrorCode() {
        Number n = (Number)this.attrs.get("Code");
        if (n == null) {
            return 0;
        }
        return n.intValue();
    }

    @Override
    public int getAltCode() {
        Number n = (Number)this.attrs.get("AltCode");
        if (n == null) {
            return 0;
        }
        return n.intValue();
    }

    @Override
    public String getAltOrg() {
        return (String)this.attrs.get("AltOrg");
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attrs;
    }
}

