/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.services.remote;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IStackTrace;

public class StackTraceProxy
implements IStackTrace {
    private final IChannel channel;

    public StackTraceProxy(IChannel channel) {
        this.channel = channel;
    }

    public IToken getChildren(String parent_context_id, final IStackTrace.DoneGetChildren done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getChildren", (Object[])new Object[]{parent_context_id}){

            public void done(Exception error, Object[] args) {
                String[] arr = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    arr = StackTraceProxy.this.toStringArray(args[1]);
                }
                done.doneGetChildren(this.token, error, arr);
            }
        }.token;
    }

    public IToken getContext(String[] id, final IStackTrace.DoneGetContext done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getContext", (Object[])new Object[]{id}){

            public void done(Exception error, Object[] args) {
                IStackTrace.StackTraceContext[] arr = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[1]);
                    arr = StackTraceProxy.this.toContextArray(args[0]);
                }
                done.doneGetContext(this.token, error, arr);
            }
        }.token;
    }

    public String getName() {
        return "StackTrace";
    }

    private IStackTrace.StackTraceContext[] toContextArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        int n = 0;
        IStackTrace.StackTraceContext[] ctx = new IStackTrace.StackTraceContext[c.size()];
        for (Map m : c) {
            ctx[n++] = new Context(m);
        }
        return ctx;
    }

    private String[] toStringArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        return c.toArray(new String[c.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Context
    implements IStackTrace.StackTraceContext {
        private final Map<String, Object> props;

        Context(Map<String, Object> props) {
            if (props == null) {
                props = new HashMap<String, Object>();
            }
            this.props = props;
        }

        @Override
        public Number getArgumentsAddress() {
            return (Number)this.props.get("ArgsAddr");
        }

        @Override
        public int getArgumentsCount() {
            Number n = (Number)this.props.get("ArgsCnt");
            if (n == null) {
                return 0;
            }
            return n.intValue();
        }

        @Override
        public Number getFrameAddress() {
            return (Number)this.props.get("FP");
        }

        @Override
        public String getID() {
            return (String)this.props.get("ID");
        }

        @Override
        public String getName() {
            return (String)this.props.get("Name");
        }

        @Override
        public String getParentID() {
            return (String)this.props.get("ParentID");
        }

        @Override
        public Number getReturnAddress() {
            return (Number)this.props.get("RP");
        }

        @Override
        public Number getInstructionAddress() {
            return (Number)this.props.get("IP");
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.props;
        }
    }
}

