/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.forms.parts;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.ui.forms.parts.AbstractPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractPartWithButtons
extends AbstractPart {
    private final List<String> labels;
    private Button[] buttons = null;

    public AbstractPartWithButtons(String[] labels) {
        Assert.isNotNull((Object)labels);
        this.labels = Arrays.asList(labels);
    }

    @Override
    public void createControl(Composite parent, int style, int span, FormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        this.createMainLabel(parent, span, toolkit);
        this.createMainControl(parent, style, span - (this.labels != null && this.labels.size() > 0 ? 1 : 0), toolkit);
        this.createButtonsPanel(parent, toolkit);
    }

    protected abstract void createMainControl(Composite var1, int var2, int var3, FormToolkit var4);

    protected void createMainLabel(Composite parent, int span, FormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
    }

    protected Composite createButtonsPanel(Composite parent, FormToolkit toolkit) {
        if (this.labels == null || this.labels.size() == 0) {
            return null;
        }
        this.buttons = new Button[this.labels.size()];
        Composite panel = this.createComposite(parent, toolkit);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        GridData layoutData = new GridData(1, 4, false, true);
        panel.setLayoutData((Object)layoutData);
        panel.setBackground(parent.getBackground());
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPartWithButtons.this.onButtonSelected((Button)e.widget);
            }
        };
        int i = 0;
        while (i < this.labels.size()) {
            if (this.labels.get(i) != null) {
                Button button = toolkit != null ? toolkit.createButton(panel, null, 8) : new Button(panel, 8);
                Assert.isNotNull((Object)button);
                button.setFont(JFaceResources.getDialogFont());
                button.setText(this.labels.get(i));
                button.setData((Object)i);
                button.setBackground(panel.getBackground());
                button.addSelectionListener((SelectionListener)listener);
                this.onButtonCreated(button);
                layoutData = new GridData(4, 1, true, false);
                layoutData.widthHint = Math.max(new PixelConverter((Control)button).convertHorizontalDLUsToPixels(61), button.computeSize((int)-1, (int)-1, (boolean)true).x);
                button.setLayoutData((Object)layoutData);
                this.buttons[i] = button;
            } else {
                this.createEmptySpace(panel, 1, toolkit);
            }
            ++i;
        }
        return panel;
    }

    protected void onButtonCreated(Button button) {
        Assert.isNotNull((Object)button);
    }

    protected void onButtonSelected(Button button) {
        Assert.isNotNull((Object)button);
    }

    @Override
    protected void onEnabledStateChanged() {
        Button[] buttonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            if (button != null && !button.isDisposed()) {
                button.setEnabled(this.isEnabled());
            }
            ++n2;
        }
    }

    public Button getButton(String label) {
        if (this.labels == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getButton(this.labels.indexOf(label));
    }

    public Button getButton(int index) {
        if (this.buttons == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.buttons[index];
    }
}

