/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.ui.remote.app;

import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.te.launch.core.persistence.DefaultPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.persistence.launchcontext.LaunchContextsPersistenceDelegate;
import org.eclipse.tcf.te.launch.ui.interfaces.ILaunchConfigurationTabFormPart;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.dialogs.FSOpenFileDialog;
import org.eclipse.tcf.te.tcf.launch.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.BaseEditBrowseTextControl;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class LaunchConfigurationMainTabSection
extends AbstractSection
implements ILaunchConfigurationTabFormPart {
    BaseEditBrowseTextControl processImage;
    BaseEditBrowseTextControl processArguments;
    IModelNode firstSelection = null;

    public LaunchConfigurationMainTabSection(IManagedForm form, Composite parent) {
        super(form, parent, 66);
        this.getSection().setBackground(parent.getBackground());
        this.createClient(this.getSection(), form.getToolkit());
    }

    protected void createClient(final Section section, FormToolkit toolkit) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)toolkit);
        section.setText(Messages.LaunchConfigurationMainTabSection_title);
        section.setLayoutData((Object)new GridData(272, 0x1000000, true, false));
        Composite client = this.createClientContainer((Composite)section, 3, toolkit);
        Assert.isNotNull((Object)client);
        section.setClient((Control)client);
        client.setBackground(section.getBackground());
        this.createSectionToolbar(section, toolkit);
        this.processImage = new BaseEditBrowseTextControl(null){

            protected void onButtonControlSelected() {
                if (LaunchConfigurationMainTabSection.this.firstSelection != null) {
                    String absPath;
                    Object candidate;
                    FSOpenFileDialog dialog = new FSOpenFileDialog(section.getShell());
                    dialog.setInput((Object)LaunchConfigurationMainTabSection.this.firstSelection);
                    if (dialog.open() == 0 && (candidate = dialog.getFirstResult()) instanceof FSTreeNode && (absPath = ((FSTreeNode)candidate).getLocation()) != null) {
                        LaunchConfigurationMainTabSection.this.processImage.setEditFieldControlText(absPath);
                    }
                }
            }

            public void modifyText(ModifyEvent e) {
                super.modifyText(e);
                LaunchConfigurationMainTabSection.this.getManagedForm().dirtyStateChanged();
            }
        };
        this.processImage.setEditFieldLabel(Messages.LaunchConfigurationMainTabSection_processImage_label);
        this.processImage.setIsGroup(false);
        this.processImage.setHideBrowseButton(false);
        this.processImage.setAdjustBackgroundColor(true);
        this.processImage.setParentControlIsInnerPanel(true);
        this.processImage.setFormToolkit(toolkit);
        this.processImage.setupPanel(client);
        this.processImage.doCreateControlDecoration(this.processImage.getEditFieldControl());
        this.processArguments = new BaseEditBrowseTextControl(null){

            public void modifyText(ModifyEvent e) {
                super.modifyText(e);
                LaunchConfigurationMainTabSection.this.getManagedForm().dirtyStateChanged();
            }
        };
        this.processArguments.setEditFieldLabel(Messages.LaunchConfigurationMainTabSection_processArguments_label);
        this.processArguments.setIsGroup(false);
        this.processArguments.setHideBrowseButton(true);
        this.processArguments.setAdjustBackgroundColor(true);
        this.processArguments.setParentControlIsInnerPanel(true);
        this.processArguments.setFormToolkit(toolkit);
        this.processArguments.setupPanel(client);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        Assert.isNotNull((Object)configuration);
        if (this.processImage != null) {
            String image = DefaultPersistenceDelegate.getAttribute((ILaunchConfiguration)configuration, (String)"org.eclipse.tcf.te.launch.process_image", (String)"");
            this.processImage.setEditFieldControlText(image);
        }
        if (this.processArguments != null) {
            String arguments = DefaultPersistenceDelegate.getAttribute((ILaunchConfiguration)configuration, (String)"org.eclipse.tcf.te.launch.process_arguments", (String)"");
            this.processArguments.setEditFieldControlText(arguments);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Assert.isNotNull((Object)configuration);
        if (this.processImage != null) {
            String image = this.processImage.getEditFieldControlText();
            if (image != null && image.trim().length() > 0) {
                DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)configuration, (String)"org.eclipse.tcf.te.launch.process_image", (String)image);
            } else {
                DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)configuration, (String)"org.eclipse.tcf.te.launch.process_image", null);
            }
        } else {
            DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)configuration, (String)"org.eclipse.tcf.te.launch.process_image", null);
        }
        if (this.processArguments != null) {
            String arguments = this.processArguments.getEditFieldControlText();
            if (arguments != null && arguments.trim().length() > 0) {
                DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)configuration, (String)"org.eclipse.tcf.te.launch.process_arguments", (String)arguments);
            } else {
                DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)configuration, (String)"org.eclipse.tcf.te.launch.process_arguments", null);
            }
        } else {
            DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)configuration, (String)"org.eclipse.tcf.te.launch.process_arguments", null);
        }
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        this.firstSelection = null;
        IModelNode[] contexts = LaunchContextsPersistenceDelegate.getLaunchContexts((ILaunchConfiguration)configuration);
        if (contexts != null && contexts.length > 0) {
            this.firstSelection = contexts[0];
        }
        this.processImage.getButtonControl().setEnabled(this.firstSelection != null);
        if (this.processImage.getEditFieldControlText().trim().length() > 0) {
            this.setMessage(null, 0);
        } else {
            this.setMessage(Messages.LaunchConfigurationMainTabSection_error_missingProcessImage, 3);
        }
        this.processImage.updateControlDecoration(this.getMessage(), this.getMessageType());
        return this.processImage.getEditFieldControlText().trim().length() > 0;
    }
}

