/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.internal.utils;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.tcf.te.ui.activator.UIPlugin;
import org.eclipse.tcf.te.ui.interfaces.ISearchCallback;
import org.eclipse.tcf.te.ui.internal.utils.AbstractSearcher;
import org.eclipse.tcf.te.ui.internal.utils.BreadthFirstSearcher;
import org.eclipse.tcf.te.ui.internal.utils.DelegateProgressMonitor;
import org.eclipse.tcf.te.ui.internal.utils.DepthFirstSearcher;
import org.eclipse.tcf.te.ui.internal.utils.SearchMatcher;
import org.eclipse.tcf.te.ui.nls.Messages;

public class SearchEngine {
    AbstractSearcher fSearcher;
    Job fSearchJob;
    TreeViewer fViewer;
    boolean fDepthFirst;
    SearchMatcher fMatcher;
    TreePath fStartPath;
    boolean fWrap;
    TreePath fLastResult;

    private SearchEngine(TreeViewer viewer) {
        this.fViewer = viewer;
        this.fMatcher = new SearchMatcher(viewer);
        this.fSearcher = new BreadthFirstSearcher(this.fViewer, this.fMatcher);
    }

    public static SearchEngine getSearchEngine(TreeViewer viewer) {
        SearchEngine searcher = (SearchEngine)viewer.getData("search.engine");
        if (searcher == null) {
            searcher = new SearchEngine(viewer);
            viewer.setData("search.engine", (Object)searcher);
        }
        return searcher;
    }

    public boolean isDepthFirst() {
        return this.fDepthFirst;
    }

    public void setDepthFirst(boolean depthFirst) {
        if (this.fDepthFirst != depthFirst) {
            this.fDepthFirst = depthFirst;
            this.fSearcher = this.fDepthFirst ? new DepthFirstSearcher(this.fViewer, this.fMatcher) : new BreadthFirstSearcher(this.fViewer, this.fMatcher);
        }
    }

    public SearchMatcher getMatcher() {
        return this.fMatcher;
    }

    public void setStartPath(TreePath path) {
        this.fStartPath = path;
        if (this.fSearcher != null) {
            this.fSearcher.setStartPath(path);
        }
    }

    public void resetPath() {
        if (this.fSearcher != null) {
            this.fSearcher.setStartPath(this.fStartPath);
        }
    }

    public void endSearch() {
        if (this.fSearchJob != null) {
            this.fSearchJob.cancel();
            this.fSearchJob = null;
        }
    }

    public void startSearch(final ISearchCallback callback, final ProgressMonitorPart pmpart) {
        final TreePath[] result = new TreePath[1];
        this.fSearchJob = new Job(Messages.TreeViewerSearchDialog_JobName){

            protected IStatus run(IProgressMonitor monitor) {
                monitor = new DelegateProgressMonitor((IProgressMonitor)monitor, pmpart);
                monitor.beginTask(Messages.TreeViewerSearchDialog_MainTaskName, -1);
                try {
                    try {
                        result[0] = SearchEngine.this.fSearcher.searchNext((IProgressMonitor)monitor);
                    }
                    catch (InvocationTargetException e) {
                        Status status;
                        Status status2 = status = new Status(4, UIPlugin.getUniqueIdentifier(), e.getMessage(), (Throwable)e);
                        monitor.done();
                        return status2;
                    }
                    catch (InterruptedException interruptedException) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        this.fSearchJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                SearchEngine.this.fViewer.getTree().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IStatus status = event.getResult();
                        TreePath treePath = result[0];
                        if (callback != null) {
                            callback.searchDone(status, treePath);
                        }
                        SearchEngine.this.searchDone(status, treePath);
                        (this).SearchEngine.this.fSearchJob = null;
                        if (status.isOK() && treePath == null && (this).SearchEngine.this.fWrap && (this).SearchEngine.this.fLastResult != null) {
                            (this).SearchEngine.this.fLastResult = null;
                            SearchEngine.this.startSearch(callback, pmpart);
                        }
                    }
                });
            }
        });
        this.fSearchJob.schedule();
    }

    public void setForeward(boolean foreward) {
        if (this.fDepthFirst) {
            ((DepthFirstSearcher)this.fSearcher).setForeward(foreward);
        }
    }

    void searchDone(IStatus status, TreePath path) {
        if (status.isOK()) {
            if (path != null) {
                this.fLastResult = path;
                this.fViewer.expandToLevel((Object)path, 0);
                this.fViewer.setSelection((ISelection)new StructuredSelection(new Object[]{path}), true);
            } else if (this.fWrap && this.fLastResult != null) {
                this.setStartPath(this.fLastResult);
            }
        }
    }

    public boolean isWrap() {
        return this.fWrap;
    }

    public void setWrap(boolean w) {
        this.fWrap = w;
    }

    public void setLastResult(TreePath path) {
        this.fLastResult = path;
    }

    public TreePath getLastResult() {
        return this.fLastResult;
    }
}

